<?php
function smarty_function_run_guest_mailinglist($params, &$smarty)
{	
	global $site;
	
	$name = $params['name'];
	$user = $params['user'];
	$manual = $params['manual'];
	$confirmation_code = $params['confirmation_code'];
	
	$stat = get_guest_mailinglist_stat();
	
	$guest_mailing_list = get_quest_mailinglist();
	$last_runtime = $stat['last_runtime'];	
	$next_runtime = $stat['next_runtime'];
	$date_diff = $stat['diff'];
	$current_date = date('Y-m-d H:i:s');
	
	$run = 0;
	
	# auto send
	if($date_diff >= 7){
		$run = 1;
	}else{
		$run = 0;
	}
	
	# manual send
	if($user && $manual && $confirmation_code == 1){
		$run = 1;
	}
	
	if($run == 1){
		
		$sent_article_count = 0;
		$sent_email_count = 0;
				
		foreach($guest_mailing_list as $email=>$objekt){
			
			$article_count = 0;
			
			$html = '';
			// html header images
			$html .= '<img src="http://www.fi.ee/failid/header.gif">';
			$html .= '<div style="padding:20px;">';
			
			foreach($objekt as $key=>$data){
				
				$objekt_id = $data[0];
				#$last_runtime = $data[1];
				
				$section_data 	= get_section_title($objekt_id);
				$section_title 	= $section_data['pealkiri_strip'];
				$articles 		= get_section_articles($objekt_id, $last_runtime);
				
				if(count($articles) > 0){
				
					$html .= "<h1 style='font-color:#B92D2E; font-family: Times new roman; font-size:14px; border-bottom:1px solid #B92D2E; padding:0 0 10px 0;'>$section_title</h1>";
					foreach($articles as $article){
						
						$article_count = $article_count + 1;
						
						$html .= '<h2 style="font-color:#B92D2E; padding:0; margin:0; font-family: Times new roman; font-size:12px;">
									<a style="font-color:#B92D2E; text-decoration:none;" href="http://www.fi.ee?id='.$article['objekt_id'].'" target="_blank">
									<font color="#B92D2E" style="font-size:12px; font-family:Arial;">'.$article['pealkiri_strip'].'</font></a></h2>';
						$html .= $article['lyhi'];
						$html .= $article['sisu'];
						//$html .= trim($article['sisu']);
						$html .= '<p style="border-bottom:1px dashed #CCCCCC;"></p>';
					}
					$html .= '<br>';
				}
			}
			
			// Footer images
			$html .= '</div>';
			$html .= '<div style="text-align:right; border-top:4px solid #B92D2E;"><br><img src="http://www.fi.ee/failid/footer_logo.gif"></div>';
			
			if($article_count > 0){
				
				send_quest_mail($email, $html);
				$sent_email_count = $sent_email_count+1;
			}
		}
	}
	
	# user or system
	$user_id = $site->user->id;
	if($user_id){
		$user = $site->user->name;
	}else{
		$user = 'system';
	}
	
	# update stat
	if($run == 1){
		$sql = "INSERT INTO guest_mailinglist_stat (last_runtime, sent_emails, run_user) VALUES (NOW(), '$sent_email_count', '$user')";
		$result = new SQL($sql);
	}
}
function send_quest_mail($email, $html){
	
	# send email
	$to  = $email; // note the comma
	$subject = 'Finantsinpektsiooni uudised.';
	$message = $html;

	$headers  = 'MIME-Version: 1.0' . "\r\n";
	$headers .= 'Content-type: text/html; charset=utf-8' . "\r\n";

	#$headers .= 'To: '.$email."\r\n";
	$headers .= 'From: Finantsinspektsioon <info@fi.ee>' . "\r\n";
	#$headers .= 'Cc: birthdayarchive@example.com' . "\r\n";
	#$headers .= 'Bcc: temaatik@gmail.com' . "\r\n";
	
	#echo $message;
	
	#echo "$to, $subject, $message, $headers";
	
	// Mail it
	mail($to, $subject, $message, $headers);
}
function get_quest_mailinglist(){
	
	$sql = "SELECT * FROM guest_mailinglist";
	
	$result = new SQL($sql);
	$out = array();
	while($data = $result->fetch('ASSOC')){
		$email = $data['email'];
		$out[$email][] = array($data['objekt_id'], $data['last_runtime']);
	}
	
	return($out);
}
function get_section_title($objekt_id){
	$sql = "SELECT * FROM objekt WHERE objekt_id = $objekt_id";
	$result = new SQL($sql);
	$out = array();
	while($data = $result->fetch('ASSOC')){
		$out = $data;
	}
	
	return($out);
}
function get_section_articles($section_id, $last_runtime){
	
	$sql = "SELECT * FROM obj_artikkel AS OA 
			LEFT JOIN objekt AS O
			ON OA.objekt_id = O.objekt_id
			LEFT JOIN objekt_objekt AS OO
			ON OA.objekt_id = OO.objekt_id
			WHERE OO.parent_id = $section_id
			AND O.created_time >= '$last_runtime'
			AND O.on_avaldatud = 1";
	
	$result = new SQL($sql);
	$out = array();
	while($data = $result->fetch('ASSOC')){
		$out[] = $data;
	}
	
	return($out);
}
function get_guest_mailinglist_stat(){
	
	$sql = "SELECT *, (last_runtime + INTERVAL 7 DAY) as next_runtime, DATEDIFF(NOW(), last_runtime) as diff FROM guest_mailinglist_stat ORDER BY ID DESC LIMIT 1";
	$result = new SQL($sql);
	$out = array();
	while($data = $result->fetch('ASSOC')){
		$out = $data;
	}
	
	return $out;
}