<?php

$webroot_path = '../../../'; # if admin-page is located in folder /extensions/sample/admin/

$class_path = $webroot_path.'classes/';

# File "check_adminpage.php" must be included at the top of the custom admin-page,
# if access is not granted to the current user then page load will be terminated and login-page is displayed.

include($webroot_path."admin/check_adminpage.php");

include_once($class_path.'adminpage.inc.php');

include_once('../lib/functions.inc.php');

$adminpage_names = get_adminpage_name(array('script_name' => $site->script_name));

$settings = get_extension_admin_page_settings('saurus4_estidcard');

if($site->fdat['action'] == 'save_settings')
{
	$settings['idcard_auth_enabled']['value'] = (int)$site->fdat['idcard_auth_enabled'];
	$settings['idcard_use_ocsp']['value'] = (int)$site->fdat['idcard_use_ocsp'];
	$settings['idcard_create_user']['value'] = (int)$site->fdat['idcard_create_user'];
	$settings['idcard_user_profile_id']['value'] = (int)$site->fdat['idcard_user_profile_id'];
	$settings['idcard_user_group_id']['value'] = (int)$site->fdat['idcard_user_group_id'];
	$settings['idcard_oscp_issuers']['value'] = (array)$site->fdat['idcard_oscp_issuers'];
	$settings['idcard_openssl_bin']['value'] = (string)$site->fdat['idcard_openssl_bin'];
	$settings['idcard_temp_dir']['value'] = (string)$site->fdat['idcard_temp_dir'];
	
	$settings = save_extension_admin_page_settings('saurus4_estidcard', $settings);
}

$sql = "SELECT profile_id, name, is_default FROM object_profiles WHERE source_table = 'users'";
$profiles = new SQL($sql);

$sql = "SELECT group_id AS id, parent_group_id AS parent, name FROM groups ORDER BY name";
$result = new SQL($sql);
while ($row = $result->fetch('ASSOC'))
{
	$groups_tree[] = $row;
}

if(empty($settings))
{
	$default_group_id = 0;
	$sql = "SELECT group_id FROM groups WHERE is_predefined = '1' LIMIT 1";
	$result = new SQL($sql);
	$default_group_id = $result->fetchsingle();
	
	$default_profile_id = 0;
	$sql = "SELECT profile_id FROM object_profiles WHERE is_predefined = '1' AND source_table = 'users' LIMIT 1";
	$result = new SQL($sql);
	$default_profile_id = $result->fetchsingle();
	
	$oscp_issuers = array();
	
	// EID-SK - CA for alternative ID cards until 13.01.2007
	$ocsp_issuers['EID-SK']['CA_CERT_FILE'] = 'certs/eid_sk.pem';
	// OCSP server adress for this CA
	$ocsp_issuers['EID-SK']['OCSP_SERVER_URL'] = 'http://ocsp.sk.ee';
	// OCSP responder certificate location for this CA
	$ocsp_issuers['EID-SK']['OCSP_SERVER_CERT_FILE'] = 'certs/eid_sk_ocsp.pem';
	
	// EID-SK - CA for alternative ID cards since 13.01.2007
	$ocsp_issuers['EID-SK 2007']['CA_CERT_FILE'] = 'certs/eid_sk_2007.pem';
	// OCSP server adress for this CA
	$ocsp_issuers['EID-SK 2007']['OCSP_SERVER_URL'] = 'http://ocsp.sk.ee';
	// OCSP responder certificate location for this CA
	$ocsp_issuers['EID-SK 2007']['OCSP_SERVER_CERT_FILE'] = 'certs/EID-SK_2007_OCSP_RESPONDER_2010.pem';
	
	// ESTEID-SK - CA for Estonian national ID-card certificates issued until 13.01.2007
	$ocsp_issuers['ESTEID-SK']['CA_CERT_FILE'] = 'certs/esteid_sk.pem';
	$ocsp_issuers['ESTEID-SK']['OCSP_SERVER_URL'] = 'http://ocsp.sk.ee';
	$ocsp_issuers['ESTEID-SK']['OCSP_SERVER_CERT_FILE'] = 'certs/ESTEID-SK_OCSP_RESPONDER_2005.pem';
	
	// ESTEID-SK - CA for Estonian national ID-card certificates issued since 13.01.2007
	$ocsp_issuers['ESTEID-SK 2007']['CA_CERT_FILE'] = 'certs/esteid_sk_2007.pem';
	$ocsp_issuers['ESTEID-SK 2007']['OCSP_SERVER_URL'] = 'http://ocsp.sk.ee';
	$ocsp_issuers['ESTEID-SK 2007']['OCSP_SERVER_CERT_FILE'] = 'certs/ESTEID-SK_2007_OCSP_RESPONDER_2010.pem';
	
	// KLASS3-SK - CA for company certificates
	$ocsp_issuers['KLASS3-SK']['CA_CERT_FILE'] = 'certs/KLASS3-SK.pem';
	$ocsp_issuers['KLASS3-SK']['OCSP_SERVER_URL'] = 'http://ocsp.sk.ee';
	$ocsp_issuers['KLASS3-SK']['OCSP_SERVER_CERT_FILE'] = 'certs/KLASS3-SK_OCSP_RESPONDER_2009.pem';
	
	// KLASS3-SK 2010 - CA for company certificates
	$ocsp_issuers['KLASS3-SK 2010']['CA_CERT_FILE'] = 'certs/KLASS3-SK_2010.pem';
	$ocsp_issuers['KLASS3-SK 2010']['OCSP_SERVER_URL'] = 'http://ocsp.sk.ee';
	$ocsp_issuers['KLASS3-SK 2010']['OCSP_SERVER_CERT_FILE'] = 'certs/KLASS3-SK_2010_OCSP_RESPONDER.pem';
	
	// TEST-SK - CA for test certificates
	$ocsp_issuers['TEST-SK']['CA_CERT_FILE'] = 'certs/TEST-SK_2009.pem';
	$ocsp_issuers['TEST-SK']['OCSP_SERVER_URL'] = 'http://openxades.sk.sise/cgi-bin/ocsp.cgi';
	$ocsp_issuers['TEST-SK']['OCSP_SERVER_CERT_FILE'] = 'certs/TEST-SK_OCSP_RESPONDER_2005.pem';
	
	$settings = array(
		'idcard_auth_enabled' => array(
			'name' => 'idcard_auth_enabled',
			'value' => 0,
			'description' => 'ID card authentification enabled',
		),
		'idcard_use_ocsp' => array(
			'name' => 'idcard_use_ocsp',
			'value' => 0,
			'description' => 'Use OCSP for authentification',
		),
		'idcard_create_user' => array(
			'name' => 'idcard_create_user',
			'value' => 0,
			'description' => 'Create user if one does not exist',
		),
		'idcard_user_profile_id' => array(
			'name' => 'idcard_user_profile_id',
			'value' => $default_profile_id,
			'description' => 'ID card user profile ID',
		),
		'idcard_user_group_id' => array(
			'name' => 'idcard_user_group_id',
			'value' => $default_group_id,
			'description' => 'ID card user group ID',
		),
		'idcard_oscp_issuers' => array(
			'name' => 'idcard_oscp_issuers',
			'value' => $ocsp_issuers,
			'description' => 'OSCP Issuers config',
		),
		'idcard_openssl_bin' => array(
			'name' => 'idcard_openssl_bin',
			'value' => '/usr/local/ssl/bin/openssl',
			'description' => 'OpenSSL binary location',
		),
		'idcard_temp_dir' => array(
			'name' => 'idcard_temp_dir',
			'value' => '/var/tmp/',
			'description' => 'Temp folder to store certificates',
		),
	);
	
	$settings = save_extension_admin_page_settings('saurus4_estidcard', $settings);
}

?><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
   "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html>

<head>

<title>ESTID settings</title>

<meta http-equiv="Content-Type" content="text/html; charset=<?php echo $site->encoding; ?>" />

<link rel="stylesheet" href="<?php echo $site->CONF['wwwroot']; ?>/extensions/saurus4_estidcard/css/adminpage.css" />

<!--[if IE 6]>
	<style type="text/css">
	</style>
<![endif]-->

<!--[if IE 7]>
	<style type="text/css">
	</style>
<![endif]-->


<script type="text/javascript" src="<?php echo $site->CONF['wwwroot'].$site->CONF['js_path']; ?>/admin_menu.js"></script>
<script type="text/javascript" src="<?php echo $site->CONF['wwwroot'].$site->CONF['js_path']; ?>/jquery.js"></script>
<script type="text/javascript" src="<?php echo $site->CONF['wwwroot']; ?>/extensions/saurus4_estidcard/js/adminpage.js"></script>

<script type="text/javascript">
$(document).ready(function()
{
	make_breadcrumb('<?php echo $adminpage_names['parent_pagename']; ?>', '<?php echo $adminpage_names['pagename']; ?>');
	
});
</script>

</head>

<body>

	<div id="scms_content_cover" class="hidden"></div>
	
	<div id="scms_dialog" class="hidden">
		<table cellpadding="0" cellspacing="0" id="scms_dialog_box">
			<tr>
				<td id="message_cell"></td>
			</tr>
			<tr>
				<td id="buttons_cell">
					<input id="message_ok_button" type="button" value="<?php echo $site->sys_sona(array('sona' => 'ok', 'tyyp' => 'admin')); ?>" class="button hidden" />
					<input id="message_cancel_button" type="button" value="<?php echo $site->sys_sona(array('sona' => 'cancel', 'tyyp' => 'admin')); ?>" class="cancel hidden" />
				</td>
			</tr>
		</table>
	</div><!-- / scms_dialog -->
	
	<div id="scms_message" class="hidden">
		<table cellpadding="0" cellspacing="0" id="scms_message_box">
			<tr>
				<td id="text_cell"></td>
				<td id="close_message_cell"></td>
			</tr>
		</table>
	</div><!-- / scms_dialog -->
	
	<div id="scms_header_bar">
		
		<input type="button" id="save_settings" value="<?php echo $site->sys_sona(array('sona' => 'save', 'tyyp' => 'admin')); ?>" class="button" />
		
	</div><!-- / scms_header_bar -->
	
	<div id="scms_content_body">
		
		<form method="POST" id="settings_form" action="settings.php">
		
			<input type="hidden" name="action" value="save_settings" />
			
			<table cellpadding="2" cellspacing="2" id="settings_table">
				<!-- enabled -->
				<tr>
					<td colspan="2"><input type="checkbox" name="idcard_auth_enabled" id="idcard_auth_enabled" value="1"<?php echo ($settings['idcard_auth_enabled']['value'] ? ' checked="checked"' : ''); ?> /> <label for="idcard_auth_enabled"><?php echo htmlentities($settings['idcard_auth_enabled']['description']); ?></label></td>
				</tr>
				<!-- use oscp -->
				<tr>
					<td colspan="2"><input type="checkbox" name="idcard_use_ocsp" id="idcard_use_ocsp" value="1"<?php echo ($settings['idcard_use_ocsp']['value'] ? ' checked="checked"' : ''); ?> /> <label for="idcard_use_ocsp"><?php echo htmlentities($settings['idcard_use_ocsp']['description']); ?></label></td>
				</tr>
				<!-- use oscp -->
					
				<tr class="oscp-settings hidden">
					<td><label for="idcard_openssl_bin"><?php echo htmlentities($settings['idcard_openssl_bin']['description']); ?></label></td>
					<td><input type="text" class="text_long" name="idcard_openssl_bin" id="idcard_openssl_bin" value="<?php echo $settings['idcard_openssl_bin']['value']; ?>" /></td>
				</tr>
				
				<tr class="oscp-settings hidden">
					<td><label for="idcard_temp_dir"><?php echo htmlentities($settings['idcard_temp_dir']['description']); ?></label></td>
					<td><input type="text" class="text_long" name="idcard_temp_dir" id="idcard_temp_dir" value="<?php echo $settings['idcard_temp_dir']['value']; ?>" /></td>
				</tr>
				
				<?php foreach ($settings['idcard_oscp_issuers']['value'] as $issuer => $info) { ?>
				<tr class="oscp-settings hidden">
					<td colspan="2">Issuer <?php echo $issuer; ?></td>
				</tr>
				<tr class="oscp-settings hidden">
					<td><label for="<?php echo $issuer; ?>_CA_CERT_FILE">CA cert file path</label></td>
					<td><input type="text" class="text_long" name="idcard_oscp_issuers[<?php echo $issuer ?>][CA_CERT_FILE]" id="<?php echo $issuer; ?>_CA_CERT_FILE" value="<?php echo $info['CA_CERT_FILE'] ?>" /></td>
				</tr>
				<tr class="oscp-settings hidden">
					<td><label for="<?php echo $issuer; ?>_OCSP_SERVER_URL">OCSP server URL</label></td>
					<td><input type="text" class="text_long" name="idcard_oscp_issuers[<?php echo $issuer ?>][OCSP_SERVER_URL]" id="<?php echo $issuer; ?>_OCSP_SERVER_URL" value="<?php echo $info['OCSP_SERVER_URL'] ?>" /></td>
				</tr>
				<tr class="oscp-settings hidden">
					<td><label for="<?php echo $issuer; ?>_OCSP_SERVER_CERT_FILE">OCSP server cert file path</label></td>
					<td><input type="text" class="text_long" name="idcard_oscp_issuers[<?php echo $issuer ?>][OCSP_SERVER_CERT_FILE]" id="<?php echo $issuer; ?>_OCSP_SERVER_CERT_FILE" value="<?php echo $info['OCSP_SERVER_CERT_FILE'] ?>" /></td>
				</tr>
				<?php } ?>
				<!-- create user -->
				<tr>
					<td colspan="2"><input type="checkbox" name="idcard_create_user" id="idcard_create_user" value="1"<?php echo ($settings['idcard_create_user']['value'] ? ' checked="checked"' : ''); ?> /> <label for="idcard_create_user"><?php echo htmlentities($settings['idcard_create_user']['description']); ?></label></td>
				</tr>
				<!-- profile_id -->
				<tr class="user-settings hidden">
					<td><label for="idcard_user_profile_id"><?php echo htmlentities($settings['idcard_user_profile_id']['description']); ?></label></td>
					<td>
						<select name="idcard_user_profile_id" id="idcard_user_profile_id" class="select">
							<?php while ($profile = $profiles->fetch('ASSOC')) { ?>
								<option value="<?php echo $profile['profile_id']; ?>"<?php echo ($profile['profile_id'] == $settings['idcard_user_profile_id']['value'] ? ' selected="selected"' : '') ?>><?php echo htmlentities($profile['name']); ?></option>
							<?php } ?>
						</select>
					</td>
				</tr>
				<!-- group_id -->
				<tr class="user-settings hidden">
					<td><label for="idcard_user_group_id"><?php echo htmlentities($settings['idcard_user_group_id']['description']); ?></label></td>
					<td>
						<select name="idcard_user_group_id" id="idcard_user_group_id" class="select">
							<?php foreach (get_array_tree($groups_tree) as $key => $value)
							{
								$name = str_repeat('&nbsp;&nbsp;', $value['level']).htmlentities($value['name']);
							?>
								<option value="<?php echo $value['id']; ?>"<?php echo ($value['id'] == $settings['idcard_user_group_id']['value'] ? ' selected="selected"' : '') ?>><?php echo $name; ?></option>
							<?php }	?>				
						</select>
					</td>
				</tr>
			</table>
		</form>
				
	</div><!-- / scms_content_body -->
	
</body>

</html>