<?php
/**
 * Redirect user from SSL folder back to the website root folder, to file idcard.php.
 *
 * @package CMS
*/

/**
 * Control file for ID Card auth
 * 
 * Verifies ID Card and logs user in using id code read from card.
 * 
 * @package	CMS
 * @version	1.0
 * @author Reigo <reigo@saurus.ee>
 * @link	http://www.saurus.info/
 */

$class_path = '../../../classes/';
require_once($class_path.'port.inc.php');

$site = new Site(array());

if($site->fdat['url'])
{
	$redirect = urldecode($site->fdat['url']);
}
else 
{
	$redirect = (empty($_SERVER['HTTPS']) ? 'http://' : 'https://').$site->CONF['hostname'].$site->CONF['wwwroot'].'/';
}

require_once('../lib/functions.inc.php');

$auth = estid_auth();

if($auth['error'])
{
	new Log(array(
		'action' => 'log in',
		'component' => 'ID Card',
		'type' => 'ERROR',
		'message' => $auth['message'],
	));
	
	if($auth['error'] == 1 || $auth['error'] == 2 || $auth['error'] == 3 || $auth['error'] == 4)
	{
		header ('Location: '.(empty($_SERVER['HTTPS']) ? 'http://' : 'https://').$site->CONF['hostname'].$site->CONF['wwwroot'].'/');
	}
	
	exit;
}
// no auto creation, send to register page
elseif ($auth['message'] == 'User does not exist')
{
	header ('Location: '.(empty($_SERVER['HTTPS']) ? 'http://' : 'https://').$site->CONF['hostname'].$site->CONF['wwwroot'].'/?op=register');
}
// user authenicated and logged in
elseif($auth['authenticated'])
{
	// refresh page
	header ('Location: '.$redirect);
}
// unknown
else 
{
	header ('Location: '.(empty($_SERVER['HTTPS']) ? 'http://' : 'https://').$site->CONF['hostname'].$site->CONF['wwwroot'].'/');
}

exit;
