$(document).ready(function()
{
	setContentDimensions();
	
	$(window).resize(function()
	{
		setContentDimensions();
	});

	$('#save_settings').click(function ()
	{
		$('#settings_form').submit();
	});

	if($('#idcard_use_ocsp').attr('checked'))
	{
		$('.oscp-settings').removeClass('hidden');
	}

	if($('#idcard_create_user').attr('checked'))
	{
		$('.user-settings').removeClass('hidden');
	}

	$('#idcard_use_ocsp').change(function ()
	{
		if($(this).attr('checked'))
		{
			$('.oscp-settings').removeClass('hidden');
		}
		else
		{
			$('.oscp-settings').addClass('hidden');
		}
	});
	
	$('#idcard_create_user').change(function ()
	{
		if($(this).attr('checked'))
		{
			$('.user-settings').removeClass('hidden');
		}
		else
		{
			$('.user-settings').addClass('hidden');
		}
	});
});

function setContentDimensions()
{
	// set content height
	$('div#scms_content_cover').height($(window).height());
	
	// set content height
	$('div#scms_content_body').height($(window).height() - $('div#scms_header_bar').height() - (8 + 2 + 2)); // paddings and borders need to be added
}

function fadingMessage(message)
{
   	$('div#scms_content_cover').addClass('hidden');
	
	$('div#scms_message').removeClass('hidden');
	
	$('td#text_cell').text(message);
	
	$('td#close_message_cell').click(function () {
		$('div#scms_message').addClass('hidden');
	});
	
	$('td#close_message_cell').click(function ()
	{
		$('div#scms_message').addClass('hidden');
		
		$(this).unbind('click');
		
	});

	var delayTimer;
	
	if(delayTimer)
	{
		clearTimeout(delayTimer);
		delayTimer = null;
	}
	
	delayTimer = setTimeout(function ()
	{
		$('div#scms_message').addClass('hidden');
		
		$(this).unbind('click');
	}, 4000);	
}

function messageDialog(message)
{
   	$('div#scms_content_cover').removeClass('hidden');
	
	$('div#scms_dialog, input#message_ok_button').removeClass('hidden');
	
	$('td#message_cell').text(message);
	
	$('input#message_ok_button').click(function ()
	{
		$('div#scms_dialog, input#message_ok_button').addClass('hidden');
		
		$('input#message_ok_button').unbind('click');
		
	   	$('div#scms_content_cover').addClass('hidden');
	});
}
