<?php

if(!function_exists('get_extension_admin_page_settings'))
{
	function get_extension_admin_page_settings($extension_name)
	{
		global $site;
		
		$sql = $site->db->prepare("SELECT * FROM config WHERE nimi = ?", 'extension_'.$extension_name.'_settings');
		$result = new SQL($sql);
		$settings = $result->fetch('ASSOC');
		$settings = unserialize($settings['kirjeldus']);
		
		return $settings;
	}
}

if(!function_exists('save_extension_admin_page_settings'))
{
	function save_extension_admin_page_settings($extension_name, $settings = array())
	{
		global $site;
		
		$sql = $site->db->prepare("UPDATE config SET kirjeldus = ? WHERE nimi = ?", serialize($settings), 'extension_'.$extension_name.'_settings');
		new SQL($sql);
		
		return get_extension_admin_page_settings($extension_name);
	}
}

function estid_auth()
{
	global $site;
	
	//printr($_SERVER); exit;
		
	$settings = get_extension_admin_page_settings('saurus4_estidcard');
	
	if($settings['idcard_auth_enabled']['value'])
	{
		$verify = false;
		
		//$ocsp_check = doOCSPcheck($settings['idcard_oscp_issuers']['value'], $settings['idcard_openssl_bin']['value'], $settings['idcard_temp_dir']['value']);
		
		if($_SERVER['SSL_CLIENT_VERIFY'] == 'SUCCESS')
		{
			$verify = true;
		}
		elseif($settings['idcard_use_ocsp']['value'])
		{
			$ocsp_check = doOCSPcheck($settings['idcard_oscp_issuers']['value'], $settings['idcard_openssl_bin']['value'], $settings['idcard_temp_dir']['value']);
			
			if($ocsp_check[1] == 1)
			{
				$verify = true;
			}
			else 
			{
				return array(
					'error' => 4,
					'message' => 'OCSP check failed: '.$ocsp_check[0].' ('.$ocsp_check[1].')',
					'authenticated' => 0,
				);
			}
		}
		
		if($verify)
		{
			$SSL_CLIENT_S_DN_CN = $_SERVER['SSL_CLIENT_S_DN_CN'];
			
			if(!$SSL_CLIENT_S_DN_CN && $_SERVER['SSL_CLIENT_S_DN'])
			{
				$SSL_CLIENT_S_DN_CN = explode('/', $_SERVER['SSL_CLIENT_S_DN']);
				foreach ($SSL_CLIENT_S_DN_CN as $value) if(strpos($value, 'CN=') === 0) // search for the CN value
				{
					$SSL_CLIENT_S_DN_CN = '';
					// convert hex values (\x[0-9A-Fa-f]{1,2}) to characters
					foreach (explode('\x', substr($value, 3)) as $hex)
					{
						if($hex && substr($hex, 0, 2) != '00') // skip 0 value bytes (\x00)
						{
							$SSL_CLIENT_S_DN_CN .= chr(hexdec(substr($hex, 0, 2))).substr($hex, 2);
						}
						elseif ($hex) // replace 0 bytes (\x00) with empty string ('')
						{
							$SSL_CLIENT_S_DN_CN .= str_replace('00', '', $hex);
						}
					}
					// SSL_CLIENT_S_DN should be now in ISO-8859-1
					$SSL_CLIENT_S_DN_CN = mb_convert_encoding($SSL_CLIENT_S_DN_CN, $site->encoding, 'ISO-8859-1');
					break;
				}
			}
			
			/*
			if($_SERVER['REMOTE_ADDR'] == '90.190.110.150')
			{
				printr($_SERVER);
				exit;
			}
			*/
			
			$tmpidcode = explode(',', $SSL_CLIENT_S_DN_CN);
			$lastname = $tmpidcode[0];
			$firstname = $tmpidcode[1];
			$idcode = $tmpidcode[2];
			
			if($idcode && strlen($idcode) == 11)
			{
				$sql = $site->db->prepare('SELECT user_id FROM users WHERE idcode = ?', $idcode);
				$result = new SQL($sql);
		
				// user exist login
				if($result->rows)
				{
					$user_id = (int)$result->fetchsingle();
					$_SESSION['user_id'] = $user_id;
		
					new Log(array(
						'action' => 'log in',
						'user_id' => $user_id,
						'component' => 'ID Card',
						'message' => "User '".$firstname." ".$lastname."' logged in from IP: '".$_SERVER["REMOTE_ADDR"]."'"." (Authentication: ID Card)",
					));
					
					return array(
						'error' => 0,
						'message' => 'User authenticated and logged in',
						'authenticated' => 1,
					);
				}
				// create user
				elseif($settings['idcard_create_user']['value'])
				{
					$group_id = $settings['idcard_user_group_id']['value'];
					
					$profile_id = $settings['idcard_user_profile_id']['value'];
					
					$sql = $site->db->prepare("insert into users (username, password, email, profile_id, group_id, firstname, lastname, created_date, pass_expires, idcode) values(?, ?, ?, ?, ?, ?, ?, now(), '2999-01-01', ?)", $idcode, encrypt_password(md5(rand(0,1000).rand(0,1000))), NULL, $profile_id, $group_id, $firstname, $lastname, $idcode);
					$result = new SQL($sql);
		
					$user_id = $result->insert_id;
		
					new Log(array(
						'action' => 'create',
						'component' => 'ID Card',
						'message' => "ID Card: New User " . $firstname . " " . $lastname . " with ID code (md5hash): " . md5($idcode) . " created automatically",
					));
					
					$_SESSION['user_id'] = $user_id;
		
					new Log(array(
						'action' => 'log in',
						'user_id' => $user_id,
						'component' => 'ID Card',
						'message' => "User '".$firstname." ".$lastname."' logged in from IP: '".$_SERVER["REMOTE_ADDR"]."'"." (Authentication: ID Card)",
					));
					
					return array(
						'error' => 0,
						'message' => 'User created and logged in',
						'authenticated' => 1,
					);
				}
				else 
				{
					return array(
						'error' => 0,
						'message' => 'User does not exist',
						'authenticated' => 0,
					);
				}
			}
			else
			{
				return array(
					'error' => 3,
					'message' => 'ID card authentication: not Estonian ID Card',
					'authenticated' => 0,
				);
			}
		}
		else
		{
			return array(
				'error' => 2,
				'message' => 'ID card authentication: SSL_CLIENT_VERIFY failed: '.$_SERVER['SSL_CLIENT_VERIFY'],
				'authenticated' => 0,
			);
		}
	}
	else 
	{
		return array(
			'error' => 1,
			'message' => 'ID card authentication not enabled',
			'authenticated' => 0,
		);
	}
	
}

/*
 0 - OCSP certificate status unknown
 1 - OCSP certificate status valid
 2 - OCSP internal error
 4 - Some error in script
*/

function doOCSPcheck($ocsp_info, $opensslbin, $tempdir)
{
	$cert = $_SERVER["SSL_CLIENT_CERT"];
	
	$ocsp_info['OPEN_SSL_BIN'] = $opensslbin;
	$ocsp_info['OCSP_TEMP_DIR'] = $tempdir;
	
	$user_good = 0;
	$issuer_dn=$_SERVER["SSL_CLIENT_I_DN_CN"];
	
	if (isset($ocsp_info[$issuer_dn]["CA_CERT_FILE"]) && isset($ocsp_info[$issuer_dn]["OCSP_SERVER_CERT_FILE"]) && isset($ocsp_info[$issuer_dn]["OCSP_SERVER_URL"]))
	{
		// Saving user certificate file to OCSP temp folder
		$tmp_f = fopen($tmp_f_name = tempnam($ocsp_info["OCSP_TEMP_DIR"],'ocsp_check'),'w');
		//$tmp_f_name = $ocsp_info["OCSP_TEMP_DIR"].'/rk.cert';
		//$tmp_f = fopen($tmp_f_name, 'w');
		fwrite($tmp_f,$cert);
		fclose($tmp_f);

		// Making OCSP request using OpenSSL ocsp command
		$command = $ocsp_info["OPEN_SSL_BIN"].' ocsp -issuer '.$ocsp_info[$issuer_dn]["CA_CERT_FILE"].' -cert '.$tmp_f_name.' -url '.$ocsp_info[$issuer_dn]["OCSP_SERVER_URL"].' -VAfile '.$ocsp_info[$issuer_dn]["OCSP_SERVER_CERT_FILE"];

		$descriptorspec = array(
		   0 => array("pipe", "r"),  // stdin is a pipe that the child will read from
		   1 => array("pipe", "w"),  // stdout is a pipe that the child will write to
		   2 => array("pipe", "w") // stderr is a pipe that the child will write to
		);

		$process = proc_open($command, $descriptorspec, $pipes);

		if (is_resource($process)) {
			fclose($pipes[0]);


			// Getting errors from stderr
			$errorstr="";
			while ($line = fgets($pipes[2])) {
				$errorstr.=$line;
			}

			if ($errorstr!="" && (strpos($errorstr,"Response verify OK")!==0)) {
				$user_good = 4;
			} else {
				// Parsing OpenSSL command stdout
				while ($line = fgets($pipes[1])) {
					if (strstr($line,'good')) {
						$user_good = 1;
					} else if (strstr($line,'internalerror (2)')) {
						$user_good = 2;
					}
				}
				fclose($pipes[1]);
			}

			proc_close($process);
		}
		
		@unlink($tmp_f);
	}
	
	return Array($errorstr, $user_good);
}