<?php

global $site;

#################################
# predefined values
$language = array (
	'af' => 'Afrikaans',
	'sq' => 'Albanian',
	'eu' => 'Basque',
	'be' => 'Belarusian',
	'bg' => 'Bulgarian',
	'ca' => 'Catalan',
	'zh-cn' => 'Chinese (Simplified)',
	'zh-tw' => 'Chinese (Traditional)',
	'hr' => 'Croatian',
	'cs' => 'Czech',
	'da' => 'Danish',
	'nl' => 'Dutch',
	'nl-be' => 'Dutch (Belgium)',
	'nl-nl' => 'Dutch (Netherlands)',
	'en' => 'English',
	'en-au' => 'English (Australia)',
	'en-bz' => 'English (Belize)',
	'en-ca' => 'English (Canada)',
	'en-ie' => 'English (Ireland)',
	'en-jm' => 'English (Jamaica)',
	'en-nz' => 'English (New Zealand)',
	'en-ph' => 'English (Phillipines)',
	'en-za' => 'English (South Africa)',
	'en-tt' => 'English (Trinidad)',
	'en-gb' => 'English (United Kingdom)',
	'en-us' => 'English (United States)',
	'en-zw' => 'English (Zimbabwe)',
	'et' => 'Estonian',
	'fo' => 'Faeroese',
	'fi' => 'Finnish',
	'fr' => 'French',
	'fr-be' => 'French (Belgium)',
	'fr-ca' => 'French (Canada)',
	'fr-fr' => 'French (France)',
	'fr-lu' => 'French (Luxembourg)',
	'fr-mc' => 'French (Monaco)',
	'fr-ch' => 'French (Switzerland)',
	'gl' => 'Galician',
	'gd' => 'Gaelic',
	'de' => 'German',
	'de-at' => 'German (Austria)',
	'de-de' => 'German (Germany)',
	'de-li' => 'German (Liechtenstein)',
	'de-lu' => 'German (Luxembourg)',
	'de-ch' => 'German (Switzerland)',
	'el' => 'Greek',
	'haw' => 'Hawaiian',
	'hu' => 'Hungarian',
	'is' => 'Icelandic',
	'in' => 'Indonesian',
	'ga' => 'Irish',
	'it' => 'Italian',
	'it-it' => 'Italian (Italy)',
	'it-ch' => 'Italian (Switzerland)',
	'ja' => 'Japanese',
	'ko' => 'Korean',
	'mk' => 'Macedonian',
	'no' => 'Norwegian',
	'pl' => 'Polish',
	'pt' => 'Portuguese',
	'pt-br' => 'Portuguese (Brazil)',
	'pt-pt' => 'Portuguese (Portugal)',
	'ro' => 'Romanian',
	'ro-mo' => 'Romanian (Moldova)',
	'ro-ro' => 'Romanian (Romania)',
	'ru' => 'Russian',
	'ru-mo' => 'Russian (Moldova)',
	'ru-ru' => 'Russian (Russia)',
	'sr' => 'Serbian',
	'sk' => 'Slovak',
	'sl' => 'Slovenian',
	'es' => 'Spanish',
	'es-ar' => 'Spanish (Argentina)',
	'es-bo' => 'Spanish (Bolivia)',
	'es-cl' => 'Spanish (Chile)',
	'es-co' => 'Spanish (Colombia)',
	'es-cr' => 'Spanish (Costa Rica)',
	'es-do' => 'Spanish (Dominican Republic)',
	'es-ec' => 'Spanish (Ecuador)',
	'es-sv' => 'Spanish (El Salvador)',
	'es-gt' => 'Spanish (Guatemala)',
	'es-hn' => 'Spanish (Honduras)',
	'es-mx' => 'Spanish (Mexico)',
	'es-ni' => 'Spanish (Nicaragua)',
	'es-pa' => 'Spanish (Panama)',
	'es-py' => 'Spanish (Paraguay)',
	'es-pe' => 'Spanish (Peru)',
	'es-pr' => 'Spanish (Puerto Rico)',
	'es-es' => 'Spanish (Spain)',
	'es-uy' => 'Spanish (Uruguay)',
	'es-ve' => 'Spanish (Venezuela)',
	'sv' => 'Swedish',
	'sv-fi' => 'Swedish (Finland)',
	'sv-se' => 'Swedish (Sweden)',
	'tr' => 'Turkish',
	'uk' => 'Ukranian'
);

$this->assign('language', $language);
#
#################################
#################################
# malli parameetrite salvestamine

if ($site->fdat['salvesta']) {
	$sql = $site->db->prepare("
		UPDATE objekt SET ttyyp_params = ?
		WHERE objekt_id = ?",
		save_params(),
		$site->fdat['id']
	);
	$sth = new SQL($sql);
}
# / malli parameetrite salvestamine
###################################

#################################
# Get configuration info
$objekt = new Objekt(array(
	'objekt_id' => ($site->fdat['id'] ? $site->fdat['id'] : $leht->id),
	'no_cache' => 1,
));

$conf = new CONFIG($objekt->all['ttyyp_params']);
$lastBuildDate = $conf->get('lastBuildDate') ? $conf->get('lastBuildDate') : date("Y-m-d H:i:s");

##########################
# get parents
$parents = split (',', $conf->get('parents'));
$selected_parents = array();
foreach ($parents as $parent_id) {
	$selected_parents[$parent_id] = 'selected';
}
# // get parents
##########################

$order = $conf->get('order_by') ? $conf->get('order_by').' '.$conf->get('order_type') : '';

$this->assign('parents',$conf->get('parents'));
$this->assign('order',$order);

$this->assign('order_by',$conf->get('order_by'));
$this->assign('order_type',$conf->get('order_type'));
$this->assign('selected_parents',$selected_parents);
$this->assign('start',$conf->get('start'));
$this->assign('limit',$conf->get('limit'));
$this->assign('position',$conf->get('position'));
$this->assign('start_date',$conf->get('start_date'));
$this->assign('end_date',$conf->get('end_date'));
$this->assign('channel_title',$conf->get('channel_title'));
$this->assign('channel_image',$conf->get('channel_image'));
$this->assign('channel_image_title',$conf->get('channel_image_title'));
$this->assign('channel_image_link',$conf->get('channel_image_link'));
$this->assign('channel_description',$conf->get('channel_description'));
$this->assign('lastBuildDate',$lastBuildDate);
$this->assign('use_link',$conf->get('use_link'));
$this->assign('use_body',$conf->get('use_body'));
$this->assign('use_lead',$conf->get('use_lead'));
$this->assign('language_id', ($conf->get('language_id') ? $conf->get('language_id') : 'en'));
# / 
###################################

if ($site->admin) {
	##############################
	# Select box values
	$select_order_by = array(
		'aeg' => 'Article Date',
		'sorteering' => 'Article Sorting',
		'pealkiri' => 'Article Title',
	);
	$select_order_type = array(
		'DESC' => 'Descending',
		'ASC' => 'Ascending',
	);

	include '../classes/rubloetelu.class.php';
	$rubs = new RubLoetelu(array(keel => $site->keel));
	$topparents = $rubs->get_loetelu();
	asort($topparents);

	$this->assign('select_order_by',$select_order_by);
	$this->assign('select_order_type',$select_order_type);
	$this->assign('topparents',$topparents);
	#
	#################################
}

function save_params() {
	global $site, $leht;

	$objekt = new Objekt(array(
		objekt_id => ($site->fdat['id'] ? $site->fdat['id'] : $leht->objekt->objekt_id)
	));

	$conf = new CONFIG($objekt->all['ttyyp_params']);

	$conf->put('order_by', $conf->site->fdat['order_by']);
	$conf->put('order_type', $conf->site->fdat['order_type']);
	$conf->put('parents', join(',',$conf->site->fdat['parents']));
	$conf->put('start', $conf->site->fdat['start']);
	$conf->put('limit', $conf->site->fdat['limit']);
	$conf->put('position', $conf->site->fdat['position']);
	$conf->put('start_date', $conf->site->fdat['start_date']);
	$conf->put('end_date', $conf->site->fdat['end_date']);
	$conf->put('channel_title', $conf->site->fdat['channel_title']);
	$conf->put('channel_image', $conf->site->fdat['channel_image']);
	$conf->put('channel_image_title', $conf->site->fdat['channel_image_title']);
	$conf->put('channel_image_link', $conf->site->fdat['channel_image_link']);
	$conf->put('channel_description', $conf->site->fdat['channel_description']);
	$conf->put('lastBuildDate', date('Y-m-d H:i:s'));
	$conf->put('use_link', $conf->site->fdat['use_link']);
	$conf->put('use_body', $conf->site->fdat['use_body']);
	$conf->put('use_lead', $conf->site->fdat['use_lead']);
	$conf->put('language_id', $conf->site->fdat['language_id']);
	return $conf->Export();
}
?>