<?php
######################################################
# Saurus CMS version converter 3.5.0 -> 4.2.1
#
# Copyright (C) 2000-2008 Saurus http://www.saurus.info
######################################################

#
# Please read README file for conversion requirements and instructions.
#
# This script is for converting all data between old and new databases.
# Script usage: http://www.yoursite.com/convert.php
#
# 
# Changelog:
# 1.6 [26 May 2009]
#   - Converts to CMS version 4.5.0 or higher instead of 4.2.1
#   - Comes with Microsoft Windows executable to convert big version 3 database dump files to a proper format for importing
#   - Convert and Convert encoding merged into one script
#   - Help/readme is shown in first step of converting
#   - Bugfix: Convert encoding did not convert all custom extension tables
#   - Bugfix: Glossary was not automatically updated after conversion
# 1.5 [31 Oct 2008]
#   - Bugfix: replacing file links in the articles was incorrect, caused double hostnames in links
#   - Encoding: ADR support: Under the Language/Option selection there is 'ADR module conversion'. It must be done alongside with the languge conversions. 
#   - Encoding: Added custom character conversion support that converts  characters and other types that the initial conversion ignores. Must be done after the languages have been converted into UTF-8. !!!! Works only with UTF-8 encoding. 
# 1.4 [20 Oct 2008]
#   - Creates a custom extension folder for the use with Modern template 
#   - Converts v3 CSS styles into V4 CSS that will be added into the new extension
#   - Add a logo.gif into the new extension folder.
#   - Bugfix: converted ext_ tables did not have any keys/indexes. 
# 1.3 [14 Jul 2008]
#   - Bugfix: Allow converting from 3.5.0 and later
#   - Improved usability and texts
#   - Improved database import error controls
#   - Check current version 4 match also (was ver 3 check only)
#   - Bugfix: replacing hyperlinks, failid/ => public/ was missed
#   - Bugfix: {print_box} added to the list of deprecated tags
#   - Bugfix: Last step didn't delete old version3 "ext_" tables
#   - Bugfix: language table was overwritten causing missing "locale" values in ver4
# 1.2 [15 Dec 2006]
#   - Bugfix: Custom translation in system word group "metadata" (deprecated in ver4) were lost during conversion.
#   - Encoding: Fixed bug: all binary fields must be ignored during conversion
# 1.1 [14 Dec 2006]
#   - Bugfix: Assets were not converted properly, data was missing
#   - SQL for backward compability: section position values 5 and 9 (default in ver3) is replaced with 0 value (default in ver4)
# 1.0 [28 Nov 2006]
#   - initial release
######################################################


# Known bugs:
# - may-be: ssteemiartiklid kantakse tiega le, isegi siis kui nad on puudu. Juhutb nii, et siis iged ver4 default artiklid lhevad kaduma
# - metadata kontroll: kontrolli kas on custom metadata liike ja kui on, anna punane hoiatus
# - OLULINE: check_deprecated_sapi_tags() leiab rohkem kui vaja. ka malle mille sees ei ole neid tage.
#Selle tulemusena ei muudeta alati artiklites mber faililinke. Siit soovitus peale convertimist igaks juhuks #panna symbolic link "failid" > "public" 
# paavo raporteeris, et: Peale update on log.php kaudu vaadatuna kik enne update toimunud kirjete puhul Autoriks "system". igete kasutajanimedega lhevad kirja ainult peale update tehtud asjad. 
# - panna kirja README-sse et kui vana sait on ISO-s ja konverti ei tehta, siis tuleb snastikud sisse tmmata (sest vaikimisi on ver4 UTF-8s)
# - EA-s juhtus nii et reg.kasutajate paroolidega ei saanud sisse logida. sama juhtus falck.netis.
# - Kontrolli kas failid tulevad kik sisse eesti keeles? sest peaks. Siin kasutatakse ver4.2.1 failiarhiivi snkimisfunktsioone.
# lisada README-sse info $ ln -s public/ failid 
# - dumpimise ja baasi edasi tagasi tstmise tttu ei pruugi alati wwwhost automaatne muutus tdata.
# - (EI TEE: WYSIWYG editori kitumise erinevus ver3 ja ver4 vahel: kui ver3 on "<p></p>", siis ver 4 editor paneb artiklit avades ise sinna vahele thiku (&nbsp;) ja tulemusena kuvatakse topeltirdasid. Konverter peaks asendama "<p></p>" => "<br /><br />"
# mallides smarty engine-i erinevus: parent="$obj->id"  ===>  parent=$obj->id)
# - uus sept 2008 Rahamin: probleem dump faili rida  (  KEY `kompl` (`field`,`tbl`,`pp_dok_liik`(255),`ttyyp_id`), aga peale selle kustutamist lks kik uude baasi peale. Seda rida ritas vist kustutada ka ks hilisem update  vhemalt ma sain 4.5.5 peale uuendades > selle kohta vea.

# Convert encoding Known bugs:
# - teha fix susisevatele
# - teha fix wordi x smbolitele

session_start();

error_reporting(7);
//error_reporting(0);

# set script execution time to 10 min only  if general value is smaller
if (intval(ini_get('max_execution_time')) < 600) {
	set_time_limit(600);
}
if (intval(ini_get('memory_limit')) < 1200) {
	ini_set("memory_limit", "1200M");
}

/***********************************/
/* INCLUDED FILES                  */
/***********************************/
$class_path = "./classes/";
$is_installation_script = true;

if (!file_exists($class_path . "port.inc.php")) {
	echo "Error: Saurus CMS not found! Copy this script to your website root folder!";
	exit;
} else {
	require_once($class_path . "port.inc.php");
	//require_once($class_path . "install.inc.php");
}

session_unregister("user_id");
unset($_SESSION["user_id"]);
setcookie("logged", "0", time() - 36600);

class SQL2 extends SQL {
	function error() {

	}
}

class ObjektArray2 extends BaasObjekt {

	var $size;
	var $index;
	var $list;
	var $objekts;

	function ObjektArray2 () {
		#$args = func_get_arg(0);
		$this->BaasObjekt($args);	
			
		$this->list = Array();
		$this->objekts = Array();		
		$this->set_size();
		$this->index = -1;
	}

	function set_size () {
		# private
		# kirjutab objekti omadus suurus
		$this->size = sizeof($this->list);
	}

	function reset () {
		# hppab algusele
		if ($this->size>0) {
			$this->index = -1; # muutsin 0 => -1. ttab valesti muidu ju. (peale reset-ksku alustatakse tavaliselt uuesti while tsklit ->next ksu abil ja siis ollakse kohe index 0 pealt jrgmise indeksi (1) peal. esimest ignoreeritakse nii ldse.)
			$this->debug->msg("index = -1");
		} else {
			$this->index = -1;
			$this->debug->msg($this->size."List on thi: index = -1");
		};
	}

	function add ($objekt) {
		# lisab objekti objektide ahela lppu
		# juhul kui objekt ei ole kasutajale vaatamiseks (R) keelatud
		# JA pole juba listis olemas
		## kui objekt juba listis leidub, siiss ra lisa topelt (porting MS SQL)

		## POOLELI: Suure objektide arvu (nt le ~10 000) korral on siin tsine kiiruse jama, tekib "Fatal error: Maximum execution time of 30 seconds exceeded in", sest massiiv "$this->objekts" on liiga suur:
#print('; '.sizeof($this->objekts));

		if( in_array($objekt->objekt_id, $this->objekts) ){
			#printr("AGA ma olen juba olemas:".$objekt->objekt_id);
			return;
		}

		############### new ver4 ACL permissions

		if(!isset($objekt->permission)){ # load permissions	if not loaded yet
			$objekt->permission = $objekt->get_permission();
		}
		$perm = $objekt->permission;

		############# find object permissions
		
		################# USE PERMISSIONS
		# at this point object permissions must exist (either user,guest or default permissions)

		############ add object if it-s visible

		if ($objekt->objekt_id && $perm['is_visible'] ) {
			array_push($this->list,$objekt);
			array_push($this->objekts,$objekt->objekt_id);
			$debug_msg .= $objekt->objekt_id." => object added.";
			$this->set_size();
		} 
		# if NOT allowed then dont add object 
		else {
			# ifnot visible
			if(!$perm['is_visible']) {
				$this->debug->msg("Objekt on vaatamiseks keelatud! Ei lisa teda objektide listi.");
				$debug_msg = " => skip object (Read is denied)";
			}
			# if missing ID
			elseif(!$objekt->objekt_id) {
				$this->debug->msg("Objekt pole loodud");
				$debug_msg = " => skip object (object not found)";
			}
			# if unknown
			else {
				$this->debug->msg("Objekt missing");
				$debug_msg = " => skip object (reason unknown)";
			}
			unset($objekt);

		}	
	
		########### debug msg
		if($this->site->user->user_id) {
			$this->site->user->debug->msg($debug_msg);
		} elseif($this->site->guest) {
			$this->site->guest->debug->msg($debug_msg);
		}


	} # function add

	function on_viimane () {
		# 1 kui pointer on viimase objekti peal, 
		# 0 kui mitte
		return $this->index+1 == $this->size;
	}

	function on_parent ($objekt) {
		# 1 kui antud id on parentide hulgas, 
		# 0 kui mitte

		if (!strcasecmp(get_class($objekt),"Objekt")) {
			# input on objekt
			$objekt_id = $objekt->objekt_id;
		} elseif (preg_match("/^\d+$/",$objekt)) {
			# input on objekti ID
			$objekt_id = $objekt;
		} else {
			# input on vigane
			$this->debug->msg("vigased algandmed: \"$objekt\" pole objekt ega objekti ID");
		}
		return in_array($objekt_id, $this->objekts);
	}

	function get_current () {
		# tagastab objekt, mis on hetkel aktiivne
		if ($this->index>=0 and $this->index<$this->size) {
#			$this->debug->msg("tagastan ".($this->index+1).". objekt ".$this->size."-st");
			return $this->list[$this->index];
		}
	}

	function get ($index) {
		# tagastab objekt, $index-i jrgi
		# $index = 1 - objekt number 2 (0,1,2...)
		# $index = -1 - esimene objekt lpust

		###### positive index or 0 (get from start01.11.05)
		if ($index>=0 and $index<$this->size) {
#			$this->debug->msg("tagastan ".($index+1).". objekt ".$this->size."-st (index=$index)");
			return $this->list[$index];
		} 
		###### negative index (get from end)
		else if ($index<0 and abs($index)<=$this->size) {
#			$this->debug->msg("tagastan ".($this->size+$index+1).". objekt ".$this->size."-st (index=$index)");
			return $this->list[$this->size+$index];
		} else {
#			$this->debug->msg("vale index $index, loetelus on ".$this->size." objekti");
		}
	}

	function set_index ($index) {
		# positsioneerib objekt, $index-i jrgi
		# $index = 1 - objekt number 2 (0,1,2...)
		# $index = -1 - esimene objekt lpust

		if ($index>=0 and $index<$this->size) {
			$this->debug->msg("aktiveerin ".($index+1).". objekti (koguarv=".$this->size.", index=$index)");
			$this->index = $index;
		} else if ($index<0 and abs($index)<=$this->size) {
			$this->debug->msg("aktiveerin ".($this->size+$index+1).". objekti (koguarv=".$this->size.", index=$index)");
			$this->index = $this->size+$index;
		} else {
			$this->debug->msg("vale index $index, loetelus on ".$this->size." objekti");
		}
	}

	function next() {
		# teeb samm edasi ja tagastab objekt
		if ($this->index+1 < $this->size) {
			++$this->index;
			return $this->get_current();
		} else {
			$this->debug->msg("objektid on otsas");
		};
	}

	function prev() {
		# teeb samm tagasi ja tagastab objekt
		if ($this->index-1 >=0) {
			--$this->index;
			return $this->get_current();
		} else {
			$this->debug->msg("objektid on otsas");
		};
	}
}


class Parents2 extends ObjektArray2 {	
# ---------------------------------------
# ahel antud objektist kige lema objektini
#
# constructor new Parents(array(
#	"parent"		=> Objekt
# ));
# ---------------------------------------
#
#
	var $parent_id;
	var $meta;
	var $on_peida_vmenyy;
	var $aktiivne_id;
	var $on_aeg;

	function Parents2 () {
		$args = func_get_arg(0);
		$this->ObjektArray2();
		$this->meta = Array();
		
		if (!strcasecmp(get_class($args["parent"]),"Objekt")) {
			# parent on objekt
			$this->parent_id = $args["parent"]->objekt_id;
			$this->debug->msg("Parents. Antud on objekt: parent_id = ".$this->parent_id);
		} elseif (preg_match("/^\d+$/",$args["parent"])) {
			# parent on objekti ID
			$this->parent_id = $args["parent"];
			$this->debug->msg("Parents. Antud on objekti ID: parent_id = ".$this->parent_id);
		} else {
			# parent on vigane
			$this->debug->msg("vigased algandmed: \"$args[parent]\" pole objekt ega objekti ID");
		}

		# merle hmar kommentaar "lisa_objekt"-ile: mulle tundub, et see on vajalik situatsioonis, 
		# kus URL-i peal id puudub JA tegu on vana fiks. op-malliga: siis "on meil eriobjekt"
		# ja oleks vaja seda op-malli nidata HOME rubriigi all ja seeprast lisatakse parentsi lppu objekt HOME.

		if ($args["lisa_objekt"]) { 
			$this->add($args["lisa_objekt"]);
		}


		if ($this->parent_id) {
			$id = $this->parent_id;

			$this->debug->msg("Parents. Alguses parent_id = ".$this->parent_id);

			$idid = Array();

			# juhul kui HOME, on vaja he sammu vrra alla minna
			if ($args["on_esileht"]){
				$this->debug->msg("Antud HOME rubriik, hppame he taseme vrra alla");
				$alamlist = new Alamlist2(array(
					"parent"	=> $id,
					"start"	=> 0,
					"limit"	=> 1,
					"tyyp"	=> 'rubriik',
					"order" => "kesk ASC, sorteering DESC", # added 19.05.03 by merle
					#sai maha vetud 3.1.10-s by merle: "asukoht" => 5,
				));
				$this->debug->msg($alamlist->debug->get_msgs());
				if ($alamlist->size) {
					$obj = $alamlist->get(0);
					$id = $obj->objekt_id;
					$this->debug->msg("Uus ID = $id");
				} else {
					$this->debug->msg("Kahjuks alla hpata ei saa... Pole sobivat kohta");
				}
			};

			$this->aktiivne_id=$id;

			#############################
			# allahppamine

			$this->debug->msg("JUMP: ================START================");

			$this->debug->msg("Jump down? ". ($this->site->in_editor || $this->site->in_admin ? "We are in editor-area or admin-area => abort mission" : "We are in public area => start mission"));

			# We are in public area => start missio:
			if ( !($this->site->in_editor || $this->site->in_admin) ) {

			do {
				$last_id = $id;

				$obj = new Objekt (array(
					"objekt_id" => $id,
				));
				$this->debug->msg($obj->debug->get_msgs());

				#####################
				# kui objekt on rubriik JA talle pole ei lehe- ega sisumalli mratud 
				# siis tuleb objekti auto avanemine ise otsustada.
				# variante on 2:

				if($obj->all[klass] == "rubriik" && 
					!$obj->all["page_ttyyp_id"] && !$obj->all["ttyyp_id"]) {

					$obj->all["on_auto_avanev"] = $this->site->master_tpl["on_auto_avanev"];
					$this->debug->msg("JUMP: Auto avanemise mrab saidi phimall (ID=".$this->site->master_tpl[ttyyp_id].")".$this->site->master_tpl["on_auto_avanev"]);
				}
				# kui objekt on rubriik JA talle pole malli mratud 
				#####################

				#####################
				# kui objektile pole mratud sisumalli aga on mratud lehemall,
				# siis vtta autoavanemise vrtus lehemalli kljest
				elseif($obj->all["page_ttyyp_id"] && !$obj->all["ttyyp_id"]) {
					$sql = $this->site->db->prepare("SELECT on_auto_avanev FROM templ_tyyp WHERE ttyyp_id=?",
						$obj->all["page_ttyyp_id"]
						);
					$sth = new SQL($sql);
					$obj->all["on_auto_avanev"] = $sth->fetchsingle();
					
				}

				$this->debug->msg("JUMP: Tulemus: objekt ".$obj->objekt_id. " ".($obj->all["on_auto_avanev"]? "ON" : "EI OLE")." auto avanev ");


				# juhul, kui malli on_auto_avanev = 1,
				# siis hakka pihta

				if ($obj->all["on_auto_avanev"]) {
			
					# kontrollime objektide olemasolu
					$alamlist = new Alamlist(array(
						"parent" => $obj->objekt_id,
#						 "asukoht"	=> "0,6",  #removed 19.03.03 by merle - doesnt work with SAPI
						"on_counter"=> 1,
						# changed classes 01.04.03 by merle - 
						# varem kontrolliti, et leiduks artikleid, nd otsitakse kiki v.a. rubriike (JA loginkaste - added 15.05.03 by merle)
						# - JA v.a Uudistekogu-sid (added 16.05.03 by merle)
						# - JA v.a Lingid (added 20.01.04 by merle) / kui mens on lingid, peab olema kik OK
						"not_klass"		=> "rubriik,loginkast,kogumik,link,productcategory",
						"order" => "kesk ASC, sorteering DESC", # added 19.05.03 by merle
					));
					$this->debug->msg($alamlist->debug->get_msgs());
					
					# alamlist on tyhi
					if ($alamlist->rows==0) {
						$this->debug->msg("JUMP: Otsime esimest alamrubriiki, kuhu viks hpata");
						$alamlist = new Alamlist2(array(
							"parent" => $obj->objekt_id,
							#"asukoht"	=> "0,9,5",  # Bugfix [#1212] by merle, 01.09.2004: Auto-allahppamine ei tohiks arvestada positsioonidega.
							"start"		=> 0,
							# "limit"		=> 1, # Bugfix [#539] by merle, 08.04.2003: limit oli enne 1, aga siis ei arvestatud rubriikidega, mis visid olla kasutajale keelatud. Nd prida kik rubriigid (sql-e juurde ei tule).
							"klass"		=> "rubriik,productcategory",
							"not_tyyp_nimi"		=> "Lingikast", # added 18.04.05 by merle: ra hppa kastide peale ;)
						));
						$this->debug->msg($alamlist->debug->get_msgs());
						# kui leiti alamrubriik vaata talle otsa ja pa teda lisada
						if ($alamlist->rows>0) {
							$obj = $alamlist->next();
							$this->debug->msg($alamlist->debug->get_msgs());							
							# kui ei nnestunud objekti korralikult ktte saada (polnud iguseid)
							# siis nendi fakti ja ra hppa alla
							if(!$obj->objekt_id){
								$this->debug->msg("JUMP: Objekti ei tehtud, ei hppa alla");
							}
							# vib alla hpata, sest objekt on tibens:
							else {
								# JUMP REALLY DOWN here: 
								$this->debug->msg("JUMP: Hppasime alla ja nd on aktiivne id = ".$obj->objekt_id);
								$id = $obj->objekt_id;
							} # kas objekt on vaatamiseks tibens
						} # kas leiti alamrubriike
						else {
							$this->debug->msg("JUMP: Ei hppa alla, sest polnud rubriiki, kuhu hpata");
						}
					} else {
						$this->debug->msg("JUMP: Ei hppa alla, sest leiti alamobjekte!");
					
					}				
				}
			} while ($last_id !== $id);

			} # to jump or not to jump

			$this->aktiivne_id=$id;
			$this->debug->msg("JUMP: ================END================");

			# / allahppamine
			#############################

			#############################
			# loop over parents
			$first = 1;
			$i = 0;
			while ($id) {
			# hakkame antud objektist lesse minna
				#######################
				# if current object, do extra checks:
				# 1) decide which parent to use from now on
				# 2) check if object's language matches with site language

				if($first || $i==1) { # if first or second (if we have sub-article as current object, Bug #1955)
					$obj_parent = ""; 

					# 1. ja 2. objekti pritakse 2 korda (pole ilus lahendus, hetkel hdavajadus):
					# 1. kord selleks, et teada saada tema klass
					$obj = new Objekt (array(
						"objekt_id" => $id,
						"no_cache" => 1,
					));
					#################
					# 1) if current object is article, then start searching parents (we have to find correct parent)
					if($obj->all["klass"] == "artikkel") {
						$this->debug->msg("Current object".($i==1?"'s parent":"")." is article. Start doing extra check.");
						# find all parent id-s of this object

						#####################
						# 1a. if found more than 1 parent => go on and find right parent
						if($obj->all['parents_count'] > 1) {

							$all_parents = $obj->get_obj_all_parents($obj->objekt_id);

							# v6ttame maha prygikasti rubriik parenti listist:
							if ($this->site->alias("trash")){
								if (in_array($this->site->alias("trash"), $all_parents)){
									$all_parents = array_diff($all_parents, Array($this->site->alias("trash")));
								};
							}
							$this->debug->msg("Object ".$obj->objekt_id." has ".sizeof($all_parents)." parents: ".join(",",$all_parents));

							# get cookie with previous page current section value
							#$cookie_parent = $this->site->sess_get("current_section");
							$cookie_parent = $_COOKIE["current_section"];						

							###################
							# parent_id in URL (Bug #538)
							# new feature: parameter "parent_id" in URL, it overrides "current_section" cookie settings

							if($this->site->fdat['parent_id']) { 
								$obj_parent = $this->site->fdat['parent_id'];
								$this->debug->msg("Parent found in URL. Parent set to: ".$obj_parent);
							}
							###################
							# if cookie has value, go on
							elseif($cookie_parent) {
								$this->debug->msg("Found current_section cookie: ".$cookie_parent);
								# if 1 object parent is same as cookie, take this for parent
								if(in_array($cookie_parent,$all_parents)) {
									$obj_parent = $cookie_parent;
									$this->debug->msg("Parent set to:".$obj_parent);
								}
								# if not match, go 1 step up, and check 2nd level
								else {
									$this->debug->msg("Cookie doesn't match. Searching match from parents...");
									foreach($all_parents as $par) {
										# find all parents for parent
										$all_parents = $obj->get_obj_all_parents($par);

										# if 1 object parent is same as cookie, take this for parent
										if(in_array($cookie_parent,$all_parents)) {
			
											$obj_parent = $par;
											$this->debug->msg("Parent set to:".$obj_parent);
											break;
										}
									} # foreach
									if(!$obj_parent) {
										$this->debug->msg("No match found in parents. Parent not set.");
									}
								} # if not match
							}
							# / if parent_id / cookie has value
							###################
							###################
							# just pick first parent - we have no info which one to prefer
							else {
								$this->debug->msg("I have no idea, which parent to prefer => choosing just the first one");						
							}
							# / just pick first parent - we have no info which one to prefer
							###################
						}
						# / if found more than 1 parent, go on
						#####################

					}
					# / if current object is article, then start searching parents
					#################

					# 2) check if object's language matches with site language
					if($obj->objekt_id) {
						
						$this->debug->msg("Language check: current object (ID=".$obj->objekt_id.") language is: ".$obj->all[keel]."; site language is: ".$this->site->keel);
						
						# if they differ, change site language
						if($obj->all[keel] != $this->site->keel) {
							$this->site->change_keel($obj->all[keel]);
							$this->debug->msg("Site language set to: ".$obj->all[keel]);

							# redirect user to same location & new lang will be loaded automatically:
							if (!substr_count($this->site->URI, 'langchange')){
								header("Location: ".$this->site->CONF["protocol"].$this->site->CONF["hostname"].$this->site->URI. (substr_count($this->site->URI, '?')? "":"?")."&langchange=1");
							}						
						}

					}
					$no_cache = 1;
				}# if current object

				# if not current object:
				else { 
					$obj_parent = ""; 
					$no_cache = 0; 
				}
				# / if current object, decide which parent to use from now on
				#######################

				###################
				# create object
				$obj = new Objekt2 (array(
					"objekt_id" => $id,
					"parent_id" =>  $obj_parent,
					"no_cache" => $no_cache,
				));
				$this->debug->msg($obj->debug->get_msgs());

				# if creating object fails (because of wrong parent), do it without parent
				if(!$obj->objekt_id) {
					$obj = new Objekt (array(
						"objekt_id" => $id,
						"no_cache" => 1,
					));
					$this->debug->msg($obj->debug->get_msgs());
				}
				############# if creating object still fails then QUIT because PARENT IS FORBIDDEN
				if(!$obj->objekt_id) {
					$this->debug->msg("PARENTS: Kuna ks parentitest on keelatud siis lpeta kogu t ja reseti parents");
					$this->list = Array();
					$this->objekts = Array();		
					$this->set_size();
					$this->index = -1;
					return;
				}

				############ IF OK
				elseif (!$idid["id".$id]) {

					# viimases rubriigis vaatame on_peida_vmenyy vrtus
					if ($obj->all["klass"] == "rubriik" && !isset($on_peida_vmenyy)) {
						$obj->load_sisu();
						$on_peida_vmenyy = $obj->all["on_peida_vmenyy"];
						$this->debug->msg("Aktiivse rubriigi on_peida_vmenyy is: ".$obj->all["on_peida_vmenyy"]);
					}

					# lisame objekt
					$this->add($obj);
					
					# on_aeg
					if (!strcmp($this->on_aeg,'') && $obj->all["klass"] == "rubriik") {
						$this->on_aeg = $obj->all["on_aeg"];
						$this->debug->msg("on_aeg = ".$this->on_aeg." (objekt_id = ".$obj->objekt_id.")");
					}

					# meta
					if ($this->meta["keywords"] == "" && $obj->all["meta_keywords"] != "") {
						$this->meta["keywords"] = $obj->all["meta_keywords"];
						$this->debug->msg("meta keyword = ".$this->meta["keywords"]);
					}
					if ($this->meta["description"] == "" && $obj->all["meta_description"] != "") {
						$this->meta["description"] = $obj->all["meta_description"];
						$this->debug->msg("meta description = ".$this->meta["description"]);
					}
					if ($this->meta["title"] == "" && $obj->all["meta_title"] != "") {
						$this->meta["title"] = $obj->all["meta_title"];
						$this->debug->msg("meta title = ".$this->meta["title"]);
					}

					$idid["id".$id]=1;

					############################
					# set next ID

					$id=$obj->parent_id;

					############################
					# set next ID exception: 18.05.03 by merle
					# force another parent for system article:

					# if object is system article, then dont proceed with its real parent (system section)
					# but force its parent to be first page in the site
					if($first && $obj->parent_id == $this->site->alias("system") && $obj->all["klass"] == "artikkel") {
						$this->debug->msg("Current object is system article: ".$obj->all[sys_alias]);
						$home_alamlist = new Alamlist2(array(
							"parent"	=> $this->site->alias("rub_home_id"),
							"start"	=> 0,
							"limit"	=> 1,
							"tyyp"	=> 'rubriik',
						));
						if ($home_alamlist->size) {
							$home_obj = $home_alamlist->get(0);
							$id = $home_obj->objekt_id;
							$this->debug->msg("Because its system article, parent is forced to be: $id");
						} else {
							$this->debug->msg("Setting new parent for system article failed - not found any section");
						}
					}
					# force another parent for system article:
					############################

				} else {
					$idid["id".$id]=1;
					$id='';
				}
				$i++;
				$first = 0;

			} # while obj
			# / loop over parents
			####################

			$this->on_peida_vmenyy = $on_peida_vmenyy; #defined("on_peida_vmenyy") ? constant("on_peida_vmenyy"):0;
		} # if parent
	} # function Parents
} # class Parents







class AlamlistSQL2 extends BaasObjekt {
	var $from;
	var $where;
	var $group;
	var $select_adds;
	var $order;

	var $parent_id;
	var $meta;
	var $rows;
	var $asukoht;
	var $klass;

	function AlamlistSQL2 () {
		$args = func_get_arg(0);
		$this->BaasObjekt();
		$this->meta = Array();
		$this->debug->msg("asukoht=".$args["asukoht"]);
		
		$args["asukoht"] = (strcmp($args["asukoht"],'') ? $args["asukoht"] : $args["kesk"]);
		$this->klass = (strcmp($args["tyyp_nimi"],'') ? $args["tyyp_nimi"] : $args["klass"]);
		$this->not_klass = $args["not_klass"];
		$this->not_tyyp_nimi = $args["not_tyyp_nimi"];
		$this->asukoht = $args["asukoht"];
		$this->ext_id = $args["ext_id"];
		$this->order = $args["order"] ? " ORDER BY ".$args["order"]." " : "";

		if (!strcasecmp(get_class($args["parent"]),"Objekt")) {
			# parent on objekt
			$this->parent_id = $args["parent"]->objekt_id;
		#} elseif (preg_match("/^\d+$/",$args["parent"])) {
		} else if ((is_numeric($args["parent"]) && $args["parent"]==0) || $args["parent"]) {
			# parent on objekti ID
			$this->parent_id = $args["parent"];
		} else {
			# parent on vigane
			$this->debug->msg("vigased algandmed: \"$args[parent]\" pole objekt ega objekti ID");
		}
		
		#06.05.2003 by Dima
		#if ($this->parent_id) {
		if ($this->parent_id || $this->parent_id === 0) {
			$this->debug->msg("parent_id=".$this->parent_id);

			$ary = array();
			$args["tyyp_nimi"] = trim($args["tyyp_nimi"]);

			# valmistame sql-i phiosa (v.a. select)
			/*
			# JOIN changed for optimize, 02.03.03 by merle
			$this->from = "FROM objekt 
					LEFT JOIN tyyp on objekt.tyyp_id = tyyp.tyyp_id 
					LEFT JOIN objekt_objekt on objekt.objekt_id=objekt_objekt.objekt_id ";
			*/
			############ FROM
			$this->from = "FROM objekt_objekt 
					LEFT JOIN objekt on objekt.objekt_id=objekt_objekt.objekt_id 
					LEFT JOIN tyyp on objekt.tyyp_id = tyyp.tyyp_id ";

			########### on_alampuu_kontroll => JOIN 
			if ($args["on_alampuu_kontroll"]) {
				# kontrollime alampuu olemasolu
				$this->debug->msg("Alampuu kontroll ON");

				$this->from .= " LEFT JOIN objekt_objekt as children on objekt.objekt_id=children.parent_id ";
				$this->from .= " LEFT JOIN objekt as children_objekt on children.objekt_id=children_objekt.objekt_id ";
				####### VIGA uue ver4 ACLiga - POOLELI::
				## added 1 || to get by
				# kui useril POLE igust nha avaldamata objekte:
#				if (!$this->site->user->is_superuser) {
#					$this->select_adds = ", sum((children_objekt.tyyp_id=$args[on_alampuu_kontroll])*(children_objekt.on_avaldatud=1)) as on_alampuu ";
#				} 
				# ksi alati kik objektid (ka avaldamata),
				# sest nitamise kontroll tehakse add() funktsioonis


				############ GROUP BY

				## Portable SQL: couldn't make it protable sql, using different SQL for MS SQL
				# (reasons in MS SQL: Every column in your select statement that is not used in an aggregate function MUST be included in the GROUP BY clause. )

				#### 1. for MSSQL
				if(strtoupper($this->site->CONF["dbtype"]) == 'MSSQL'){
# POOLELI
				}
				##### 2 default SQL
				else {

					$this->select_adds = ", SUM(children_objekt.tyyp_id=$args[on_alampuu_kontroll]) AS on_alampuu ";

					$this->group = " GROUP BY objekt.objekt_id ";
				} # default SQL or MS SQL 

			} ############ / on_alampuu_kontroll => JOIN 

			$this->debug->msg("FROM: ".$this->from);

				
			############ WHERE
			#06.05.2003 by Dima
			#$this->where = " WHERE objekt_objekt.parent_id = '".$this->parent_id."' ";
			$this->where = is_numeric($this->parent_id) ? " WHERE objekt_objekt.parent_id = '".$this->parent_id."' " : " WHERE objekt_objekt.parent_id IN (".addslashes($this->parent_id).")";

			# kui pole toimetamiskeskkonnas, siis ksi vaid avaldatud objektid (Bug #2205);
			# objekti nitamise kontroll tehakse add() funktsioonis hiljem niikuinii.
			if (!$this->site->in_editor && !$this->site->in_admin) { $this->where .= " AND objekt.on_avaldatud=1 "; }
						
			# Bug #580: artikli metadata kategooria filter
			if ($args["metadata_value"]) {
				$this->where .= " AND objekt.metadata_strip='".$args["metadata_value"]."'";
			}
			
			# Bug #580: featuur! kui init_articles on olemas vrtus "metadata_tyyp_id=2004", 
			# siis objekti klge panna tag {$obj->category}
			if ($args["metadata_value"] || $args["metadata_tyyp_id"]==2004) {
				$this->select_adds = ", objekt.metadata_strip ";
			}
			# klassid, $this->klass - comma separated list
			if (trim($this->klass)!=''){ 
				$klass_arr = split(",",$this->klass);
				$this->where .= " AND tyyp.klass IN('".join("','",$klass_arr)."') " ; 
			}

			if (trim($this->not_klass)!=''){ 
				$not_klass_arr = split(",",$this->not_klass);
				$this->where .= " AND tyyp.klass NOT IN('".join("','",$not_klass_arr)."') " ; 
			}

		if (trim($this->not_tyyp_nimi)!=''){ 
				$not_tyyp_nimi_arr = split(",",$this->not_tyyp_nimi);
				$this->where .= " AND tyyp.nimi NOT IN('".join("','",$not_tyyp_nimi_arr)."') " ; 
			}


			if (strcmp($args["asukoht"],'')) {
				$asukoht_arr = split(",",$args[asukoht]);
				$this->where .= " AND objekt.kesk IN('". join("','", $asukoht_arr) ."') ";
			}
			if ($args["max_vanus"]) {$this->where .= " AND objekt.aeg >= subdate(now(), INTERVAL $args[max_vanus]) ";}

			if ($this->ext_id) {$this->where .= $this->site->db->prepare(" AND objekt.ext_id=? ",$this->ext_id);}

			if($args[where]) {
				$this->where .= $this->add_where($args[where]);
			}			
			############ / WHERE

			############ additional FROM
			if($args[from]) {
				$this->from .= $this->add_from($args[from]);
			}

			$this->debug->msg("WHERE: ".$this->where);
			$this->debug->msg("GROUP: ".$this->group);
		} # if parent_id
	}
	######## / function AlamlistSQL 
	
	function add_where($where) {
		$this->where .= " AND $where ";
	}

	function add_from($from) {
		$this->from .= " $from ";
	}

	function add_select($select) {
		$this->select_adds .= ", $select ";
	}

	function add_group($group) {
		$this->group .= " $group ";
	}

	function make_sql() {
		return $this->from." ".$this->where." ".$this->group;
	}
}

class Alamlist2 extends ObjektArray2 {
# ---------------------------------------
# antud objekti alamobjektide ahel
#
# constructor new Alamlist(array(
#	"parent"		=> Objekt vi objekt_id *
#	"tyyp/klass"		=> "rubriik" 
#	kesk/"asukoht"=> 1
#	"start"		=> 10
#	"limit"		=> 5
#	"max_vanus"	=> 7 DAYS
#	"on_counter"	=> 1
#	ext_id       => 0
#	"metadata_tyyp_id" => default null
#   "not_klass"	=> 
# ));
# * - vajalik parameeter
# ---------------------------------------
#
# 2do: kasutajate piirangud, s.h. objekti avalikus
#

	var $parent_id;
	var $meta;
	var $rows;
	var $asukoht;
	var $klass;
	var $metadata_tyyp_id;

	var $sql;

	function Alamlist2 () {
		$args = func_get_arg(0);
		$this->ObjektArray2();

		if (is_object($args["alamlistSQL"])) {
			$this->debug->msg("AlamlistSQL on antud");
			$this->sql = $args["alamlistSQL"];
		} else {
			$this->debug->msg("AlamlistSQLi pole - teen ise");
			$this->sql = new AlamlistSQL2($args);
		}
		
		$this->parent_id = $this->sql->parent_id;
		$this->klass = $this->sql->klass;
		$this->asukoht = $this->sql->asukoht;
		$this->ext_id = $args[ext_id];
		$this->metadata_tyyp_id = $args["metadata_tyyp_id"];
		$this->select_strip_fields = $args["select_strip_fields"];

		$this->debug->msg("klass = ".$this->klass. "; not_klass = ".$this->sql->not_klass. "; not_tyyp_nimi = ".$this->sql->not_tyyp_nimi);
		
		if ($this->sql->parent_id || $this->sql->parent_id === 0) {

			$this->parent_id = $this->sql->parent_id;

			if ($args["on_counter"]) {
				
				# bug #2174 workaround
				($this->site->in_editor ? 0 : $this->sql->add_where('objekt.on_avaldatud = 1'));
				
				# ainult loendmae palju objektid on
				$sql = "SELECT COUNT(objekt.objekt_id) " . $this->sql->make_sql();
				$sth = new SQL($sql);
				$this->rows = $sth->fetchsingle();
				$this->debug->msg($sth->debug->get_msgs());
				$this->debug->msg("Leitud ".$this->rows." alamobjekti");
			} else {
	
				# valmistame objektide loetelu 
				$sql = "
					SELECT objekt.objekt_id, objekt.pealkiri, objekt.on_pealkiri,
					objekt.on_avaldatud, objekt.keel, objekt.pilt, objekt.pilt_aktiivne, objekt.kesk, 
					objekt.ttyyp_id, objekt.page_ttyyp_id, objekt.on_foorum, objekt.aeg, objekt.meta_keywords, objekt.friendly_url, objekt.meta_title,
					objekt.meta_description, objekt.metadata_tyyp_id, objekt.sys_alias, objekt.ttyyp_params, objekt.ext_id, objekt.author, objekt.is_hided_in_menu, objekt.last_modified,
					objekt.created_user_id, objekt.created_user_name, objekt.changed_user_id, objekt.changed_user_name, objekt.created_time, objekt.changed_time, 
					objekt_objekt.parent_id, objekt_objekt.sorteering, objekt.last_commented_time, objekt.comment_count, objekt.on_saadetud,
					tyyp.tyyp_id, tyyp.tabel, tyyp.klass ";
				if($this->select_strip_fields){ # used for search operations (dont include by default, optim.)
					$sql .= " ,objekt.pealkiri_strip, objekt.sisu_strip ";
				}
				$sql .= $this->sql->select_adds." ".$this->sql->make_sql();
				# ORDER
				if ($this->sql->order) {
					$sql .= $this->sql->order;
				} else {
					$sql .= " ORDER BY objekt_objekt.sorteering DESC ";				
				}
				# LIMIT
				if (is_numeric(trim($args["start"])) && is_numeric(trim($args["limit"]))) { 
					$sql .= " LIMIT $args[start],$args[limit]"; 
				} elseif ( !is_numeric($args[start]) && is_numeric(trim($args["limit"])) ) {
					$sql .= " LIMIT $args[limit]"; 
				}
				$sth = new SQL($this->site->db->prepare($sql));
				$this->rows = $sth->rows; ### NB!
				$this->debug->msg("Leitud ".$this->rows." alamobjekti");
				while ($ary = $sth->fetch()) {
					$this->debug->msg("Objekt leitud: $ary[objekt_id]. ".$ary["pealkiri"]);

					$this->add(
						new Objekt(array(
							"ary" => $ary
						))
					);

				} # while 
				$this->debug->msg($sth->debug->get_msgs());
			} # if on_counter
		} # if parent_id
		else {
			$this->debug->msg("Error: puudub parent ID");
		}
#$this->debug->print_msg();
	} # function Alamlist ()


	function edit_buttons () {
		$args = func_num_args()==1 ? func_get_arg(0) : func_get_args();

		$args["ainult_kui_tyhi"] = strcmp($args["ainult_kui_tyhi"],'') ? $args["ainult_kui_tyhi"]:1;
		
		if (!($args["ainult_kui_tyhi"] && $this->size)) {
			print $this->get_edit_buttons($args); 
		}
	}

	function get_edit_buttons () {
		$args = func_get_arg(0);

		# EDITOR-AREA CHECK: print buttons only for editor-area, else return nothing
		if(!$this->site->in_editor && !$this->site->in_admin && !$args['button_always_visble']) {
			return "";
		}

		$self = $this->site->safeURI;
		$parent_id = $this->parent_id;
		$kesk = $this->asukoht;
		$ext_id = $this->ext_id;	
		$keel = is_numeric($args["keel"]) ? $args["keel"] : $this->site->keel;

		# get parent permissions
		$perm = get_obj_permission(array(
			"objekt_id" => $this->parent_id,
		));

		######### if user has C or U or P or D  permission (see also Bug #1985)
		# then show buttons, otherwise show nothing
		if( !($perm['C'] || $perm['U'] || $perm['P'] || $perm['D']) ) {
			return "";
		}

		######### nuppude vrvid

		if (preg_match("/^\d+$/",$args[tyyp_idlist])) {
			$type = $args[tyyp_idlist];
		} else {
			$type = $this->klass;
		}
		if($this->site->user->user_id){
			$prefix = $this->site->user->nupude_prefix($type);
		} else {
			$prefix = $this->site->guest->nupude_prefix($type);	
		}


		if ($prefix=="_" || !$prefix) {$prefix = 'r_';}
		$this->site->debug->msg("Nuppude klass ".$this->klass.", prefix = $prefix"); 
		$result='';

		$admpath = $this->site->CONF["wwwroot"].$this->site->CONF["adm_path"];
		$imgpath = $this->site->CONF["wwwroot"].$this->site->CONF["adm_img_path"];

		#Juhul kui METADATA_TYYP_ID on olemas

		$meta_data = (!empty($this->metadata_tyyp_id))?"&metadata_tyyp_id=".$this->metadata_tyyp_id:"";
		if (!empty($this->metadata_tyyp_id)){
			$metadata_tyyp_id = $this->metadata_tyyp_id;
		}


		# juhul kui tp on asset, siis PEAB alati kaasas olema ka profiili ID (muidu ei oma custom asset mtet)
		# igal juhul lisada nupu urlile ka 'profile_id' (by merle 19.11.2004)
		if( 1 || stristr($args[tyyp_idlist], "20") ) {
			$profile = "&profile_id=".$args[profile_id];
		}
		# NEW nupp:
		if (!$args["only_edit"]) {
			
		
			# show new button only when user has create permission for parent object
			/*
			if($perm['C']){
				
				$result .= "<a href=\"javascript:avaaken('$admpath/edit.php?op=new&keel=$keel&parent_id=$parent_id&previous_id=$obj_id&kesk=$kesk&sys_alias=$args[sys_alias]&tyyp_idlist=$args[tyyp_idlist]&ext_id=$ext_id".$meta_data.$profile."', 450, 430);\"><img src=$imgpath/".$prefix."new_s.gif border=0 alt=\"New\"></a>";
			}
			*/
			if (!$args["peida_text"]) {
				# klassi nime pole => kirjuta 'uus'

				if(!$this->klass) {
					#$sona = $this->site->sys_sona(array("sona" => "new", "tyyp"=>"editor"));
				}
				# kui ette ei antud komadega tpide list vaid anti 1 klass, kirjuta ka klassi nimi
				elseif (!stristr($this->klass,',')) {
					$sona = $this->site->sys_sona(array("sona" => "new", "tyyp"=>"editor")).' '.strtolower($this->site->sys_sona(array(sona => "tyyp_".$this->klass, tyyp=>"System")));
				}
				if ( $sona ) {
					$result .= "<font class=txt>&nbsp;$sona</font>";
				}
			}

			################################################
			# Oh yeah NEW "imenupp"
			################################################

			if($perm['C']){
				
				$result .= '<editor:buttons baseurl="'.$this->site->CONF['protocol'].$this->site->CONF['hostname'].$this->site->CONF['wwwroot'].'/" url="" object_id="" parent_id="'.$parent_id.'" previous_id="'.$obj_id.'" position="'.$kesk.'" ttyyp_id="'.$ttyyp_id.'" tyyp_idlist="'.$args[tyyp_idlist].'" lang="'.$keel.'" visible="'.($this->on_avaldatud?1:0).'" metadata_tyyp_id="'.$metadata_tyyp_id.'" profile_id="'.$args[profile_id].'" publish="'.$args['publish'].'" buttons="N" permissions="N" class="scms_arrow_visible" onclick="return false"><IMG SRC="'.$this->site->CONF['protocol'].$this->site->CONF['hostname'].$this->site->CONF['wwwroot'].'/styles/default/gfx/px.gif" WIDTH="13" HEIGHT="13" BORDER=0 ALT=""></editor:buttons>';
			}

		}
		return $result.($args["no_br"] ? '':'<br>');
	}
}

$CONFDB = readconfdb2(); # db connect data from config table (ver4)
#printr($CONFDB);

ini_set('display_errors', 1);

/***********************************/
/* GLOBAL                          */
/***********************************/

# array of binary field types to ignore
$BLOB_TYPE_ARR = array('tinyblob', 'blob', 'mediumblob', 'longblob');

$op = ($_POST["op"] ? $_POST["op"] : 'step1');
$step_nr = substr(strtolower($op ? $op : "step1"), -1);
$step_count = '7';

$prefix = "350_"; # source tables prefix
$from_ver = '3.5.0';
$to_ver = '4.5.0';

#encoding that is offered to user by default
$default_to_encoding = "UTF-8";

## use case #2: ver3 site data is copied to "ver3/" folder
$guess_ver3_path = getcwd() . '/ver3/';


/***********************************/
/* HTML START                      */
/***********************************/
?>
<html>
	<head>
		<title>Saurus CMS version converter 3 to 4</title>
		<meta name="author" content="Saurus - www.saurus.info">
		<meta http-equiv="Cache-Control" content="no-cache">
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
		<link rel="stylesheet" href="styles/default/scms_general.css">
		<link rel="stylesheet" href="styles/default/scms_install.css">
		<style type="text/css">
		body {
			overflow: auto !important; 
		}
		</style>
	</head>

<body>
<font class="txt">
<center>

<div id="installheader">
	<table width="750">
	<tr>
		<td valign="bottom"><h1>Saurus CMS version converter 3 to 4: Step <?=$step_nr?> of 
		<?=$step_count?></h1></td>
		<td align="right"><img class="logo" src="styles/default/gfx/install/logo.gif" height="20" width="101" alt="Saurus" /></td>
	</tr>
	</table>
</div>

<?
######################
# wizard
?>  

<table width="750" border="0" cellspacing="0" cellpadding="0">
<tr> 
<td valign=top style="height:450px;"> 
	<!-- Scrollable area -->
	<div id="listing" class="scms_scroll_div">

 


<?
/***********************************/
/* STEPS START                     */
/***********************************/
switch (@$op) {

	case "step1":

############################
# STEP 1
# - check current version number, must match requirements
# - ask for ver3 failid/, templates/ path
# - ask ver3 db dump file
# - display system info
############################

	$version_error = false;
	?>
	<form action="<?=$_SERVER['PHP_SELF'];?>" method="post" name="form" enctype="multipart/form-data">

	This script converts Saurus CMS <?=$from_ver?> database to the version <?=$to_ver?>. Please read README file before continuing.<br /><br />

	<? ################## check ver 3 CURRENT VERSION NUMBER (must be 3.5.0 or later)
	$current_ver3 = current_version_ver3();
	# if current ver is not correct => display error message
	echo "Checking version number 3.x ... ";
	if ($current_ver3 === false) { ?>
		<font color=red>Version 3 databases not found.<br /><br />Make sure you have your old database dump ready before proceeding.</font>
	<?
	} elseif ($current_ver3 < $from_ver) { ?>
		<font color=red><b>VERSION ERROR: </b>Current version 3 number is <b><?=$current_ver3?></b>, expected version is:  <b><?=$from_ver?></b> or later.</font>
	<?	$version_error = true;
	} else {
		echo "Your version is " . $current_ver3 . ". OK to proceed.";
	}	
	?>

	<br /><br />
	<? ################## check for ver 3 directory
	if (!file_exists($guess_ver3_path)) { ?>
		<font color=red><b>Can't find directory <?=$guess_ver3_path?>.</b> Make sure your convert.php script is in the right directory and you have copied the necessary version 3 files to your version 4 directory.</font>
		<br /><br />
	<?
	}

	################## check ver 4 CURRENT VERSION NUMBER (must be 4.5.0 or higher)
	$current_ver = current_version_ver4();
	# also store it in session for later use
	$_SESSION["current_version_ver4"] = $current_ver;
	# if current ver is not correct => display error message
	echo "Checking version number 4.x ... ";

	if ($current_ver === false) { ?>
		<font color=red><b>VERSION ERROR: </b>Version 4 databases not found.</font>
	<? $version_error = true;
	} elseif ($current_ver < $to_ver) { ?>
		<font color=red><b>VERSION ERROR: </b>Current version 4 number is <b><?=$current_ver?></b>, expected version is:  <b><?=$to_ver?></b></font> or later.<br /><br />Please fix the errors and try again.<br /><br />
	<?	$version_error = true;
	} else {
		echo "Your version is " . $current_ver . ". OK to proceed.";
	} 

	# versions are OK => go on
	if (!$version_error) {
	?>

	<table border=0>
	<tr><td colspan=2><h2>Location of ver <?=$from_ver?> data files:</h2></td></tr>

	<?############# failid_path?>
	<tr>
	<td>Absolute path to ver3 "<b>failid/</b>" folder (with trailing slash):</td>
	<td><input type="text" NAME="failid_path" value="<?=$guess_ver3_path?>failid/" style="width:300px"></td>
	</tr>

	<?############# templates_path?>
	<tr>
	<td>Absolute path to ver3 "<b>templates/</b>" folder (with trailing slash):</td>
	<td><input type="text" NAME="templates_path" value="<?=$guess_ver3_path?>templates/" style="width:300px"></td>
	</tr>

	</table>
	
	<br />
	<br />

	<table border=0>

	<?############# db dump ?>
	<tr>
	<td colspan=2><h2>Location of ver <?=$from_ver?> database data - choose one of the following:</h2></td>
	</tr>

	<? if ($current_ver3 === false) { ?>
	<tr>
	<td colspan="2"><INPUT TYPE="checkbox" NAME="prefix_added" value="1">I used bash script "<b>addprefix2dump.sh</b>" or windows executable "<b>addprefix2dump.exe</b>".</td>
	</tr>
	<? } ?>
	
	<? if ($current_ver3 !== false) { ?>
	<tr>
	<td colspan="2"><INPUT TYPE="radio" NAME="data_source" value="done" checked="checked">Old ver3 tables are already imported into the <?=$to_ver?> database.</td>
	</tr>
	<? } else { ?>

	<tr>
	<td><INPUT TYPE="radio" NAME="data_source" value="upload">I want to <b>upload</b> <?=$from_ver?> database dump-file:</td>
	<td><input type="file" NAME="data_file" style="width:300px"></td>
	</tr>

	<tr>
	<td><INPUT TYPE="radio" NAME="data_source" value="path">I enter <b>absolute path</b> to the database dump-file:</td>
	<td><input type="text" NAME="data_file_path" style="width:300px" value="<?=$guess_ver3_path?>"></td>
	</tr>
	<? } ?>


	</table>
	<br />
	<center>
	<INPUT type="hidden" name="op" value="step2">
	<INPUT type="submit" value="Next" class="redbutton">
	</center>
	</form>

	<?############ system info ?>
	<h2>Current system info</h2>
	<ul>
	<li>upload_max_filesize = <b><?=ini_get('upload_max_filesize')?></b> </li>
	<li>post_max_size = <b><?=ini_get('post_max_size')?></b></li>
	<li>max_execution_time = <b><?=ini_get('max_execution_time')?></b> sec</li>
	<li>memory_limit = <b><?=ini_get('memory_limit')?></b></li>		
	</ul>

	Depending on the database dump file size you may need to increase these PHP settings in .htaccess file.
		
	<br />

<?
	} elseif ($current_ver !== false) { # version4 ok, can convert encoding
?>
	<br />
	<br />
	<br />
	<form action="<?=$_SERVER['PHP_SELF'];?>" method="post" name="form">
		Press Skip if you have already converted to Saurus CMS version 4 and want to skip to encoding conversion
		<center>
		<INPUT type="hidden" name="op" value="step6">
		<INPUT type="submit" value="Skip" class="redbutton">
		</center>
	</form>
<?
	}
?>
	</div>
	<br><br>
<?
	show_help();
	break;

	case "step2":
############################
# STEP 2
# - take ver3 db dump-file and import all tables to ver4 db with table prefix "350_"
# - copy failid/ content to public/
# - copy templates/ content 
# - Saurus API tag check: check deprecated {print_header} and {print_footer} tag in templates, give warnings if found
############################
?>
	<form action="<?=$_SERVER['PHP_SELF'];?>" method="post" name="form" enctype="multipart/form-data">

	<h2>Copying <?=$from_ver?> data files...</h2>
<?	
	#####################
	# copy failid/ content to public/
	$copy_ok = copy_folder(array(
		'source_folder' => $_POST['failid_path'],
		'target_folder' => realpath('.' . $CONFDB['file_path'])
	));
	print "<b>Folder</b> \"" . $_POST['failid_path'] . "\" => \"" . realpath('.' . $CONFDB['file_path']) . "/\": ";
	if ($copy_ok === true) {
		print "<b>COPY OK</b><br />";
	} else {
		print "<font color=red><b>COPY ERROR</b></font><br />";
	}

	####################
	# copy templates/ content
	$copy_ok = copy_folder(array(
		'source_folder' => $_POST['templates_path'],
		'target_folder' => realpath('./classes/smarty/templates')
	));
	print "<b>Folder</b> \"" . $_POST['templates_path'] . "\" => \"" . realpath('./classes/smarty/templates') . "/\": ";
	if ($copy_ok === true) {
		print "<b>COPY OK</b><br />";
	} else {
		print "<font color=red><b>COPY ERROR</b></font><br />";
	}
?>
	<br />
	<h2>Checking Saurus API tags in the templates...</h2>

<?	####################
	# search {print_header} and {print_footer} tag in templates
	$check_ok = check_deprecated_sapi_tags(array(
		'target_folder' => realpath('./classes/smarty/templates')
	));
	if ($check_ok === true){
		print "<br /><b>Check OK</b><br />";
	} else {
		print "<br /><font color=red><b>TAG CHECK ERROR</b></font><br />";
	}


	##########################
	# DB DUMP: insert data from given database dump file => into active database
?>
	<br />
	<h2>Importing <?=$from_ver?> database...</h2>

<?	
	# error controls: 2.upload
	if ($_POST["data_source"] == "upload" && !$_FILES["data_file"]["name"]) { 
		 print "<font color=red><b>UPLOAD ERROR</b>. <a href='convert.php'><b>Go back</b></a> and retry to upload database dump-file.</font><br />";
	}
	# error controls: 3.path
	elseif ($_POST["data_source"] == "path" && !$_POST["data_file_path"]){ 
		 print "<font color=red><b>ABSOLUTE PATH ERROR</b>. <a href='convert.php'><b>Go back</b></a> and retry to enter asbolute path to the database dump-file.</font><br />";
	} else { 	# input data are OK => go on
		# 2. upload OR 3. path
		if ($_POST["data_source"] == "upload" && $_FILES["data_file"]["name"]
			|| $_POST["data_source"] == "path" && $_POST["data_file_path"]) {

		
			if ($_POST["prefix_added"] == 1) {
				$tbl_error = run_dumpfile2(false);
			} else {
				$tbl_error = run_dumpfile2(true);
			}
			if ($tbl_error != '') { ?>
				<font color="#cc0033">
				<?=$tbl_error?>
				<br />Errors ocurred during database import. <a href='convert.php'><b>Go back</b></a></font>
				<? 
				exit;	
			} 
			else {
				print "Import successful<br />";
			}
		} else { # 1.done
			print "Import skipped<br />";
		}

	##########################
	# next button
?>
		</div>
		<br />
		<br />
		<br />
		<br />
		Next step will convert data between ver3 and ver4 tables.
		<br /><br />
		<br />
			<center>
			<INPUT type="hidden" name="op" value="step3">
			<INPUT type="submit" value="Next" class="redbutton">
			</center>
			</form>
			<br /><br />

<?
	} # input data nOK/OK
	
	break;

	case "step3":
############################
# STEP 3
# - convert all data
# - sync extensions
# - run all version updates
# - synchronize all folders&files in FS <=> DB
############################

	$site = new Site(array(
		on_debug=>0
	));

	echo "<br>Dropping tables that are not needed<br>";
	run_sql("DROP TABLE _tmp_sonad, admin_osa, allowed_mails, cache, config_images, css, document_parts, error_log, event_bindings, ext_country, ext_timezones, extensions, favorites, forms, gallup_ip, gallup_vastus, groups, ip_filter, kasutaja_sso, keel, lang_mapping, ldap_map, ldap_servers, logi, metadata, metadata_tyyp, moodulid, notifications, obj_artikkel, obj_asset, obj_dokument, obj_event, obj_file, obj_folder, obj_gallup, obj_kommentaar, obj_link, obj_pilt, obj_resource, obj_rubriik, object_profiles, objekt, objekt_ext_parents, objekt_objekt, permissions, preferences, product, product_category, product_category_description, product_description, product_manufacturer, product_profiles, replicator, roles, session, shop_cart, shop_order, spam, sso, stat_agents, stat_domains, stat_logs, stat_summary, stat_visitors, stats_objects, styles, sys_sona_tyyp, sys_sonad, sys_sonad_kirjeldus, tbl, templ_tyyp, tyyp, user_mailinglist, user_roles, users, xdb, xml, xml_dtd, xml_map", 1);

  	$sql = $DB->prepare("SELECT * FROM config WHERE nimi='hostname' or nimi='wwwroot'");
  	$sth = new SQL($sql);
	$config_parameters = array();
  	if (!$sth->error) { 
  		while ($row = $sth->fetch()) {
			$values_arr = array();
			foreach ($row as $field=>$val) {
				if (!is_numeric($field)) {
					$values_arr[] = $DB->prepare($field . "=?", $val);
				}
			}
			$parameters->set_values = join(", ", $values_arr);
			$parameters->name = $row["nimi"];

			$config_parameters[] = $parameters;
		}
	}

	echo "<br>Converting db to 4.2.0<br>";
	run_sql_file("default_db_4.2.0.sql");
	echo "<script>document.getElementById('listing').scrollTop = document.getElementById('listing').scrollHeight - 500;</script>";
	flush(); sleep(1);

	foreach ($config_parameters as $values_arr) {
		$sql = "UPDATE config SET " . $values_arr->set_values . " WHERE nimi='" . $values_arr->name . "'";
		//print $sql . "<br>";
		run_sql($sql, 1, 0);
	}

	echo "<br>Converting db to 4.2.1<br>";
	run_sql_file("update4.2.0to4.2.1.sql");
	echo "<script>document.getElementById('listing').scrollTop = document.getElementById('listing').scrollHeight - 500;</script>";
	flush(); sleep(1);

	# upgrade old db structure
	update_old_structure();
	echo "<script>document.getElementById('listing').scrollTop = document.getElementById('listing').scrollHeight - 500;</script>";
	flush(); sleep(1);

	# copy identical tables
	# ("license" table is missing here, may be needed, not sure)
	copy_identical_tables('allowed_mails,cache,ip_filter,lang_mapping,ldap_map,ldap_servers,logi,metadata,metadata_tyyp,notifications,product,product_category,product_category_description,product_description,product_manufacturer,product_profiles,replicator,shop_cart,shop_order,spam,sso,stat_agents,stat_domains,stat_logs,stat_summary,stat_visitors,stats_objects,styles,tbl,xdb,xml,xml_dtd,xml_map');
	
	# following system tables must not be overwritten: config, moodulid, tyyp, version.

	# convert object_profiles - create new table fields if needed
	convert_profiles();

	# create identical "ext_" tables (structure + data)
	create_ext_tables();

	# copy content objects (add creation info, etc)
	copy_content_objects();
	echo "<script>document.getElementById('listing').scrollTop = document.getElementById('listing').scrollHeight - 500;</script>";
	flush(); sleep(1);

	# copy styles info: convert styles.php => custom css
	copy_css();
	echo "<script>document.getElementById('listing').scrollTop = document.getElementById('listing').scrollHeight - 500;</script>";
	flush(); sleep(1);

	# copy templ_tyyp: copy ver3 data + add ver4 info
	copy_templ_tyyp();
	echo "<script>document.getElementById('listing').scrollTop = document.getElementById('listing').scrollHeight - 500;</script>";
	flush(); sleep(1);

	# copy keel: copy ver3 data
	copy_lang();
	echo "<script>document.getElementById('listing').scrollTop = document.getElementById('listing').scrollHeight - 500;</script>";
	flush(); sleep(1);

	# copy partial old config values 
	copy_config();	

	# replace links (internal links in the content, eg failid/)
	replace_links();
	echo "<script>document.getElementById('listing').scrollTop = document.getElementById('listing').scrollHeight - 500;</script>";
	flush(); sleep(1);

	# convert users, groups, roles
	convert_users();
	echo "<script>document.getElementById('listing').scrollTop = document.getElementById('listing').scrollHeight - 500;</script>";
	flush(); sleep(1);

	# convert permissions
	convert_permissions();

	###################
	# insert CUSTOM system words
	## id=23 - custom group
	run_sql("DELETE FROM sys_sonad_kirjeldus WHERE sys_sona IN (SELECT sys_sona COLLATE latin1_general_cs FROM 350_sys_sonad_kirjeldus WHERE sst_id=23) AND sst_id=23", 1);
	run_sql("INSERT INTO sys_sonad_kirjeldus (sst_id, sys_sona, sona, last_update) SELECT sst_id, sys_sona, sona, last_update FROM " . $prefix . "sys_sonad_kirjeldus WHERE sst_id=23;", 1);
	#run_sql("DELETE FROM sys_sonad WHERE sst_id=23;", 1);
	run_sql("DELETE FROM sys_sonad WHERE sys_sona IN (SELECT sys_sona COLLATE latin1_general_cs FROM 350_sys_sonad WHERE sst_id=23) AND sst_id=23", 1);
	run_sql("INSERT INTO sys_sonad (sst_id, sys_sona, sona, origin_sona, keel) SELECT sst_id, sys_sona, sona, origin_sona, keel FROM " . $prefix . "sys_sonad WHERE sst_id=23;", 1);
	## id=14 - atp group (may be custom translations)
	run_sql("DELETE FROM sys_sonad_kirjeldus WHERE sst_id=14;", 1);
	run_sql("INSERT INTO sys_sonad_kirjeldus (sst_id, sys_sona, sona, last_update) SELECT sst_id, sys_sona, sona, last_update FROM " . $prefix . "sys_sonad_kirjeldus WHERE sst_id=14;", 1);
	run_sql("DELETE FROM sys_sonad WHERE sst_id=14;", 1);
	run_sql("INSERT INTO sys_sonad (sst_id, sys_sona, sona, origin_sona, keel) SELECT sst_id, sys_sona, sona, origin_sona, keel FROM " . $prefix . "sys_sonad WHERE sst_id=14;", 1);

	## id=15 - metadata (deprecated group in ver4)
	run_sql("DELETE FROM sys_sonad_kirjeldus WHERE sst_id=15;", 1);
	run_sql("INSERT INTO sys_sonad_kirjeldus (sst_id, sys_sona, sona, last_update) SELECT sst_id, sys_sona, sona, last_update FROM " . $prefix . "sys_sonad_kirjeldus WHERE sst_id=15 AND sys_sona <> 'Default article category' AND sys_sona <> 'Default event category';", 1);

	run_sql("DELETE FROM sys_sonad WHERE sst_id=15;", 1);
	run_sql("INSERT INTO sys_sonad (sst_id, sys_sona, sona, origin_sona, keel) SELECT sst_id, sys_sona, sona, origin_sona, keel FROM " . $prefix . "sys_sonad WHERE sst_id=15 AND sys_sona <> 'Default article category' AND sys_sona <> 'Default event category';", 1);
	# if any custom word was inserted, then add 'metadata' system group also (otherwise not)
	run_sql("INSERT INTO sys_sona_tyyp (sst_id, voti, nimi, moodul_id) VALUES (15, 'metadata', 'Metadata', 0);", 1);

	# fix stats XSS bug for old data:
	//$error = run_scriptfile2("admin/updates/update4.0.13to4.0.14.php");
	fix_xss_bug();
	echo "<script>document.getElementById('listing').scrollTop = document.getElementById('listing').scrollHeight - 500;</script>";
	flush(); sleep(1);

	# sync extensions:
	//$error = run_scriptfile2("admin/updates/update4.0.15to4.1.0.php");
	include_once($class_path . "extension.class.php");
	sync_extensions2();
	echo "<script>document.getElementById('listing').scrollTop = document.getElementById('listing').scrollHeight - 500;</script>";
	flush(); sleep(1);

	run_sql("alter table obj_folder add column relative_path tinytext NULL after fullpath;", 1);
	echo "<script>document.getElementById('listing').scrollTop = document.getElementById('listing').scrollHeight - 500;</script>";
	flush(); sleep(1);
?>
		</div>
		<hr size=1>

		<form action="<?=$_SERVER['PHP_SELF'];?>" method="post" name="form">
		First step of data conversion completed. Next step will continue converting data.
		<br /><br />
			<center>
			<INPUT type="hidden" name="op" value="step4">
			<INPUT type="submit" value="Next" class="redbutton">
			</center>
			</form>

<?

	flush();

	break;
case "step4":
############################
# STEP 4
############################
	$versions = array();

	foreach (glob("admin/updates/update*to*.sql") as $filename) {
		$update_fromver = substr($filename, 20);
		$update_tover = substr($update_fromver, strpos($update_fromver, "to") + 2, -4);
		$update_fromver = substr($update_fromver, 0, strpos($update_fromver, "to"));
		if ($update_tover >= '4.2.1' &&	$update_tover <= $_SESSION["current_version_ver4"]) {
			$versions[] = $update_tover;
		}
	}

	run_version_updates();
	flush(); sleep(1);

	# Create new extension folder and create custom CSS.
	if(is_writeable(getcwd() . "/extensions/")) {

		$extension_name = create_empty_extension();
		echo "<br>Creating a new extension called '" . $extension_name . "' to be used with the Modern page template<br>";
		convert_CSS($extension_name);
		echo "<br>v3 custom site design CSS as been converted into a css file under the new extension folder. <br>";
	}

	# sync files & folders
	if ($_SESSION["current_version_ver4"] < '4.6.0') {
		sync_all_folders();
	}
	else
	{
		run_sql("delete from objekt where sys_alias = 'public'",1);
		
		$sql = "insert into objekt (pealkiri, tyyp_id, on_avaldatud, keel, pealkiri_strip, aeg, sys_alias, created_time) values ('public', 22, '1', 1, 'public', now(), 'public', now())";
		$result = new SQL($sql);
		$public_folder_id = $result->insert_id;
		
		// objekt_objekt
		run_sql("insert into objekt_objekt (objekt_id, parent_id, sorteering) values (".$public_folder_id.", 0, 2)",1);
		
		// obj_folder
		run_sql("insert into obj_folder (objekt_id, relative_path) values (".$public_folder_id.", '".$site->CONF['file_path']."')",1);
		
		// permissions
		run_sql("insert into permissions (type, source_id, group_id, user_id, C, R, U, P, D) VALUES ('OBJ', ".$public_folder_id.", 1, 0, '1', '1', '1', '1', '1')",1);

		synchronise_folder($public_folder_id);

		$sql = "insert into objekt (pealkiri, tyyp_id, on_avaldatud, keel, pealkiri_strip, aeg, sys_alias, created_time) values ('shared', 22, '1', 1, 'shared', now(), 'shared', now())";
		$result = new SQL($sql);
		$shared_folder_id = $result->insert_id;
		
		// objekt_objekt
		run_sql("insert into objekt_objekt (objekt_id, parent_id, sorteering) values (".$shared_folder_id.", 0, 1)",1);
		
		// obj_folder
		run_sql("insert into obj_folder (objekt_id, relative_path) values (".$shared_folder_id.", '".$site->CONF['secure_file_path']."')",1);
		
		// permissions
		run_sql("insert into permissions (type, source_id, group_id, user_id, C, R, U, P, D) VALUES ('OBJ', ".$shared_folder_id.", 1, 0, '0', '0', '0', '0', '0')",1);

		synchronise_folder($shared_folder_id);
	}
	echo "<script>document.getElementById('listing').scrollTop = document.getElementById('listing').scrollHeight - 500;</script>";
	flush(); sleep(1);

	include_once($class_path.'lang_functions.inc.php');
	
	if (preg_match("/^[^\?]*\//", $_SERVER["SCRIPT_FILENAME"], $matches)) {
		$doc_root = $matches[0];
		$doc_root = preg_replace("/\/admin\//i", "", $doc_root);
	}
	# if export
	for ($language_id = 0; $language_id < 2; $language_id++) {
		$local_file_name = $doc_root . "admin/updates/UTF-8/language" . $language_id . ".csv";

		print $local_file_name . "<br>";

		if (!import_dict_from_file($local_file_name, true, false)) {
			echo '<font style="color: red;">Dictionary import failed.</font>';
		} else {
			echo 'Dictionary import complete.<br>';
		}
		echo "<script>document.getElementById('listing').scrollTop = document.getElementById('listing').scrollHeight - 500;</script>";
		flush(); sleep(1);
	}
?>
		</div>
		<hr size=1>

		<form action="<?=$_SERVER['PHP_SELF'];?>" method="post" name="form">
		Data conversion completed. Next step will delete all old <?=$from_ver?> tables.
		<br /><br />
			<center>
			<INPUT type="hidden" name="op" value="step5">
			<INPUT type="submit" value="Next" class="redbutton">
			</center>
			</form>

<?

	flush();

	break;

    case "step5":
############################
# STEP 5
# - drop old tables
# - display site links
############################

run_sql("DROP TABLE " . $prefix."_tmp_sonad, " . $prefix . "admin, " . $prefix . "admin_grupp, " . $prefix . "admin_osa, " . $prefix . "allowed_mails, " . $prefix . "autor, " . $prefix . "cache, " . $prefix . "config, " . $prefix . "document_parts, " . $prefix . "ext_pp_asutus_grupp, " . $prefix . "ext_pp_dokumendipuu, " . $prefix . "ext_pp_dummy, " . $prefix . "ext_isik, " . $prefix . "ext_komand, " . $prefix . "ext_pp_asutus, " . $prefix . "ext_pp_asutus_xml, " . $prefix . "ext_pp_dok_teg, " . $prefix . "ext_pp_dokument, " . $prefix . "ext_pp_service, " . $prefix . "ext_pp_teabenoue, " . $prefix . "ext_pp_teema, " . $prefix . "ext_yksus, " . $prefix . "fail, " . $prefix . "fail_keyword, " . $prefix . "fail_tyyp, " . $prefix . "gallup_ip, " . $prefix . "gallup_vastus, " . $prefix . "grupp, " . $prefix . "grupp_admin_osa, " . $prefix . "grupp_objekt, " . $prefix . "ip_filter, " . $prefix . "kasutaja, " . $prefix . "kasutaja_kgrupp, " . $prefix . "kasutaja_sso, " . $prefix . "kasutaja_uudised, " . $prefix . "keel, " . $prefix . "kgrupp, " . $prefix . "lang_mapping, " . $prefix . "ldap_map, " . $prefix . "ldap_servers, " . $prefix . "license, " . $prefix . "logi, " . $prefix . "metadata, " . $prefix . "metadata_tyyp, " . $prefix . "moodulid, " . $prefix . "notifications, " . $prefix . "obj_artikkel, " . $prefix . "obj_asset, " . $prefix . "obj_dokument, " . $prefix . "obj_event, " . $prefix . "obj_gallup, " . $prefix . "obj_kommentaar, " . $prefix . "obj_link, " . $prefix . "obj_pilt, " . $prefix . "obj_rubriik, " . $prefix . "object_profiles, " . $prefix . "objekt, " . $prefix . "objekt_kgrupp, " . $prefix . "objekt_objekt, " . $prefix . "product, " . $prefix . "product_category, " . $prefix . "product_category_description, " . $prefix . "product_description, " . $prefix . "product_manufacturer, " . $prefix . "product_profiles, " . $prefix . "replicator, " . $prefix . "shop_cart, " . $prefix . "shop_order, " . $prefix . "spam, " . $prefix . "sso, " . $prefix . "stat_agents, " . $prefix . "stat_domains, " . $prefix . "stat_logs, " . $prefix . "stat_summary, " . $prefix . "stat_visitors, " . $prefix . "stats_objects, " . $prefix . "styles, " . $prefix . "sys_sona_tyyp, " . $prefix . "sys_sonad, " . $prefix . "sys_sonad_kirjeldus, " . $prefix . "tbl, " . $prefix . "templ_tyyp, " . $prefix . "tyyp, " . $prefix . "version, " . $prefix . "xdb, " . $prefix . "xml, " . $prefix . "xml_dtd, " . $prefix . "xml_map", 1);

?>
	</div>
	<br />
	<hr size=1>

		<form action="<?=$_SERVER['PHP_SELF'];?>" method="post" name="form">
		Database conversion finished. Next step is optional and will provide encoding conversion options.
		<br /><br />
			<center>
			<INPUT type="hidden" name="op" value="step6">
			<INPUT type="submit" value="Next" class="redbutton">
			</center>
			</form>

		<form action="<?=$_SERVER['PHP_SELF'];?>" method="post" name="form">
			<center>
			<INPUT type="hidden" name="op" value="step7">
			<INPUT type="hidden" name="action" value="skip">
			<INPUT type="submit" value="Skip" class="redbutton">
			</center>
			</form>
<br /><br />

<?	break;
	case "step6":

############################
# STEP 6
# - ask encoding conversion settings
############################

$languages = array();
$sql = 'select nimi, keel_id, encoding from keel where on_kasutusel = 1 order by nimi;';
$result = new SQL($sql);
while ($row = $result->fetch('ASSOC')) { 
	$languages[] = $row; 
}
$language_id = (int)$site->fdat['language'];

$enc_arr = array( 
 "ISO-8859-1",
 "ISO-8859-2",
 "ISO-8859-3",
 "ISO-8859-4",
 "ISO-8859-5",
 "ISO-8859-6",
 "ISO-8859-6-e",
 "ISO-8859-6-i",
 "ISO-8859-7",
 "ISO-8859-8",
 "ISO-8859-8-e",
 "ISO-8859-8-i",
 "ISO-8859-9",
 "ISO-8859-10",
 "ISO-8859-13",
 "ISO-8859-14",
 "ISO-8859-15",
 "UTF-8",
 "ISO-2022-JP",
 "EUC-JP",
 "Shift_JIS",
 "GB2312",
 "Big5",
 "EUC-KR",
 "windows-1250",
 "windows-1251",
 "windows-1252",
 "windows-1253",
 "windows-1254",
 "windows-1255",
 "windows-1256",
 "windows-1257",
 "windows-1258",
 "KOI8-R",
 "KOI8-U",
 "cp866",
 "cp874",
 "TIS-620",
 "VISCII",
 "VPS",
 "TCVN-5712");	

$ext_array = array();

$sql = "SHOW TABLES LIKE 'ext_pp_%'";
$result = new SQL($sql);
while ($row = $result->fetchsingle()) {
  $ext_array[] = $row; 
}
	?>
	<form action="<?=$_SERVER['PHP_SELF'];?>" method="post" name="form">

	<h1>Introduction</h1>
	<br />
	This script converts all content objects in one language from one character encoding to another.
	<br />
	<br />

	<table border=0 width="100%">
	<tr><td colspan=2><b>Settings</b></td></tr>

	<?############# function?>
	<tr>
	<td valign="top">PHP functions to use:</td>
	<td nowrap>
	<input type="radio" name="convert_function" id="mbstring" value="mbstring" checked><label for="mbstring"><b>mbstring</b></label>
(PHP must be compiled with '--enable-mbstring')
	<br />
	<?if(!function_exists("mb_convert_encoding"))	{
		print "<font color=red><b>Function mb_convert_encoding() not found!</b></font><br />";
	}?>
	<input type="radio" name="convert_function" id="iconv" value="iconv"><label for="iconv"><b>iconv</b></label>
(PHP must be compiled with '--with-iconv')
	<br />
	<?if(!function_exists("iconv"))	{
		print "<font color=red><b>Function iconv() not found!</b></font><br />";
	}?>
	</td>
	</tr>

	<?############# language?>
	<tr>
	<td>Language/Option to convert:</td>
	<td>
	<select name="language" class="select" onchange="if (this.options[this.selectedIndex].value == 'ADR') { document.getElementById('adr_options').style.display = ''; } else { document.getElementById('adr_options').style.display = 'none'; }">
	<option value="ALL" selected>All</option>
	<? foreach ($languages as $language) { ?>
		<option value="<?=$language['keel_id'];?>"><?=$language['nimi'].' ('.$language['encoding'].')';?></option>
	<? 
		if ($language['keel_id'] == $language_id) {
			$selected_enc = $language['encoding'];
		}
	} 
	?>
		<option value="ADR">ADR module conversion</option>
		<option value="FIXSYMBOLS">Fix non-standard symbols</option>
	</select>
	</td>
	</tr>

	<tr id="adr_options" style="vertical-align: top; display: none;">
  	<td>
      ADR tables to convert:
    </td>
  	<td>
      <? if (in_array('ext_pp_asutus', $ext_array)) { ?>
      <label>
        <input type="checkbox" name="adr_table[]" value="ext_pp_asutus" checked="checked"> ext_pp_asutus
      </label>
      <br>
      <? } ?>
      <? if (in_array('ext_pp_asutus_grupp', $ext_array)) { ?>      
      <label>
        <input type="checkbox" name="adr_table[]" value="ext_pp_asutus_grupp" checked="checked"> ext_pp_asutus_grupp
      </label>
      <br>
      <? } ?>
      <? if (in_array('ext_pp_asutus_xml', $ext_array)) { ?> 
      <label>
        <input type="checkbox" name="adr_table[]" value="ext_pp_asutus_xml" checked="checked"> ext_pp_asutus_xml
      </label>
      <br>
      <? } ?>
      <? if (in_array('ext_pp_dummy', $ext_array)) { ?> 
      <label>
        <input type="checkbox" name="adr_table[]" value="ext_pp_dummy" checked="checked"> ext_pp_dummy
      </label>
      <br>
      <? } ?>
      <? if (in_array('ext_pp_service', $ext_array)) { ?> 
      <label>
        <input type="checkbox" name="adr_table[]" value="ext_pp_service" checked="checked"> ext_pp_service
      </label>
      <br>
      <? } ?>
      <? if (in_array('ext_pp_teabenoue', $ext_array)) { ?> 
      <label>
        <input type="checkbox" name="adr_table[]" value="ext_pp_teabenoue" checked="checked"> ext_pp_teabenoue
      </label>
      <br>
      <? } ?>
      <? if (in_array('ext_pp_teema', $ext_array)) { ?> 
      <label>
        <input type="checkbox" name="adr_table[]" value="ext_pp_teema" checked="checked"> ext_pp_teema
      </label>
      <br>
      <? } ?>
      <? if (in_array('ext_pp_dok_teg', $ext_array)) { ?> 
      <label>
        <input type="checkbox" name="adr_table[]" value="ext_pp_dok_teg" checked="checked"> ext_pp_dok_teg
      </label>
      <br>
      <? } ?>
      <? if (in_array('ext_pp_dokumendipuu', $ext_array)) { ?> 
      <label>
        <input type="checkbox" name="adr_table[]" value="ext_pp_dokumendipuu" checked="checked"> ext_pp_dokumendipuu
      </label>
      <br>
      <? } ?>
      <? if (in_array('ext_pp_dokument', $ext_array)) { ?> 
      <label>
        <input type="checkbox" name="adr_table[]" value="ext_pp_dokument" checked="checked"> ext_pp_dokument
      </label>
      <? } ?> 
  	</td>
	</tr>

	<?############# from => to encoding?>
	<tr>
	<td>Convert encoding:</td>
	<td>
	from
	<select name="from_encoding" class="select">
	<? foreach ($languages as $language) { ?>
		<option value="<?=$language['encoding'];?>"  <?=($language['encoding'] == $selected_enc ? "selected" : "")?>><?=$language['encoding'];?></option>
	<? } ?>

	</select>
	to
	<select name="to_encoding" class="select">
	<? foreach ($enc_arr as $enc) {?>
			<option value="<?=$enc?>" <?=($enc == $default_to_encoding ? "selected" : "")?>><?=$enc?></option>
	<?}?>
	</select>
	</td>
	</tr>

	</table>
	<br />
	<br />
	<b><font color="red">NB! Next step will modify your website data! Be sure you have backed up your database before clicking Next button.</font></b>
	<br />
	<br />
			<center>
			<INPUT type="hidden" name="op" value="step7">
			<INPUT type="submit" value="Next" class="redbutton">
			</center>
	</form>

	<?############ system info ?>
	<b>System info</b><br />
	<ul>
	<li>max_execution_time = <b><?=ini_get('max_execution_time')?></b> sec</li>
	<li>memory_limit = <b><?=ini_get('memory_limit')?></b></li>		
	</ul>

	Depending on your website data amount you may need to increase these PHP settings in .htaccess file.
		
	<br />

<?


	break;

	case "step7":
############################
# STEP 7
# - convert encoding
############################

	if ($_POST['action'] == "skip") {
		// do nothing
	} else {
		if ($_POST['language'] == "ALL") {
			$obj_count = convert_adr($_POST['adr_table']);
			$obj_count += convert_language();
			if ($_POST['to_encoding'] == "UTF-8") {
				$obj_count += fix_word_symbols();
				######## zh
				fix_susisev(chr(194).chr(158),chr(197).chr(190));
				######### ZH => Ž
				fix_susisev(chr(194).chr(142),chr(197).chr(189));
				######### sh => ?
				fix_susisev(chr(194).chr(154),chr(197).chr(161));
				######### SH => Š
				fix_susisev(chr(194).chr(138),chr(197).chr(160));
			}
		} elseif ($_POST['language'] == "ADR") {
			$obj_count = convert_adr($_POST['adr_table']);
		} elseif ($_POST['language'] == "FIXSYMBOLS") {

			$obj_count = fix_word_symbols();

			######## zh
			fix_susisev(chr(194).chr(158),chr(197).chr(190));
			######### ZH => Ž
			fix_susisev(chr(194).chr(142),chr(197).chr(189));
			######### sh => ?
			fix_susisev(chr(194).chr(154),chr(197).chr(161));
			######### SH => Š
			fix_susisev(chr(194).chr(138),chr(197).chr(160));

		} else {
			$obj_count = convert_language($_POST["language"]);
		}

	?>
			<br />
			<br />
			Data conversion completed. <b><?=$obj_count?><b> content objects modified.
			<br /><br />
	<?
	}
	?>
		</div>
		<a href="index.php">Go to your site</a>
		<br />
		<a href="editor/index.php">Edit your site</a>
		<br />
		<a href="admin/index.php">Admin your site</a>
		<br />

<?	

	default:

	# do nothing
}

/**************************
END HTML
***************************/
?>

	</font>

</blockquote></blockquote></blockquote></blockquote></blockquote>
<br /><br /><br />
</body>
</html>
<?

function run_sql_file($file) {
	$file = $filename = "admin/updates/" . $file;

	if (file_exists($file)) {
		if ($fd = fopen($file, "r")) {
			$sql = fread ($fd, filesize($file));
			fclose ($fd);
		} 
		else {
			echo "<font color=red>Can't open data file \"<b>" . $filename . "</b>\" - access denied</font><br />";
			$error = 1;
		}
	} else {
		echo "<font color=red>Can't open data file \"<b>" . $filename . "</b>\" - not found</font><br />";
		$error = 1;
	}

	############
	# if there is smth in file
	if ($sql) {

		$pieces = split_sql_file2($sql, ';');

		// now $sql is an array of all sql directives to launch
		$i = 1;
	
		echo "Running SQL file '" . $file . "'...<br>";
		echo "<script>document.getElementById('listing').scrollTop = document.getElementById('listing').scrollHeight - 500;</script>";
		flush(); usleep(500000);
	
		foreach ($pieces as $query)	{

				if ($i%1000 == 0 || $i == 1) {
					flush(); usleep(500000);
					$tbl_is_begun = 1;
				}

			
			$sth = new SQL($query);
			if ($sth->error) {
				print "<font color=red>Error: " . $sth->error . "</font><br>";
				$error = 1;
			}

			$i++;
		}

	} # if sql
}

function run_version_updates() {
	global $versions, $current_version, $to_ver;

	$default_data_files = array();

	$i = 1;
	foreach ($versions as $version_array_index => $tmpver) {
		$next = $versions[$version_array_index + 1];
		# if not current version yet, go to next ver
		# jooksev ver <= installitav ver
		
		###### quick hack for string comparison
		$tmpver_tmp = $tmpver;
		if (strnatcmp($current_ver, $tmpver_tmp) <= 0) {
			array_push($default_data_files, "admin/updates/update" . $tmpver . "to" . $next . ".sql");
		}
		$i++;
	} # foreach
	# remove last element if not repairing/overinstalling same version
	if (strnatcmp($current_ver, $to_ver) != 0) {
		array_pop($default_data_files);
	}

	echo "<font color=red></font><br />";

	foreach ($default_data_files as $file) {
		$filename = $file;

		if ($file == "admin/updates/update4.5.8to4.6.0.sql") {
			run_sql("alter table obj_folder drop relative_path;", 1);
		}

		if (file_exists($file)) {
			if ($fd = fopen($file, "r")) {
				$sql = fread ($fd, filesize($file));
				fclose ($fd);
			} else {
				echo "<font color=red>Can't open data file \"<b>".$filename."</b>\" - access denied</font><br />";
				$error = 1;
			}
		} else {
			echo "<font color=red>Can't open data file \"<b>".$filename."</b>\" - not found</font><br />";
			$error = 1;
		}

		############
		# if there is smth in file
		if ($sql) {

			$pieces = split_sql_file2($sql, ';');

			// now $sql is an array of all sql directives to launch
			$i = 1;
		
			echo "Running SQL file '" . $file . "'...<br>";
			echo "<script>document.getElementById('listing').scrollTop = document.getElementById('listing').scrollHeight - 500;</script>";
			flush(); usleep(500000);
		
			foreach ($pieces as $query)	{

					if ($i%100 == 0 || $i == 1) {
						flush(); usleep(500000);
						$tbl_is_begun = 1;
					}

				
				$sth = new SQL($query);
				if ($sth->error) {
					print "<font color=red>Error: " . $sth->error . "</font><br>";
					$error = 1;
				}

				$i++;
			}

		} # if sql

		#################
		# find php-script file name and run it
			$script_filename = substr($filename, 0, -4) . ".php";
			$error = run_scriptfile2($script_filename);
		flush(); sleep(1);
	} # foreach

	return $error;
}

/**
* FUNCTION run_dumpfile2
* Run database dump file with sql querys
* 
* @param -
* @return string Return error string
*/
function run_dumpfile2($replaceLines = true) {
	global $CONF, $conn;
	global $prefix;
	$pieces = array();

	$read = 16777216; #Read 16meg chunks

/*debug only
		## include memory functions
		include('memory.inc.php');
		## start MEMORY watch:
		# amount of memory, in bytes, that's currently being allocated to this PHP script.
		$start_amount = memory_get_usage();
		$amounts['START'] = calc_memory($start_amount);
*/

	# if dump-file is given, upload it

	$uploadfile = $_FILES["data_file"];

	#printr($uploadfile);
	
	# if dump-file was given, upload it
	if ($uploadfile["name"] != '') {
		$uploadfile = $_FILES["data_file"];
		$file = $uploadfile["tmp_name"];
		$filename = $uploadfile["name"]; 
	}
	# if filename with path was given
	else {
		$file = $_POST["data_file_path"];
		$filename = $_POST["data_file_path"];
	}
		if (file_exists($file)) {
			if ($fd = fopen($file, "r")) {
				#old $sql = fread ($fd, filesize($file));

				echo "Running SQL queries: ";

				# file read marker
				$part = 0;

				######## loop over lines 
				while (!feof($fd)) {

					############## read 16 MB 
					$rbuf = fread($fd, $read);
					for ($i = $read; $i > 0 || $n == chr(10); $i--) {
						$n = substr($rbuf, $i, 1);
						if ($n == chr(10)) {
							break;
						} elseif(feof($fd)) { 
						//If we are at the end of the file, just grab the rest and stop loop
							$i = $read;
							$buf = substr($rbuf, 0, $i + 1);
							break;
						}
					}
					//This is the buffer we want to do stuff with, maybe thow to a function?
					$buf = substr($rbuf, 0, $i + 1);

	#debug:				$amounts['buff'][] = calc_memory($start_amount);

					########### find SQL queries
					$pieces = split_sql_file2($buf, ';');
					
					// now $sql is an array of all sql directives to launch
					$i = 1;
					########### loop over SQL-s
					foreach ($pieces as $query)	{
						
						if ($replaceLines) {
							$query = str_replace("`", "", $query); # remove backticks
							## add table prefix
							$query = str_replace("CREATE TABLE ", "CREATE TABLE " . $prefix, $query);
							$query = str_replace("INSERT INTO ", "INSERT INTO " . $prefix, $query);
							## avoid deleting/modifying ver4 tables:
							$query = str_replace("DROP TABLE IF EXISTS ", "DROP TABLE IF EXISTS " . $prefix, $query);
							$query = str_replace("ALTER TABLE ", "ALTER TABLE " . $prefix, $query);
							$query = str_replace("LOCK TABLES ", "LOCK TABLES " . $prefix, $query);
							#echo("$query<br />");
						}

						$sth = new SQL($query);
						if ($sth->error) {
							print "<font color=red>Error: " . $sth->error."</font><br />";
						}
						$i++;
						if (($i % 100) == 0) {
	#debug						$amounts["SQL $i"] = calc_memory($start_amount);
							echo $i . "...<br>";
							#echo $amounts["SQL $i"]." <br/>";
							flush();

						}

					}# foreach sql
					########### / loop over SQL-s


					//Point marker back to last \n point
					$part = ftell($fd) - ($read - ($i + 1));
					fseek($fd, $part);
					sleep(2);

				}# if eof

				fclose ($fd);
				echo "<br />";
			} else {
				$error = "Can't open data file \"<b>" . $filename . "</b>\" - access denied";
			}
		} else {
			$error = "Can't open data file \"<b>" . $filename . "</b>\" - not found";
		} # open file

	flush();
#printr($amounts);
	return $error;
}
/**
* FUNCTION split_sql_file2
* Translate a multiple query separated by ; to single queries
* 
* @param string $sql
* @param string $delimiter
* @return array Array of SQL sentences
*/
function split_sql_file2($sql, $delimiter){
    $sql               = trim($sql);
    $char              = '';
    $last_char         = '';
    $ret               = array();
    $string_start      = '';
    $in_string         = FALSE;
    $escaped_backslash = FALSE;

#	$ret = split("\s*;[\n\r]",$sql);

    for ($i = 0; $i < strlen($sql); ++$i) {
        $char = $sql[$i];

        // if delimiter found, add the parsed part to the returned array
        if ($char == $delimiter && !$in_string) {
            $ret[]     = substr($sql, 0, $i);
            $sql       = substr($sql, $i + 1);
            $i         = 0;
            $last_char = '';
        }

        if ($in_string) {
            // We are in a string, first check for escaped backslashes
            if ($char == '\\') {
                if ($last_char != '\\') {
                    $escaped_backslash = FALSE;
                } else {
                    $escaped_backslash = !$escaped_backslash;
                }
            }
            // then check for not escaped end of strings
            if (($char == $string_start)
                && !(($last_char == '\\') && !$escaped_backslash)) {
                $in_string    = FALSE;
                $string_start = '';
            }
        } else {
            // we are not in a string, check for start of strings
            if (($char == '"') || ($char == '\'') || ($char == '`')) {
                $in_string    = TRUE;
                $string_start = $char;
            }
        }
        $last_char = $char;
    } // end for

    // add any rest to the returned array
    if (!empty($sql)) {
        $ret[] = $sql;
    }
    return $ret;
}
/**
* FUNCTION run_scriptfile2
* Run php-script file
* 
* @param string $file Absolute path of filename
* @return -
*/
function run_scriptfile2($file) {
	if (file_exists($file)) {
		echo "Running PHP script file '" . $file . "'...<br>";
		echo "<script>document.getElementById('listing').scrollTop = document.getElementById('listing').scrollHeight - 500;</script>";
		flush(); usleep(500000);

		include_once($file);
	}
	return;
}
/**
* FUNCTION copy_table
* 
* 
* @param string $from Source table name
* @param string $to Target table name
* @return -
*/
function copy_table($from,$to) {
	global $conn, $CONF;

	$sql = "insert into " . $to . " select * from " . $from;
	$sth = new SQL($sql);
	print $sql . " (<b>" . $sth->rows . "</b>)<br />";
	if ($sth->error) {
		print "<font color=red>Error: " . $sth->error . "</font><br />";
	}
	flush();
}

/**
* FUNCTION delete_table
* 
* 
* @param string $tbl - Table name
* @return -
*/
function delete_table($tbl) {
	global $conn, $CONF;

	$sql = "delete from " . $tbl;
	$sth = new SQL($sql);
	print $sql . "<br />";
	if ($sth->error) {
		print "<font color=red>Error: " . $sth->error . "</font><br />";
	}
	flush();
}

/**
* FUNCTION run_sql
* 
* 
* @param string $sql SQL
* @param string $silent Run silently - dont display errors
* @return -
*/
function run_sql($sql, $silent) {
	global $conn, $CONF;

	$sth = new SQL2($sql);
	print htmlspecialchars($sql) . " (<b>" . $sth->rows . "</b>)<br />";
	if ($sth->error && !$silent) {
		print "<font color=red>Error: " . $sth->error . "</font><br />";
	}
	flush();
	if ($sth->insert_id) {
		return $sth->insert_id;
	}
}
/**
* FUNCTION readconfdb2
* It's copy-paste from classes/site.class.php (except 1 line, see below) 
* 
* @param -
* @return array $conf Array of configuration variables
*/
function readconfdb2() {

// NB! exception in copy-paste: this 1 line must be added
	global $conn;
	$sql = "SELECT nimi,sisu FROM config";
	$sth = new SQL2($sql);
	if ($sth->error) {
		print "<font color=red>Error: " . $sth->error . "</font>";
		return false;
	}
	while ($conf_rida = $sth->fetch()) {
		$conf[$conf_rida['nimi']] = $conf_rida['sisu'];
	}
	return $conf;
}
/**
* FUNCTION Readver3ConfDB
* It's copy-paste from classes/site.class.php (except 1 line, see below) 
* 
* @param -
* @return array $conf Array of configuration variables
*/
function Readver3ConfDB() {
// NB! exception in copy-paste: this 1 line must be added
	global $conn, $prefix;
	$sql = "SELECT nimi,sisu FROM " . $prefix . "config";
	$sth = new SQL2($sql);
	if ($sth->error) {
		print "<font color=red>Error: " . $sth->error . "</font>";
		return false;
	}
	while ($conf_rida = $sth->fetch()) {
		$conf[$conf_rida['nimi']] = $conf_rida['sisu'];
	}
	return $conf;
}

/**
* FUNCTION current_version
* Returns currently installed Saurus CMS version number.
* 
* @param -
* @return string $cms_version CMS version number
*/
function current_version_ver4() {
	global $conn, $CONF;

	$sql = "SELECT version_nr FROM version ORDER BY release_date DESC LIMIT 1";
	$sth = new SQL2($sql);
	if ($sth->error) {
		return false;
	}
	$cms_version = $sth->fetchsingle();
	return $cms_version;
}
/**
* FUNCTION current_version
* Returns ver3 Saurus CMS version number.
* 
* @param -
* @return string $cms_version CMS version number
*/
function current_version_ver3() {
	global $conn, $CONF, $prefix;

	$sql = "SELECT version_nr FROM " . $prefix . "version ORDER BY release_date DESC LIMIT 1";
	$sth = new SQL2($sql);
	if ($sth->error) {
		return false;
	}
	$cms_version = $sth->fetchsingle();
	return $cms_version;
}
/**
* FUNCTION copy_folder
* Copy source folder content to the target folder
* 
* @param string $source_folder Absolute path of the source folder
* @param string $target_folder Absolute path of the target folder
* @return boolean Returns TRUE on success or FALSE on failure.
*/
function copy_folder($args) {
	$source_folder = $args['source_folder'];
	$target_folder = $args['target_folder'];

	$copy_ok = true; # return value

	# check if given source folder exists

	if (!file_exists($source_folder)) {
		echo "<font color=red>ERROR: Folder \"" . $source_folder . "\" not found!</font><br />";
		return false;
	}

	# check if target folder is writable
	if (!is_writable($target_folder)) {
		echo "<font color=red>ERROR: Folder \"" . $target_folder . "\" is not writable!</font><br />";
		return false;
	}

	# copy files
	if ($dir = opendir($source_folder)) {
		while (($file = readdir($dir)) !== false) {
			if ($file != '.' && $file != '..' && $file != '.htaccess') {
				# is it folder?
				if (is_dir($source_folder . $file)) {
					$old_mask = umask(0);
					$dir_ok = mkdir($target_folder . '/' . $file, 0777);
					umask($old_mask);

					### recursive step into folder:
					$copy_ok = copy_folder(array(
						'source_folder' => $source_folder . $file . '/',
						'target_folder' => $target_folder . '/' . $file . '/'
					));
					continue;
				}
				# it's file:
				if (!copy($source_folder . $file, $target_folder . '/' . $file)) {
					echo "<font color=red>ERROR: Failed to copy file \"" . $file . "\"<br />";
					$copy_ok = false;
				}
			} # if file
		} #while		
	} # opendir
	return $copy_ok;
}
/**
* FUNCTION check_deprecated_sapi_tags
* Copy source folder content to the target folder
* 
* @param string $target_folder Absolute path of the target folder
* @return boolean Returns TRUE on success or FALSE on failure.
*/
function check_deprecated_sapi_tags($args){
	
	$target_folder = $args['target_folder'];

	$check_ok = true; # return value

	$search_string1 = '{print_header}';
	$search_string2 = '{print_footer}'; 
	$search_string3 = '{print_box}'; 

	$errors = array();

	if ($dir = opendir($target_folder)) {
		while (($file = readdir($dir)) !== false) {
			if ($file != '.' && $file != '..' && $file != '.htaccess') {
				# is it file?
				$file_path = $target_folder . '/' . $file;
				if (is_file($file_path)) {

					if ($fp = fopen($file_path, 'r')) {

						while (!feof ($fp)) {
							$data .= fgets($fp, 4096);
						}
						## FOUND:
						$match = "";
						if (preg_match('/{init_search_results(.*)}/', $data, $match)) {

							if (strpos($match[0], 'amount_of_pages') !== false)
								$errors[] = 'Warning: the parameter "amount_of_pages" is in no longer available in {init_search_results} tag! Found in template "<b>' . $file . '</b>"';
							if (strpos($match[0], 'pagenum_separator') !== false)
								$errors[] = 'Warning: the parameter "pagenum_separator" is in no longer available in {init_search_results} tag! Found in template "<b>' . $file . '</b>"';
							if (strpos($match[0], 'pagenum_next_chr') !== false)
								$errors[] = 'Warning: the parameter "pagenum_next_chr" is in no longer available in {init_search_results} tag! Found in template "<b>' . $file . '</b>"';
							if (strpos($match[0], 'pagenum_prev_chr') !== false)
								$errors[] = 'Warning: the parameter "pagenum_prev_chr" is in no longer available in {init_search_results} tag! Found in template "<b>' . $file . '</b>"';
							if (strpos($match[0], 'pagenum_link_class') !== false)
								$errors[] = 'Warning: the parameter "pagenum_link_class" is in no longer available in {init_search_results} tag! Found in template "<b>' . $file . '</b>"';
							if (strpos($match[0], 'pagenum_numbers_style') !== false)
								$errors[] = 'Warning: the parameter "pagenum_numbers_style" is in no longer available in {init_search_results} tag! Found in template "<b>' . $file . '</b>"';
							if (strpos($match[0], 'page_seq') !== false)
								$errors[] = 'Warning: the parameter "page_seq" is in no longer available in {init_search_results} tag! Found in template "<b>' . $file . '</b>"';
							$check_ok = false;
						}
						if(preg_match("/position(\s*)=(\s*)(\"|'?)(\s*)([\d,]*)(?<=(\s|,|=|\"|'))[9|5]{1}(?!(\d))/", $data))
						{
							$errors[] = 'Warning: Found Saurus API code with position=9 or position=5 in template "<b>' . $file . '</b>".';
							$check_ok = false;
						}
						if (stristr($data, $search_string1) || stristr($data, $search_string2) || stristr($data, $search_string3)) {

							### gather warnings
							$errors[] = 'Warning: Deprecated Saurus API tag <b>{print_header}</b> or <b>{print_footer}</b> or <b>{print_box}</b> found in template "<b>' . $file . '</b>"';		
							$check_ok = false;
						}

						fclose($fp);	

					} # fopen OK

				} # if file
			} # if not ./../.htaccess
		} #while		
	} # opendir
	print(join("<br />", $errors));

	return $check_ok;
}

/**
* FUNCTION update_old_structure
* Upgrade all old source tables structure, must be identical with new tables
* 
* @param -
* @return -
*/
function update_old_structure(){
	global $prefix;	

	######## PROFILES
	run_sql("ALTER TABLE " . $prefix . "object_profiles MODIFY COLUMN source_table VARCHAR(50) DEFAULT NULL;", 1);
	run_sql("ALTER TABLE " . $prefix . "object_profiles ADD COLUMN is_predefined CHAR(1) DEFAULT NULL;", 1);
	run_sql("ALTER TABLE " . $prefix . "object_profiles ADD COLUMN is_default TINYINT(1) UNSIGNED NOT NULL DEFAULT '0';", 1);
	run_sql("ALTER TABLE " . $prefix . "obj_dokument ADD COLUMN profile_id INTEGER(4) UNSIGNED NOT NULL DEFAULT '0';", 1);

	######### OBJEKT
#	run_sql("ALTER TABLE " . $prefix . "objekt MODIFY COLUMN last_modified INTEGER(11) UNSIGNED DEFAULT NULL;", 1);
	run_sql("ALTER TABLE " . $prefix . "objekt MODIFY COLUMN related_objekt_id BIGINT(11) UNSIGNED NOT NULL DEFAULT '0';", 1);
	run_sql("ALTER TABLE " . $prefix . "objekt ADD COLUMN created_user_id BIGINT(20) UNSIGNED NOT NULL DEFAULT '0';", 1);
	run_sql("ALTER TABLE " . $prefix . "objekt ADD COLUMN created_user_name VARCHAR(255) NOT NULL;", 1);
	run_sql("ALTER TABLE " . $prefix . "objekt ADD COLUMN changed_user_id BIGINT(20) UNSIGNED NOT NULL DEFAULT '0';", 1);
	run_sql("ALTER TABLE " . $prefix . "objekt ADD COLUMN changed_user_name VARCHAR(255) NOT NULL;", 1);
	run_sql("ALTER TABLE " . $prefix . "objekt ADD COLUMN created_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00';", 1);
	run_sql("ALTER TABLE " . $prefix . "objekt ADD COLUMN changed_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00';", 1);
	run_sql("ALTER TABLE " . $prefix . "objekt ADD COLUMN last_commented_time DATETIME DEFAULT NULL;", 1);
	run_sql("ALTER TABLE " . $prefix . "objekt ADD COLUMN comment_count INTEGER(10) UNSIGNED DEFAULT NULL;", 1);

	######### GALLUP
	run_sql("ALTER TABLE " . $prefix . "gallup_ip CHANGE kasutaja_id user_id BIGINT(20) NOT NULL DEFAULT '0';", 1);
	run_sql("ALTER TABLE " . $prefix . "gallup_ip ADD COLUMN vote_time DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00';", 1);
	run_sql("ALTER TABLE " . $prefix . "gallup_ip ADD COLUMN gv_id BIGINT(21) UNSIGNED NOT NULL DEFAULT '0';", 1);
	run_sql("ALTER TABLE " . $prefix . "obj_gallup ADD COLUMN expires DATE DEFAULT NULL;", 1);
	run_sql("ALTER TABLE " . $prefix . "obj_gallup ADD COLUMN is_anonymous TINYINT(1) UNSIGNED NOT NULL DEFAULT '0';", 1);

	######### EVENT
	run_sql("ALTER TABLE " . $prefix . "obj_event ADD COLUMN whole_day TINYINT(1) UNSIGNED DEFAULT '0';", 1);
	run_sql("ALTER TABLE " . $prefix . "obj_event ADD COLUMN parent_id BIGINT(20) UNSIGNED DEFAULT NULL;", 1);
	run_sql("ALTER TABLE " . $prefix . "obj_event ADD COLUMN recure_days INTEGER(3) UNSIGNED DEFAULT NULL;", 1);
	run_sql("ALTER TABLE " . $prefix . "obj_event ADD COLUMN recure_week VARCHAR(7) DEFAULT NULL;", 1);
	run_sql("ALTER TABLE " . $prefix . "obj_event ADD COLUMN recure_weeks INTEGER(2) UNSIGNED DEFAULT NULL;", 1);
	run_sql("ALTER TABLE " . $prefix . "obj_event ADD COLUMN recure_month INTEGER(2) UNSIGNED DEFAULT NULL;", 1);
	run_sql("ALTER TABLE " . $prefix . "obj_event ADD COLUMN recure_months INTEGER(2) UNSIGNED DEFAULT NULL;", 1);
	run_sql("ALTER TABLE " . $prefix . "obj_event ADD COLUMN recure_year VARCHAR(4) DEFAULT NULL;", 1);
	run_sql("ALTER TABLE " . $prefix . "obj_event ADD COLUMN recure_start DATE DEFAULT NULL;", 1);
	run_sql("ALTER TABLE " . $prefix . "obj_event ADD COLUMN recure_end DATE DEFAULT NULL;", 1);
	run_sql("ALTER TABLE " . $prefix . "obj_event ADD COLUMN recure_times INTEGER(4) UNSIGNED DEFAULT NULL;", 1);
	run_sql("ALTER TABLE " . $prefix . "obj_event ADD COLUMN location VARCHAR(255) DEFAULT NULL;", 1);
	run_sql("ALTER TABLE " . $prefix . "obj_event ADD COLUMN is_private TINYINT(1) UNSIGNED DEFAULT '0';", 1);
	run_sql("ALTER TABLE " . $prefix . "obj_event ADD COLUMN profile_id INTEGER(4) UNSIGNED NOT NULL DEFAULT '0';", 1);
	run_sql("ALTER TABLE " . $prefix . "obj_event ADD COLUMN tracking_start_time DATETIME DEFAULT NULL;", 1);
	run_sql("ALTER TABLE " . $prefix . "obj_event ADD COLUMN tracking_end_time DATETIME DEFAULT NULL;", 1);
	run_sql("ALTER TABLE " . $prefix . "obj_event ADD COLUMN progress VARCHAR(15) DEFAULT NULL;", 1);
	run_sql("ALTER TABLE " . $prefix . "obj_event ADD COLUMN tracking_total_hours BIGINT(6) UNSIGNED DEFAULT NULL;", 1);
	run_sql("ALTER TABLE " . $prefix . "obj_event ADD COLUMN name VARCHAR(255) DEFAULT NULL;", 1);

	######## TEMPLATES
	run_sql("ALTER TABLE " . $prefix . "templ_tyyp MODIFY COLUMN on_auto_avanev TINYINT(1) NOT NULL DEFAULT '1';", 1);
	run_sql("ALTER TABLE " . $prefix . "templ_tyyp MODIFY COLUMN sst_id INTEGER(11) NOT NULL DEFAULT '0';", 1);
	run_sql("ALTER TABLE " . $prefix . "templ_tyyp ADD COLUMN extension VARCHAR(100) DEFAULT NULL;", 1);
	run_sql("ALTER TABLE " . $prefix . "templ_tyyp ADD COLUMN is_readonly TINYINT(1) UNSIGNED NOT NULL DEFAULT '0';", 1);

	######### LOGI
	run_sql("ALTER TABLE " . $prefix . "logi ADD COLUMN objekt_id BIGINT(20) UNSIGNED DEFAULT NULL;", 1);

	######### EXTENIONS
	run_sql("ALTER TABLE " . $prefix . "sys_sona_tyyp ADD COLUMN extension VARCHAR(100) DEFAULT NULL;", 1);
	run_sql("ALTER TABLE " . $prefix . "admin_osa ADD COLUMN extension VARCHAR(100) DEFAULT NULL;", 1);

	######### OTHERS
	run_sql("ALTER TABLE " . $prefix . "xml ADD COLUMN encoding_to VARCHAR(255) DEFAULT NULL;", 1);
	run_sql("ALTER TABLE " . $prefix . "keel ADD COLUMN locale VARCHAR(5) NOT NULL;", 1);

}
/**
* FUNCTION copy_content_objects
* Copy all content object tables + add creation info and other missing info (comment_count, etc)
* Executes SQL for backward compability: all section position values 5 and 9 (default in ver3) is replaced with 0 value (default in ver4).
* 
* @param -
* @return -
*/
function copy_content_objects(){

	global $prefix, $DB, $site;

	delete_table("obj_dokument");
	copy_table($prefix . "obj_dokument", "obj_dokument");

	delete_table("document_parts");
	copy_table($prefix . "document_parts", "document_parts");

	delete_table("obj_event");
	copy_table($prefix . "obj_event", "obj_event");

	delete_table("obj_gallup");
	copy_table($prefix . "obj_gallup", "obj_gallup");

	delete_table("gallup_ip");
	copy_table($prefix . "gallup_ip", "gallup_ip");

	delete_table("gallup_vastus");
	copy_table($prefix . "gallup_vastus", "gallup_vastus");

	delete_table("obj_kommentaar");
	copy_table($prefix . "obj_kommentaar", "obj_kommentaar");

	delete_table("obj_link");
	copy_table($prefix . "obj_link", "obj_link");

	delete_table("obj_pilt");
	copy_table($prefix . "obj_pilt", "obj_pilt");

	delete_table("obj_rubriik");
	copy_table($prefix . "obj_rubriik", "obj_rubriik");

	delete_table("objekt_objekt");
	copy_table($prefix . "objekt_objekt", "objekt_objekt");

	### table may contain unknown number profile fields => use fixed field list
	delete_table("obj_artikkel");
	# use existing ver4 table fields 
	$tbl_fields = $DB->get_fields(array(tabel => "obj_artikkel", 'no_cache' => 1));
	run_sql("INSERT INTO obj_artikkel (" . $tbl_fields . ") SELECT " . $tbl_fields . " FROM " . $prefix . "obj_artikkel;", 1);

	## set default Article profile: 137=Article
	run_sql("UPDATE obj_artikkel SET profile_id='137' WHERE profile_id=0 OR ISNULL(profile_id);", 1);

	### table may contain unknown number profile fields => use fixed field list
	delete_table("obj_asset");
	# use existing ver4 table fields 
	$tbl_fields = $DB->get_fields(array(tabel => "obj_asset", 'no_cache' => 1));
	run_sql("INSERT INTO obj_asset (" . $tbl_fields . ") SELECT " . $tbl_fields . " FROM " . $prefix . "obj_asset;", 1);

	### objekt
	delete_table("objekt");
	run_sql("INSERT INTO objekt (objekt_id, pealkiri, on_pealkiri, tyyp_id, admin_id, author, on_avaldatud, keel, pilt, pilt_aktiivne, banner, kesk, laius, ttyyp_id, pealkiri_strip, sisu_strip, on_foorum, aeg, added_time, meta_keywords, 	meta_title, meta_description, on_kustutatud, count, sys_alias, ttyyp_params, avaldamisaeg_algus, avaldamisaeg_lopp, ext_id, on_saadetud, metadata_tyyp_id, page_ttyyp_id, last_modified, related_objekt_id, metadata_strip, friendly_url, is_hided_in_menu, check_in, check_in_admin_id, 	created_user_id, created_user_name, changed_user_id, changed_user_name, created_time, changed_time, 	last_commented_time, comment_count) SELECT objekt_id, pealkiri, on_pealkiri, tyyp_id, admin_id, author, on_avaldatud, keel, pilt, pilt_aktiivne, banner, kesk, laius, ttyyp_id, pealkiri_strip, sisu_strip, 	on_foorum, aeg, added_time, meta_keywords, meta_title, meta_description, on_kustutatud,	count, sys_alias, ttyyp_params, avaldamisaeg_algus, avaldamisaeg_lopp, ext_id, on_saadetud, metadata_tyyp_id, page_ttyyp_id, last_modified, related_objekt_id, metadata_strip, friendly_url,	is_hided_in_menu, check_in, check_in_admin_id, admin_id, created_user_name, changed_user_id, changed_user_name, created_time, changed_time, 	last_commented_time, comment_count FROM " . $prefix . "objekt;", 1);

	## add creation info for objects:
	run_sql('UPDATE objekt SET created_time = CONCAT(aeg, " ", added_time);', 1);
	run_sql('UPDATE objekt SET changed_time = IF(last_modified, FROM_UNIXTIME(last_modified), "0000-00-00 00:00:00");', 1);

	## generate "objekt.comment_count"
	//$error = run_scriptfile2("admin/updates/update4.0.5to4.0.6.php");
	$sth = new SQL2 ("SELECT objekt_id FROM objekt");
	if ($sth->error) {
		print "<font color=red>Error: " . $sth->error . "</font><br>";
	}

	while ($rec = $sth->fetch()) {
		$objekt_id = $rec['objekt_id'];

		$alamlist_count = new Alamlist2(array(
			parent => $rec['objekt_id'],
			klass	=> "kommentaar",
			asukoht	=> 0,
			on_counter => 1	
		));
		
		$comment_count = $alamlist_count->rows;

		$sql2 = "UPDATE objekt SET comment_count='" . $comment_count . "' WHERE objekt_id='" . $objekt_id . "'";
		$sth2 = new SQL2 ($sql2);
	}

	# Executes SQL for backward compability: all section position values 5 and 9 (default in ver3) is replaced with 0 value (default in ver4).
	run_sql('UPDATE objekt SET kesk=0 WHERE tyyp_id=1 AND (kesk=5 OR kesk=9);', 1);

}
/**
* FUNCTION replace_links
* Replace internal links in the content, eg failid/)
* 
* @param -
* @return -
*/
function replace_links(){

	global $prefix, $DB;

	$ver3CONFDB = Readver3ConfDB();

	# pathide ra asendamine artiklite sisus

	# 1) http://HOSTNAME.WWWROOT/failid => ##saurus649code##
	$from = "http://" . $ver3CONFDB["hostname"] . $ver3CONFDB["wwwroot"] . "/failid";	
	$to = "##saurus649code##";
	run_sql("UPDATE obj_artikkel SET lyhi=replace(lyhi,'$from','$to'), sisu=replace(sisu,'$from','$to')", 1);

	# 2) WWWROOT/failid => ##saurus649code##
	$from = $ver3CONFDB["wwwroot"] . "/failid";
	$to = "##saurus649code##";
	run_sql("UPDATE obj_artikkel SET lyhi=replace(lyhi,'$from','$to'), sisu=replace(sisu,'$from','$to')", 1);


	# - linkide asendus, field obj_link.url:
	$from = "/failid/";	
	$to = "/public/";
	run_sql("UPDATE obj_link SET url=replace(url,'$from','$to')", 1);


#	$to2 = "http://".$CONFDB["hostname"].$CONFDB["wwwroot"]."/public";

}


/**
* FUNCTION copy_identical_tables
* Copy all tables having the same name and structure both in ver3 and ver4
* 
* @param -
* @return -
*/
function copy_identical_tables($tbls) {

	global $prefix;	

	$tbl_arr = split(",", $tbls); # argument is comma separated list of table names

	if (sizeof($tbl_arr)) {
		foreach($tbl_arr as $tbl) {
			$tbl = trim($tbl);
			delete_table($tbl);
			copy_table($prefix.$tbl,$tbl);
		} # foreach
	} # if
}
/**
* FUNCTION copy_css
* Convert styles.php => custom css. Copy-paste from update4.0.14to4.0.15.php
* 
* @param -
* @return -
*/
function copy_css(){

	global $prefix;	
	global $DB;

	# copy-paste from update4.0.14to4.0.15.php

	######### 1. Liiguta Custom CSS tabelist "styles" (deprecated) uude tabelisse "css".

	$sql = "SELECT * FROM styles WHERE nimi='custom_css'";
	$sth = new SQL($sql);
	$style = $sth->fetch();
	$old_custom_css = $style['layout'];


	######### 2. Konverteeri styles.php sisu CSS-i tabelisse Custom css-i lppu.

		$sql = "SELECT * FROM styles";
		$sth = new SQL($sql);

		# Vljad, kus layout vib vrrelda '0', aga stiilitabelis ei pea olema:
		$peidetud = array('show_horisontaal_menu', 'kusmaolen_riba_korgus', 'body_left_margin', 'body_top_margin', 'body_margin_width', 'body_margin_height');

		$params = array('font_family', 'font_size', 'text_decoration', 'font_weight', 'font_style', 'background_color', 'color', 'line_height', 'width, height', 'margin_top', 'margin_right', 'margin_bottom', 'margin_left', 'padding_top', 'padding_right', 'padding_bottom', 'padding_left', 'border_color', 'border_style', 'border_top_width', 'border_right_width', 'border_bottom_width', 'border_left_width');

		while ($style = $sth->fetch()) {

			if ($style['nimi'] == 'custom_css'){
				$custom_css = $style['layout'];
			}
			if ($style['on_toimetajalt'] || $style['nimi'] == 'pealkiri' || $style['nimi'] == 'txt'){
				$is_wysiwyg = true;
			} else { $is_wysiwyg = false; }

			$style['nimi'] = preg_replace("/^a__/i", "A.", $style['nimi']);
			$style['nimi'] = preg_replace("/__/i", ":", $style['nimi']);
			$tmpnimi2=$style['nimi'];
			
			# pane . ette
			if (!preg_match("/\w+\./", $style['nimi'])) {
				$style['nimi'] = '.' . $style['nimi'];
			}		


			if (!$style['layout'] && !in_array($tmpnimi2, $peidetud)) {
				############## WYSIWYG CSS
				if ($is_wysiwyg){

					### muuda stiil "pealkiri" => "h1.pealkiri"
					if ($style['nimi'] == '.pealkiri'){

						$remember_pealkiri =  $style['nimi'] . " { ";
						$remember_pealkirih1 = 'h1' . $style['nimi'] . " { ";
						foreach ($params as $val) {
							$tmp .= ($style[$val] ? preg_replace("/_/", "-", $val) . ": " . $style[$val] . "; " : "");
						}
						$remember_pealkiri .= $tmp. " } \n";
						$remember_pealkirih1 .= $tmp. " } \n";
						
					}
					## default
					else {
						$old_wysiwyg .=  $style['nimi'] . " { ";
						foreach ($params as $val) {
							$old_wysiwyg .=  ($style[$val] ? preg_replace("/_/", "-", $val) . ": " . $style[$val] . "; " : "");
						}
						$old_wysiwyg .=  " } \n";
					} # pealkiri or not
				}

				############ OLD STYLES
				else {
					$old_styles .=  $style['nimi']." { ";
					foreach ($params as $val) {
						$old_styles .= ($style[$val] ? preg_replace("/_/", "-", $val) . ": " . $style[$val] . "; " : "");
					}
					$old_styles .=  " } \n";			
				}
			
			}
		} # while

	############### STYLES IN FIXED TEMPLATES (not in database, just set them free)

	$old_styles .= '
	/* New comment message text input area */
	#scms_comment_add_table TEXTAREA {
		width: 445px;
		height: 100px;
	}';


	################################ TO table "css"

	$sql = "SELECT * FROM css WHERE name='custom_css'";
	$sth = new SQL($sql);
	$css = $sth->fetch();

	########## 1. Styles from version 3
	$all_css = "/***********************************************************\n Styles from version 3:\n adminpages \"Visual Design > Site Styles\", \"Visual Design > Text Styles\"\n***********************************************************/\n\n";
	$all_css .= $old_styles . "\n\n";

	########## 2. WYSIWYG CSS (was included in the end of the old ver3 styles)
	$all_css .= "/************************************************************\n WYSIWYG CSS\n***********************************************************/\n" . $remember_pealkiri . $old_wysiwyg . "\n";


	########### 3. Custom CSS
	$all_css .= "/***********************************************************\n Custom CSS\n***********************************************************/\n" . $old_custom_css;


	### UPDATE
	if($sth->rows){ 
		$sql = $DB->prepare("UPDATE css SET data=?, is_active=? WHERE name=?",
			$all_css,
			1,
			'custom_css'
		);
		run_sql($sql, 1);
	}
	### INSERT
	else {
		$sql = $DB->prepare("INSERT INTO css (name, data, is_active) VALUES(?,?,?)",
			'custom_css',
			$all_css,
			1
		);
		run_sql($sql, 1);
	}

	###################################### WYSIWYG CSS 

	$sql = "SELECT * FROM css WHERE name='wysiwyg_css'";
	$sth = new SQL($sql);
	$css = $sth->fetch();


	### UPDATE
	if($sth->rows){ 
		$sql = $DB->prepare("UPDATE css SET data=?, is_active=? WHERE name=?",
			$remember_pealkirih1 . $old_wysiwyg,
			1,
			'wysiwyg_css'
		);
		run_sql($sql, 1);
	}
	### INSERT
	else {
		$sql = $DB->prepare("INSERT INTO css (name, data, is_active) VALUES(?,?,?)",
			'wysiwyg_css',
			$remember_pealkirih1 . $old_wysiwyg,
			1
		);
		run_sql($sql, 1);
	}


	###################################### WYSIWYG GENERAL

	$sql = "SELECT * FROM css WHERE name='wysiwyg_css_general'";
	$sth = new SQL($sql);
	$css = $sth->fetch();

	$wysiwyg_css_general = "body {
		font-family: Arial, Verdana, Sans-Serif;
		font-size: 12px;
		padding: 5px 5px 5px 5px;
		margin: 0px;
		border-style: none;
		background-color: #ffffff;
	}";

	### UPDATE
	if ($sth->rows) { 
		$sql = $DB->prepare("UPDATE css SET data=?, is_active=? WHERE name=?",
			$wysiwyg_css_general,
			1,
			'wysiwyg_css_general'
		);
		run_sql($sql, 1);
	}
	### INSERT
	else {
		$sql = $DB->prepare("INSERT INTO css (name, data, is_active) VALUES(?,?,?)",
			'wysiwyg_css_general',
			$wysiwyg_css_general,
			1
		);
		run_sql($sql, 1);
	}
}
/**
* FUNCTION copy_templ_tyyp
* Copy ver3 templ_tyyp table and add ver4 changes
* 
* @param -
* @return -
*/
function copy_templ_tyyp(){
	global $prefix;	

	delete_table("templ_tyyp");
	copy_table($prefix . "templ_tyyp", "templ_tyyp");

	run_sql("UPDATE templ_tyyp SET on_konfigureeritav= '1' WHERE ttyyp_id='11';", 1);
	run_sql("DELETE FROM templ_tyyp WHERE ttyyp_id='15';", 1);
	run_sql("DELETE FROM templ_tyyp WHERE ttyyp_id='16';", 1);
	run_sql("DELETE FROM templ_tyyp WHERE ttyyp_id='21';", 1);
	run_sql("DELETE FROM templ_tyyp WHERE ttyyp_id='47';", 1);
	run_sql("DELETE FROM templ_tyyp WHERE ttyyp_id='48';", 1);

	run_sql("UPDATE templ_tyyp SET templ_fail= 'templ_archive.php' WHERE ttyyp_id='29';", 1);
	run_sql("UPDATE templ_tyyp SET templ_fail= 'templ_poll.php' WHERE ttyyp_id='30';", 1);
	run_sql("UPDATE templ_tyyp SET templ_fail= 'templ_pollarchive.php' WHERE ttyyp_id='38';", 1);
	run_sql("UPDATE templ_tyyp SET templ_fail= 'templ_sitemap.php' WHERE ttyyp_id='28';", 1);
	run_sql("UPDATE templ_tyyp SET templ_fail= 'templ_advsearch.php' WHERE ttyyp_id='27';", 1);

#	run_sql("DELETE FROM templ_tyyp WHERE op= 'register';", 1);
#	run_sql("INSERT INTO templ_tyyp (ttyyp_id, op, nimi, templ_fail, kirjeldus, pilt, on_nahtav, on_konfigureeritav, on_auto_avanev, on_aeg, eri_params, on_objekt_only, sst_id, on_page_templ, moodul_id, tbl, smarty_prefilter, smarty_postfilter) VALUES (2010, 'register', 'Registreerimisvorm', 'Registration_Form.html', NULL, NULL, '1', '0', '0', '0', '', '0', 0, '0', 0, NULL, NULL, NULL);", 1);

#duplicate?:
#	run_sql('INSERT INTO templ_tyyp (ttyyp_id, op, nimi, templ_fail, kirjeldus, pilt, on_nahtav, on_konfigureeritav, on_auto_avanev, on_aeg, eri_params, on_objekt_only, sst_id, on_page_templ, moodul_id, tbl, smarty_prefilter, smarty_postfilter) VALUES("2009", "", "ATP_PP_avalik_teenus", "ATP_PP_avalik_teenus.html", NULL, NULL, "1", "0", "0", "0", "", "0", "14", "0", "9", "ext_pp_service", NULL, NULL);', 1);

	run_sql("DELETE FROM templ_tyyp WHERE ttyyp_id=50;", 1);
	run_sql("UPDATE templ_tyyp SET is_readonly= 1 WHERE ttyyp_id>=2000;", 1);
	run_sql("UPDATE templ_tyyp SET on_auto_avanev= '1';", 1);
}
/**
* FUNCTION copy_lang
* Copy ver3 keel table to ver4 table (dont overrride ver4 info - locale etc)
* 
* @param -
* @return -
*/
function copy_lang(){
	global $prefix, $DB;

	# select ver3 active languages
	$sql = 'select * from ' . $prefix . 'keel where on_kasutusel = 1 order by nimi;';
	$sth = new SQL($sql);
	while ($row = $sth->fetch('ASSOC')) {
		$sql2 = $DB->prepare("select count(*) from keel where nimi=?", $row['nimi']);
		$sth2 = new SQL($sql2);
		$lang_found = $sth2->fetchsingle();

		# if exists in ver4 => UPDATE
		if ($lang_found) {
			run_sql("UPDATE keel SET encoding='" . $row['encoding'] . "', on_default='" . $row['on_default'] . "', on_default_admin='" . $row['on_default_admin'] . "', site_url='" . $row['site_url'] . "', page_ttyyp_id='" . $row['page_ttyyp_id'] . "', ttyyp_id='" . $row['ttyyp_id'] . "' WHERE nimi='" . $row['nimi'] . "';", 1);	
		} else {		
			# if not exists in ver4 => INSERT
			run_sql("INSERT INTO keel (keel_id, nimi, encoding, extension, on_default, on_default_admin, on_kasutusel, site_url, page_ttyyp_id, ttyyp_id, locale) VALUES ('" . $row['keel_id'] . "', '" . $row['nimi'] . "','" . $row['encoding'] . "','" . $row['extension'] . "','" . $row['on_default'] . "','" . $row['on_default_admin'] . "','" . $row['on_kasutusel'] . "','" . $row['site_url'] . "','" . $row['page_ttyyp_id'] . "','" . $row['ttyyp_id'] . "','');", 1);	
		}
	}# while
}

/**
* FUNCTION convert_users
* Convert ver3 users, editors, roles into ver4 tables.
* 
* @param -
* @return -
*/
function convert_users(){
	#NB! table "spam" is not converted. 

	global $prefix, $DB;
	global $admingrupp_id_inver4, $kgrupp_id_inver4; # needed in users & permissions conversion

	$everybody_group_id = 1;

	# assoc arrays: array[ver3_id] = ver4_id
	$reguser_id_inver4 = array(); 
	$admin_id_inver4 = array();
	$kgrupp_id_inver4 = array();
	$admingrupp_id_inver4 = array();
	$admin_name_inver4 = array(); #array[ver3_id] = ver4 fullname

	############################ 1. DELETE OLD DATA #########################
	$sql = $DB->prepare("DELETE FROM groups WHERE group_id<>?",$everybody_group_id);
	run_sql($sql, 1);
	$sql = $DB->prepare("DELETE FROM roles");
	run_sql($sql, 1);
	$sql = $DB->prepare("DELETE FROM users");
	run_sql($sql, 1);
	$sql = $DB->prepare("DELETE FROM user_roles");
	run_sql($sql, 1);
	$sql = $DB->prepare("DELETE FROM user_mailinglist");
	run_sql($sql, 1);
	$sql = $DB->prepare("DELETE FROM favorites");
	run_sql($sql, 1);
	
	##################################### 2. KASUTAJA #################################

	######### 2.1 KGRUPP => GROUPS & ROLES
	# ver3 GROUP "All website visitors" => ver4 GROUP "Everybody" (existing)
	# ver3 GROUP "Registered users" => ver4 GROUP "Registered users" 
	# ver3 GROUP "Registered users" => ver4 ROLE "Registered users" 
	# ver3 GROUP "Some custom group" => ver4 ROLE "Some custom group"
	# ver3 GROUP ".." => ver4 ROLE "..."
	
	$sql = "SELECT * FROM " . $prefix . "kgrupp";
	$sth = new SQL($sql);
	$kgrupp_count = $sth->rows;
	
	while($ver3 = $sth->fetch()){
		#  All website visitors (ver3) = Everybody (ver4) => ignore, this group already exists:
		if ($ver3['kgrupp_id'] == 100) {
			continue;
		}

		################ ROLES
		$ver4 = array();

		$ver4['role_id'] = $ver3['kgrupp_id'];
		$ver4['name'] = $ver3['nimi'];

		$values_arr = array();
		foreach (array_values($ver4) as $val) {
			$values_arr[] = $DB->prepare("?", $val);
		}
		$sql = $DB->prepare("INSERT INTO roles (" . join(",", array_keys($ver4)) . ") VALUES(" . join(",", $values_arr) . ")");
		$insert_id = run_sql($sql, 1);

		########## SAVE new ID array for later
		$kgrupp_id_inver4[$ver3['kgrupp_id']] = $insert_id;

		################ / ROLES
		################ GROUPS
		### ID: 1 - Registered users
		### ID: 100 - All website visitors

		$ver4 = array();

		# Registered users:
		if($ver3['kgrupp_id'] == 1) { 
			$remember_regusers_kgrupp = $ver3['kgrupp_id'] = $kgrupp_count; # set ID to the last ID value (ID 100 was already ignored)
			
			$ver4['group_id'] = $ver3['kgrupp_id'];
			$ver4['parent_group_id'] = $everybody_group_id;
			$ver4['name'] = $ver3['nimi'];
			$ver4['description'] = $ver3['kirjeldus'];
			$ver4['auth_params'] = $ver3['auth_params'];
			$ver4['auth_type'] = $ver3['auth_type'];

			$values_arr = array();
			foreach (array_values($ver4) as $val) {
				$values_arr[] = $DB->prepare("?" , $val);
			}
			$sql = $DB->prepare("INSERT INTO groups (" . join(",", array_keys($ver4)) . ") VALUES(" . join(",", $values_arr) . ")");
			run_sql($sql, 1);
		} 
		################ / GROUPS

	} # while

	######### 2. KASUTAJA => USERS

	# get kasutaja password encoding/decoding key
	$sql = "SELECT sisu FROM " . $prefix . "config WHERE nimi='kasutaja_voti'";
	$sth = new SQL($sql);
	$cfg_kasutaja_voti = $sth->fetchsingle();

	$sql = "SELECT *, DECODE(pass,'" . $cfg_kasutaja_voti . "') AS decoded_pass FROM " . $prefix . "kasutaja";
	$sth = new SQL($sql);

	while ($ver3 = $sth->fetch()){
		$ver4 = array();

		$ver4['user_id'] = $ver3['kasutaja_id'];
		$ver4['email'] = $ver3['email'];
		$ver4['is_predefined'] = '';
		$ver4['username'] = $ver3['user'];		
		if($ver3['pass']) { # if password is set
			$ver4['password'] =  crypt($ver3['decoded_pass'], Chr(rand(65,91)).Chr(rand(65,91)));# generate PASSWORD
		}
		$ver4['firstname'] = $ver3['eesnimi'];
		$ver4['lastname'] = $ver3['perenimi'];
		$ver4['title'] = $ver3['tiitel'];
		$ver4['created_date'] = $ver3['aeg'];
		$ver4['session_id'] = $ver3['session_id'];
		$ver4['last_access_time'] = $ver3['last_access_time'];
		$ver4['is_locked'] = $ver3['on_lukus'];
		$ver4['idcode'] = $ver3['isikukood'];
		$ver4['address'] = $ver3['postiaadress'];
		$ver4['postalcode'] = $ver3['postiindeks'];
		$ver4['tel'] = $ver3['telefon'];
		$ver4['pass_expires'] = ($ver3['pass_expires']=='2999-01-01'?'2009-01-01':$ver3['pass_expires']);
		$ver4['autologin_ip'] = $ver3['autologin_ip'];
		$ver4['last_ip'] = $ver3['last_ip'];
		$ver4['account_nr'] = $ver3['account_nr'];
		$ver4['reference_nr'] = $ver3['reference_nr'];
		$ver4['city'] = $ver3['city'];
		$ver4['country'] = $ver3['country'];
		$ver4['delivery_address'] = $ver3['delivery_address'];
		$ver4['delivery_city'] = $ver3['delivery_city'];
		$ver4['delivery_zip'] = $ver3['delivery_zip'];
		$ver4['delivery_country'] = $ver3['delivery_country'];
		$ver4['contact_phone'] = $ver3['contact_phone'];
		$ver4['contactperson'] = $ver3['contactperson'];

		$ver4['group_id'] = $everybody_group_id; # add all users to Everybody group by default, modified later if needed

		########### INSERT USER
		$values_arr = array();
		foreach (array_values($ver4) as $val) {
			$values_arr[] = $DB->prepare("?", $val);
		}
		$sql = $DB->prepare("INSERT INTO users (" . join(",", array_keys($ver4)) . ") VALUES(" . join(",", $values_arr) . ")");
		$insert_id = run_sql($sql, 1);

		########## SAVE new ID array for later
		$reguser_id_inver4[$ver3['kasutaja_id']] = $insert_id;

	} # while

	######### 2.3 KASUTAJA_UUDISED => USER_MAILINGLIST

	$sql = "SELECT * FROM " . $prefix . "kasutaja_uudised";
	$sth = new SQL($sql);
	
	while ($ver3 = $sth->fetch()){
		$ver4 = array();

		$ver4['user_id'] = $reguser_id_inver4[$ver3['kasutaja_id']];
		$ver4['objekt_id'] = $ver3['objekt_id'];

		$values_arr = array();
		foreach (array_values($ver4) as $val) {
			$values_arr[] = $DB->prepare("?", $val);
		}
		$sql = $DB->prepare("INSERT INTO user_mailinglist (" . join(",", array_keys($ver4)) . ") VALUES(" . join(",", $values_arr) . ")");
		run_sql($sql, 1);		
	} # while

	######### 2.4 KASUTAJA_KGRUPP => ROLES (OR GROUP_ID)

	$sql = "SELECT * FROM " . $prefix . "kasutaja_kgrupp";
	$sth = new SQL($sql);
	while ($ver3 = $sth->fetch()){
		$ver4 = array();

		#  All website visitors (ver3) = Everybody (ver4) => ignore, users were moved under that group already:
		if ($ver3['kgrupp_id'] == 100) {
			continue;
		} 

		# if "Registered users" => set user group to "Registered users"
		if($ver3['kgrupp_id'] == 1) {
			$sql = $DB->prepare("UPDATE users SET group_id=? WHERE user_id=?",
				$remember_regusers_kgrupp, $reguser_id_inver4[$ver3['kasutaja_id']]
			);
			run_sql($sql, 1);			
		}
		# all groups => add as new roles
		$ver4['user_id'] = $reguser_id_inver4[$ver3['kasutaja_id']];
		$ver4['role_id'] = $kgrupp_id_inver4[$ver3['kgrupp_id']];

		$values_arr = array();
		foreach (array_values($ver4) as $val) {
			$values_arr[] = $DB->prepare("?", $val);
		}
		$sql = $DB->prepare("INSERT INTO user_roles (" . join(",", array_keys($ver4)) . ") VALUES(" . join(",", $values_arr) . ")");
		run_sql($sql, 1);		

	} # while
	################################## / 2. KASUTAJA ###############################

	##################################### 3. ADMIN #################################
	# admin - admin_grupp - grupp

	# ver3 all admins => ver4 GROUP "Editors" 
	# ver3 GROUP "Some custom admin group" => ver4 ROLE "Some custom admin group"
	# ver3 GROUP ".." => ver4 ROLE "..."
	# ver3 GROUP "SUPERUSER" => ver4 "users.is_predfined" => 1

	############ 3.1 ADMIN_GRUPP => GROUP & ROLES

	###### select max ID values
	$sql = "SELECT group_id FROM groups ORDER BY group_id DESC LIMIT 1";
	$sth = new SQL($sql);
	$max_group_id = $sth->fetchsingle();

	$sql = "SELECT role_id FROM roles ORDER BY role_id DESC LIMIT 1";
	$sth = new SQL($sql);
	$max_role_id = $sth->fetchsingle();

	###### 3.2 CREATE NEW GROUP "Editors"
	$ver4 = array();
	$remember_editors_grupp = $ver4['group_id'] = $max_group_id + 1;
	$ver4['parent_group_id'] = $everybody_group_id;
	$ver4['name'] = "Editors";
	$ver4['description'] = "Administrators from version 3";
	#??	$ver4[''] = $ver3['tyyp']; # superuser 1/0 (ver3)
	$ver4['auth_params'] = '';
	$ver4['auth_type'] = 'CMS';

	$values_arr = array();
	foreach (array_values($ver4) as $val) {
		$values_arr[] = $DB->prepare("?", $val);
	}
	$sql = $DB->prepare("INSERT INTO groups (" . join(",", array_keys($ver4)) . ") VALUES(" . join(",", $values_arr) . ")");
	run_sql($sql, 1);

	###### 3.3 CUSTOM ADMIN GROUPS => NEW ROLES
	$sql = "SELECT * FROM " . $prefix . "grupp WHERE grupp_id<>1";
	$sth = new SQL($sql);
	
	while ($ver3 = $sth->fetch()) {
		# ignore Superuser group - data is converted later
		if ($ver3['grupp_id'] == 1) {
			continue;
		}

		$ver4 = array();
		$max_role_id++;

		$ver4['role_id'] = $max_role_id;
		$ver4['name'] = $ver3['nimi'];

		$values_arr = array();
		foreach (array_values($ver4) as $val) {
			$values_arr[] = $DB->prepare("?", $val);
		}
		$sql = $DB->prepare("INSERT INTO roles (".join(",", array_keys($ver4)) . ") VALUES(" . join(",", $values_arr) . ")");
		$insert_id = run_sql($sql, 1);

		########## SAVE new ID array for later
		$admingrupp_id_inver4[$ver3['grupp_id']] = $insert_id; 

	} # while
	
	####### 3.4 USERS

	$sql = "SELECT * FROM " . $prefix . "admin";
	$sth = new SQL($sql);

	while($ver3 = $sth->fetch()){
		$ver4 = array();

		# Since reg.users already exist in "users" table, then 
		# CHECK UNIQUE FIELDS: username, email => give red alert if duplicate value found.

		if ($ver3['email']) {
			$sql2 = $DB->prepare("SELECT email FROM users WHERE email=?", $ver3['email']);
			$sth2 = new SQL($sql2);
			# if found, then print red error alert & delete e-mail value
			if($sth2->rows) {
				print "<font color=red><b>USER ERROR: </b>Duplicate e-mail address '<b>" . $ver3['email'] . "'</b> for admin '<b>" . $ver3['nimi'] . "</b>' (ID: " . $ver3['admin_id'] . "). E-mail address will be lost!</font><br />";
				$ver3['email'] = "";
			}
		} # email

		if($ver3['user']) {
			$sql2 = $DB->prepare("SELECT username FROM users WHERE username=?", $ver3['user']);
			$sth2 = new SQL($sql2);
			# if found, then print red error alert & delete e-mail value
			if($sth2->rows) {
				print "<font color=red><b>USER ERROR: </b>Duplicate username '<b>" . $ver3['user'] . "'</b> for admin '<b>" . $ver3['nimi'] . "</b>' (ID: " . $ver3['admin_id'] . "). Username will be lost!</font><br />";
				$ver3['user'] = '';
			}
		} # username


#		$ver4['user_id'] = $ver3['admin_id'];
		$ver4['email'] = $ver3['email'];
		$ver4['is_predefined'] = ''; # superuser info will be update later
		$ver4['username'] = $ver3['user'];		
		$ver4['password'] =  $ver3['pass']; # same crypt algorithm is used
		# split name field by sapce to get first- and lastname (possible errors)
		$tmp_arr = split(' ', $ver3['nimi']);
		$ver4['firstname'] = $tmp_arr[0];
		$ver4['lastname'] = $tmp_arr[1];
		$ver4['group_id'] = $remember_editors_grupp; # add all admins to "Everybody > Editors" group 

		# cant update this ver3 info:
		#$ver3['auth_type'];
		#$ver3['auth_params'];

		## INSERT USER
		$values_arr = array();
		foreach (array_values($ver4) as $val) {
			$values_arr[] = $DB->prepare("?", $val);
		}
		$sql = $DB->prepare("INSERT INTO users (" . join(",", array_keys($ver4)) . ") VALUES(" . join(",", $values_arr) . ")");
		$insert_id = run_sql($sql, 1);

		########## SAVE new ID array for later
		$admin_id_inver4[$ver3['admin_id']] = $insert_id;
		$admin_name_inver4[$ver3['admin_id']] = $ver3['nimi'];

	} # while

	########### 3.5 ver3 GROUP "SUPERUSER" => ver4 "users.is_predefined" => 1
	$sql = "SELECT " . $prefix . "admin_grupp.* FROM " . $prefix . "admin_grupp LEFT JOIN " . $prefix ."grupp ON " . $prefix . "admin_grupp.grupp_id=" . $prefix . "grupp.grupp_id WHERE " . $prefix . "grupp.grupp_id=1";
	$sth = new SQL($sql);
	
	while ($ver3 = $sth->fetch()) {
		$sql = $DB->prepare("UPDATE users SET is_predefined=1 WHERE user_id=?",
			$admin_id_inver4[$ver3['admin_id']]);
		run_sql($sql, 1);
		
	} # while

	######### 3.6 ADMIN_GRUPP => USER_ROLES (CUSTOM GROUPS => NEW ROLES)

	$sql = "SELECT * FROM " . $prefix . "admin_grupp WHERE " . $prefix . "admin_grupp.grupp_id<>1";
	$sth = new SQL($sql);
	
	while ($ver3 = $sth->fetch()) {
		$ver4 = array();

		$ver4['user_id'] = $admin_id_inver4[$ver3['admin_id']];
		$ver4['role_id'] = $admingrupp_id_inver4[$ver3['grupp_id']];

		$values_arr = array();
		foreach (array_values($ver4) as $val) {
			$values_arr[] = $DB->prepare("?", $val);
		}
		$sql = $DB->prepare("INSERT INTO user_roles (" . join(",", array_keys($ver4)) . ") VALUES(" . join(",", $values_arr) . ")");
		run_sql($sql, 1);		
	}
#printr($reguser_id_inver4);
#printr($admin_id_inver4);


	##################################### / 3. ADMIN #################################

	######################### 4. ALL USER RELATED TABLES #############################
	# Table fields that must be changed to new user ID values

	######### 4.1 admin fields
	# OBJEKT: admin_id, created_user_id, created_user_name (generate)

	# loop over editors(ver3 admins)
	foreach($admin_id_inver4 as $ver3_id => $ver4_id){
		$sql = $DB->prepare("UPDATE objekt SET admin_id=?, created_user_id=?, created_user_name=? WHERE admin_id=?",
			$ver4_id,
			$ver4_id,
			$admin_name_inver4[$ver3_id],
			$ver3_id
		);
		run_sql($sql, 1);		
	}

	######### 4.2 reg.user fields:
	# OBJ_KOMMENTAAR: kasutaja_id
	# OBJ_EVENT: kasutaja_id
	# GALLUP_IP: kasutaja_id
	# SHOP_CART: user_id

	# loop over reg.users
	foreach($reguser_id_inver4 as $ver3_id => $ver4_id){
		$sql = $DB->prepare("UPDATE obj_kommentaar SET kasutaja_id=? WHERE kasutaja_id=?", $ver4_id, $ver3_id);
		run_sql($sql, 1);

		$sql = $DB->prepare("UPDATE obj_event SET kasutaja_id=? WHERE kasutaja_id=?", $ver4_id, $ver3_id);
		run_sql($sql, 1);

		$sql = $DB->prepare("UPDATE gallup_ip SET user_id=? WHERE user_id=?", $ver4_id, $ver3_id);
		run_sql($sql, 1);

		$sql = $DB->prepare("UPDATE shop_cart SET user_id=? WHERE user_id=?", $ver4_id, $ver3_id);
		run_sql($sql, 1);		
	}

	######################### / 4. ALL USER RELATED TABLES #############################

}
/**
* FUNCTION convert_permissions
* Convert ver3 permissions (adminpages, objects) into ver4 tables.
* 
* @param -
* @return -
*/
function convert_permissions() {
	global $prefix, $DB;
	global $admingrupp_id_inver4, $kgrupp_id_inver4; # needed in users & permissions conversion

# ver3 permissions:
# grupp_admin_osa - adminlehtede access
# grupp_objekt - editorlehtede access
# objekt_kgrupp - reg.kasutajate access

	$everybody_group_id = 1;
	
	$subtree_perm = array();

	############################ 1. DELETE OLD DATA #########################
	$sql = $DB->prepare("DELETE FROM permissions");
	run_sql($sql, 1);

	####################### 2. ADMINPAGE PERMISSIONS #################
	$sql = "SELECT * FROM " . $prefix . "grupp_admin_osa";
	$sth = new SQL($sql);
	
	while ($ver3 = $sth->fetch()) {
		$ver4 = array();

		# if real group exists (it may be deleted group or smth)
		if ($admingrupp_id_inver4[$ver3['grupp_id']]) {
			$ver4['type'] = 'ADMIN';
			$ver4['source_id'] = $ver3['osa_id']; # adminpage ID
			$ver4['role_id'] = $admingrupp_id_inver4[$ver3['grupp_id']];
			$ver4['group_id'] = 0;
			$ver4['user_id'] = 0;
			$ver4['C'] = 1;
			$ver4['R'] = 1;
			$ver4['U'] = 1;
			$ver4['P'] = 1;
			$ver4['D'] = 1;

			$values_arr = array();
			foreach (array_values($ver4) as $val) {
				$values_arr[] = $DB->prepare("?", $val);
			}
			$sql = $DB->prepare("INSERT INTO permissions (" . join(",", array_keys($ver4)) . ") VALUES(" . join(",", $values_arr) . ")");
			$insert_id = run_sql($sql, 1);

		} # if group exists
	} # while
	
	####################### 3. OBJECT PERMISSIONS (for admin) #################

	$subtree_perm = array();

	$sql = "SELECT * FROM " . $prefix . "grupp_objekt";
	$sth = new SQL($sql);
	
	while ($ver3 = $sth->fetch()){
		$ver4 = array();

		# if real group exists (it may be deleted group or smth)
		if ($admingrupp_id_inver4[$ver3['grupp_id']]) {
			$ver4['type'] = 'OBJ';
			$ver4['source_id'] = $ver3['objekt_id']; 
			$ver4['role_id'] = $admingrupp_id_inver4[$ver3['grupp_id']];
			$ver4['group_id'] = 0;
			$ver4['user_id'] = 0;
			# $ver3['on_update']
			# $ver3['on_publish']
			# $ver3['on_alampuu']
			# $ver3['unit'] - ignoring, only for grouping

			#on_update=1 + on_publish=1	=> CRUPD = 11111
			#on_update=1 + on_publish=0 => CRUPD = 11101
			#on_update=0 + on_publish=1 => CRUPD = 01010
			#on_update=0 + on_publish=0 => CRUPD = 00000
			if ($ver3['on_update'] == 1 && $ver3['on_publish'] == 1) {
				$ver4['C'] = 1;
				$ver4['R'] = 1;
				$ver4['U'] = 1;
				$ver4['P'] = 1;
				$ver4['D'] = 1;
			} elseif ($ver3['on_update'] == 1 && $ver3['on_publish'] == 0) {
				$ver4['C'] = 1;
				$ver4['R'] = 1;
				$ver4['U'] = 1;
				$ver4['P'] = 0;
				$ver4['D'] = 1;
			} elseif ($ver3['on_update'] == 0 && $ver3['on_publish'] == 1) {
				$ver4['C'] = 0;
				$ver4['R'] = 1;
				$ver4['U'] = 0;
				$ver4['P'] = 1;
				$ver4['D'] = 0;
			} elseif ($ver3['on_update'] == 0 && $ver3['on_publish'] == 0) {
				$ver4['C'] = 0;
				$ver4['R'] = 0;
				$ver4['U'] = 0;
				$ver4['P'] = 0;
				$ver4['D'] = 0;
			}

			$values_arr = array();
			foreach (array_values($ver4) as $val) {
				$values_arr[] = $DB->prepare("?", $val);
			}
			$sql = $DB->prepare("INSERT INTO permissions (" . join(",", array_keys($ver4)) . ") VALUES(" . join(",", $values_arr) . ")");
			$insert_id = run_sql($sql, 1);

			####### if subtree included then remember this object permission row
			if($ver3['on_alampuu'] == 1) {
				$subtree_perm[$ver3['objekt_id']] = $ver4;
			}
		} # if group exists
	} # while

	####### INSERT all subtree permissions
	if (count($subtree_perm)) {
		foreach($subtree_perm as $source_id => $perm) {
			if ($source_id){ # if object ID is not 0
				insert_subtree_perm($source_id, $perm);
			}
		}	
	} # if found any subtree permission

	####################### 4. OBJECT PERMISSIONS (for reg.users) #################
	$subtree_perm = array();

	$sql = "SELECT * FROM " . $prefix . "objekt_kgrupp";
	$sth = new SQL($sql);
	
	while ($ver3 = $sth->fetch()) {
		$ver4 = array();

		# if real group exists (it may be deleted group or smth)
		if ($kgrupp_id_inver4[$ver3['kgrupp_id']]) {
			$ver4['type'] = 'OBJ';
			$ver4['source_id'] = $ver3['objekt_id']; 
			$ver4['role_id'] = $kgrupp_id_inver4[$ver3['kgrupp_id']];
			$ver4['group_id'] = 0;
			$ver4['user_id'] = 0;
			# $ver3['on_forbidden'] - value is always 1
			# $ver3['on_alampuu']
			# $ver3['unit'] - ignoring, only for grouping

			#on_forbidden=1 => CRUPD = 00000
			if ($ver3['on_forbidden'] == 1) {
				$ver4['C'] = 0;
				$ver4['R'] = 0;
				$ver4['U'] = 0;
				$ver4['P'] = 0;
				$ver4['D'] = 0;
			}

			$values_arr = array();
			foreach (array_values($ver4) as $val) {
				$values_arr[] = $DB->prepare("?", $val);
			}
			$sql = $DB->prepare("INSERT INTO permissions (" . join(",", array_keys($ver4)) . ") VALUES(" . join(",", $values_arr) . ")");
			$insert_id = run_sql($sql, 1);

			####### if subtree included then remember this object permission row
			if($ver3['on_alampuu'] == 1) {
				$subtree_perm[$ver3['objekt_id']] = $ver4;
			}
		} # if group exists
	} # while

	####### INSERT all subtree permissions
	if (count($subtree_perm)) {
		foreach($subtree_perm as $source_id => $perm) {
			if($source_id){ # if object ID is not 0
				insert_subtree_perm($source_id, $perm);
			}
		}	
	} # if found any subtree permission



	################## 5. INSERT default HOME section permissions: Read for Everybody

	$sql = $DB->prepare("SELECT objekt.objekt_id FROM objekt WHERE objekt.sys_alias=?", 'home');
	$sth = new SQL($sql);
	if ($sth->error) {
		print "<font color=red>Error: " . $sth->error . "</font>";
	}
	while ($home_obj = $sth->fetchsingle()) {
		$perm = array();
		$values_arr = array();

		# check if HOME section permission for group "Everybody" exists already:
		$sql = $DB->prepare("SELECT source_id FROM permissions WHERE type=? AND source_id=? AND role_id=? AND group_id=? AND user_id=?",
			'OBJ',
			$home_obj,
			0,
			$everybody_group_id,
			0
		);
		$sth2 = new SQL($sql);
		if ($sth2->error) {
			print "<font color=red>Error: " . $sth2->error . "</font>";
		}
		$perm_found = $sth2->rows;
		
		##### INSERT CRUPD=01000 for Everybody
		if(!$perm_found) {
			$perm['type'] = 'OBJ';
			$perm['source_id'] = $home_obj; 
			$perm['role_id'] = 0;
			$perm['group_id'] = $everybody_group_id;
			$perm['user_id'] = 0;
			$perm['C'] = 0;
			$perm['R'] = 1;
			$perm['U'] = 0;
			$perm['P'] = 0;
			$perm['D'] = 0;
			foreach (array_values($perm) as $val) {
				$values_arr[] = $DB->prepare("?", $val);
			}
			$sql = $DB->prepare("INSERT INTO permissions (" . join(",", array_keys($perm)) . ") VALUES(" . join(",", $values_arr) . ")");
			$insert_id = run_sql($sql, 1);		
		}
	} # while HOME sections
}

/**
* FUNCTION insert_subtree_perm
* 
* Recursive function inserts permission row to one object (section) and to all child sections.
* 
* @param integer obj_id Object ID
* @param array perm Permission array to insert
* @return 
*/
function insert_subtree_perm($obj_id, $perm) {
	global $prefix, $DB;

	##### get CHILD SECTIONS
	$sql = $DB->prepare("SELECT objekt.objekt_id FROM objekt_objekt 
			LEFT JOIN objekt on objekt.objekt_id=objekt_objekt.objekt_id 
			WHERE objekt.tyyp_id=? AND objekt_objekt.parent_id=?",
			1,
			$obj_id
	);
	$sth = new SQL($sql);
	if ($sth->error) {
		print "<font color=red>Error: " . $sth->error . "</font>";
	}
	$child_count = $sth->rows;

	#printr('obj_id: '.$obj_id.' childcount: '.$child_count);
	
	while ($child_obj = $sth->fetch()) {
		$values_arr = array();

		if ($child_obj['objekt_id']) { # if it's OK object

			##### INSERT permission row
			$perm['source_id'] = $child_obj['objekt_id'];

			# check if permission exists already:
			$sql = $DB->prepare("SELECT * FROM permissions WHERE type=? AND source_id=? AND role_id=? AND group_id=? AND user_id=?",
				$perm['type'],
				$perm['source_id'],
				$perm['role_id'],
				$perm['group_id'],
				$perm['user_id']
			);
			$sth2 = new SQL($sql);
			if ($sth2->error) {
				print "<font color=red>Error: " . $sth2->error . "</font>";
			}
			$perm_found = $sth2->rows;

			#### if permission found => display error message or ignore if the same permission
			if ($perm_found) {

				# get existing permission data for error message:
				$existing_perm = $sth2->fetch();
				if ($existing_perm['role_id']) { 
					# 1) 

					# 2) get data 
					$sql = $DB->prepare("SELECT name FROM roles WHERE role_id=?", $existing_perm['role_id']);
					$sth2 = new SQL($sql);
					$role_name = $sth2->fetchsingle();					
					$msg = ' Role "<b>' . $role_name . '</b>"  CRUPD=' . $existing_perm['C'] . $existing_perm['R'] . $existing_perm['U'] . $existing_perm['P'] . $existing_perm['D'] . '';
				}
				# get new permission data for errror message:
				if ($perm['role_id']) { 
					$sql = $DB->prepare("SELECT name FROM roles WHERE role_id=?", $perm['role_id']);
					$sth2 = new SQL($sql);
					$role_name = $sth2->fetchsingle();					
					$msg2 = ' Role "<b>' . $role_name . '</b>"  CRUPD=' . $perm['C'] . $perm['R'] . $perm['U'] . $perm['P'] . $perm['D'] . '';
				}
				# get object data for errror message:
				$sql = $DB->prepare("SELECT pealkiri FROM objekt WHERE objekt_id=?", $perm['source_id']);
				$sth2 = new SQL($sql);
				$obj_name = $sth2->fetchsingle();					

				######### if permission CRUPD is EXACTLY the same then dont show error message
				if ($existing_perm['C'] . $existing_perm['R'] . $existing_perm['U'] . $existing_perm['P'] . $existing_perm['D'] != $perm['C'] . $perm['R'] . $perm['U'] . $perm['P'] . $perm['D']) {
					print "<font color=red><b>PERMISSION ERROR: </b>Duplicate permission in subtree, object \"<b>" . $obj_name . "</b>\" ID: <b>" . $perm['source_id'] . "</b>. Permission will be lost!<br />";
					print "Existing: " . $msg  . ". New (ignored): " . $msg2  . ".<br /></font>";
				}
			} else { ### else INSERT	
				foreach (array_values($perm) as $val) {
					$values_arr[] = $DB->prepare("?", $val);
				}
				$sql = $DB->prepare("INSERT INTO permissions (" . join(",", array_keys($perm)) . ") VALUES(" . join(",", $values_arr) . ")");
				$insert_id = run_sql($sql, 1);
			} 

			# recursive step: to child
			insert_subtree_perm($child_obj['objekt_id'], $perm);

		} # if OK object
	} # loop over children
}
/**
* FUNCTION convert_profiles
* Convert ver3 profiles (tbl object_profiles) into ver4 tables, without overwriting existisng ver4 profiles.
* New table fields will be created if needed.
* 
* @param -
* @return -
*/
function convert_profiles() {

	global $prefix, $DB;

	$sql = "SELECT * FROM " . $prefix . "object_profiles";
	$sth = new SQL($sql);
	
	while ($ver3 = $sth->fetch()) {
		$ver4 = array();

		if($ver3['name'] && $ver3['source_table']) { # name and source_data is required

		#printr($ver3);

			## CHECK DUPLICATES: by unique field "name" => give red alert if duplicate value found.

			$sql2 = $DB->prepare("SELECT name FROM object_profiles WHERE name=?", $ver3['name']);
			$sth2 = new SQL($sql2);
			# if found, then print red error alert & do nothing
			if ($sth2->rows) {
				print "<font color=red><b>PROFILE ERROR: </b>Duplicate profile name <b>'" . $ver3['name'] . "'</b> (ID: " . $ver3['profile_id'] . "). Existing ver4 default profile will be lost!</font><br />";

				## DELETE ver4 profile
				$sql3 = $DB->prepare("DELETE FROM object_profiles WHERE name=?", $ver3['name']);
				run_sql($sql3, 1);
			}
			## CHECK DUPLICATES: by unique field "profile_id" => give red alert if duplicate value found.

			$sql2 = $DB->prepare("SELECT profile_id FROM object_profiles WHERE profile_id=?", $ver3['profile_id']);
			$sth2 = new SQL($sql2);
			# if found, then print red error alert & do nothing
			if ($sth2->rows) {
				print "<font color=red><b>PROFILE ERROR: </b>Duplicate profile ID <b>'" . $ver3['profile_id'] . "'</b> (name: " . $ver3['name'] . "). Existing ver4 default profile will be lost!</font><br />";

				## DELETE ver4 profile
				$sql3 = $DB->prepare("DELETE FROM object_profiles WHERE profile_id=?", $ver3['profile_id']);
				run_sql($sql3, 1);
			}


			## READ DATA
			$source_table = $ver3['source_table'];
			$data = unserialize($ver3['data']);
			#printr($data);

			## READ TABLES
			$sql2 = $DB->prepare("show tables");
			$sth2 = new SQL($sql2);
			while ($tbl_data = $sth2->fetchsingle()) {
				$tables[] = $tbl_data;
			}

			## CHECK if table exists
			## if table doesn't exist >= give red error alert and go to next.
			if (!in_array($source_table, $tables)) {
				print "<font color=red><b>PROFILE ERROR: </b>Table <b>'" . $source_table . "'</b> does not exist! Profile was still created, but you should create a table itself if needed.</font><br />";
				continue;
			}

			# get ver4 table fields (must be inside field loop, fields my be changed by previous profiles)
			$ver4_tbl_fields = array();
			$ver4_tbl_fields = split(",", $DB->get_fields(array(tabel => $source_table, 'no_cache' => 1)));

			$ver4_data = '';

			######## loop over profile fields and add new fields if needed
			if (count($data) && is_array($data)){
			#printr($data);
			foreach ($data as $fieldname => $field_def) {
				# add new field only if it doesn't exist in table
				if (!in_array($fieldname, $ver4_tbl_fields)) {
					#echo "UUS VLI: ".$source_table.".".$fieldname."<br />";

					if ($field_def['db_type'] == 'varchar') {
						$type = "VARCHAR(255)"; 
					}
					elseif ($field_def['db_type'] == 'integer') {
						$type = "BIGINT(11)";
					}
					elseif ($field_def['db_type'] == 'float') {
						$type = "FLOAT(7,2)";
					}
					elseif ($field_def['db_type'] == 'text') {
						$type = "TEXT";
					}
					elseif ($field_def['db_type'] == 'date') {
						$type = "DATE";
					}
					elseif ($field_def['db_type'] == 'datetime') {
						$type = "DATETIME";
					}
					elseif ($field_def['db_type'] == 'tinyint') {
						$type = "TINYINT(1)";
					}
					$sql = "ALTER TABLE " . $source_table . " ADD " . $fieldname . " " . $type;
					run_sql($sql, 1);

				} # add new field to table			

				##### create new field def data
				$ver4_field_def = array(
					"name" =>$field_def['name'],
					"type" =>$field_def['type'],
					"source_object" =>$field_def['source_object'],
					"default_value" =>'',
					"db_type" =>$field_def['db_type'],
					"is_required" => (isset($field_def['is_required']) ? $field_def['is_required'] : 0),
					"is_active" => (isset($field_def['is_active']) ? $field_def['is_active'] : 1),
					"is_predefined" => (isset($field_def['is_predefined']) ? $field_def['is_predefined'] : 0),
					"is_general" => 0
				);
				$ver4_data[$fieldname] = $ver4_field_def;
				#printr($field_def);
				#printr($ver4_field_def);				

			} # loop fields
			}

			######## INSERT profile

			$ver4['profile_id'] = $ver3['profile_id'];
			$ver4['name'] = $ver3['name'];
			$ver4['data'] = serialize($ver4_data);
			$ver4['source_table'] = $ver3['source_table'];

			$values_arr = array();
			foreach (array_values($ver4) as $val) {
				$values_arr[] = $DB->prepare("?", $val);
			}
			$sql = $DB->prepare("INSERT INTO object_profiles (" . join(",", array_keys($ver4)) . ") VALUES(" . join(",", $values_arr) . ")");
			run_sql($sql, 1);


		} # if name is set
	} # while ver3
}
/**
* FUNCTION create_ext_tables
* Creates identical "ext_" tables (structure + data)
* 
* @param -
* @return -
*/

function create_ext_tables() {
	global $prefix, $DB;

	## READ TABLES
	$sql2 = $DB->prepare("show tables");
	$sth2 = new SQL($sql2);
	$ext_prefix = $prefix . "ext_";

	while ($tbl_data = $sth2->fetchsingle()) {

		if (substr($tbl_data, 0, strlen($ext_prefix)) == $ext_prefix) {
			$sth3 = new SQL("show create table " . $tbl_data);
			if ($cd = $sth3->fetch("ASSOC")) {
				$q = str_replace($prefix, "", $cd['Create Table']);
				run_sql($q, 1);
				$sqli = "INSERT INTO " . substr($tbl_data, strlen($prefix)) . " SELECT * FROM " . $tbl_data;
				run_sql($sqli, 1);
			}
		}

	} # loop tables

}


/**
* FUNCTION copy_config
* Convert ver3 config values (not all, partial selection) into ver4 config table.
* 
* @param -
* @return -
*/
function copy_config() {
	global $prefix, $DB;

	$sql = $DB->prepare("SELECT * FROM " . $prefix . "config WHERE nimi NOT LIKE ? AND nimi NOT LIKE ? AND nimi NOT IN ('hostname','wwwroot','protocol','kasutaja_voti')",
		'%_path',
		'next_%'
	);
	$sth = new SQL($sql);
	if ($sth2->error) {
		print "<font color=red>Error: " . $sth2->error . "</font>";
	}
	while ($ver3 = $sth->fetch()) {
		#### UPDATE config value
		$sql = $DB->prepare("UPDATE config SET sisu=? WHERE nimi=?",
			$ver3['sisu'],
			$ver3['nimi']
		);
		$insert_id = run_sql($sql, 1);
	}
}
/**
* FUNCTION sync_all_folders
* Sync all folders & files
* 
* @param -
* @return -
*/
function sync_all_folders() {
	global $site;
	global $class_path;

	preg_match('/\/(admin|editor)\//i', getenv("REQUEST_URI"), $matches);
	$class_path = $matches[1] == "editor" ? "../classes/" : "./classes/";

	include_once($class_path . "port.inc.php");
	$site = new Site(array(
		on_debug=>0
	));

	########## public/ & shared/
	$public_dir = $site->absolute_path.substr($site->CONF['file_path'], 1);
	$shared_dir = $site->absolute_path.substr($site->CONF['secure_file_path'], 1);

	//echo "<table>";
	include_once($class_path . 'objectmanager.class.php');
	$manager = new objManagement();

	########## public/

	# create folders recursively
	$dirs = $manager->getDirectories(array(
		root_dir => $public_dir
	));
	# create files in all folders
	$manager->syncFolders(array(
		directory => $public_dir
	));
	if (is_array($manager->synced_folders)) {
		foreach ($manager->synced_folders as $folder_path) {
			/*echo "
			<tr>
			<td>".$folder_path." </td>
			<td>SYNC OK</td>
			</tr>
			";*/
			echo $folder_path . "&nbsp;&nbsp;&nbsp;SYNC OK<br />";
			flush(); sleep(1);
		} 
	} # is array

	########## shared/
	unset($manager->synced_folders);
	# create folders recursively
	$dirs = $manager->getDirectories(array(
		root_dir => $shared_dir
	));
	# create files in all folders
	$manager->syncFolders(array(
		directory => $shared_dir
	));
	if (is_array($manager->synced_folders)) {
		foreach ($manager->synced_folders as $folder_path) {
			/*echo "
			<tr>
			<td>".$folder_path." </td>
			<td>SYNC OK</td>
			</tr>
			";*/
			echo $folder_path . "&nbsp;&nbsp;&nbsp;SYNC OK<br />";
			flush(); sleep(1);
		} 
	} # is array

}
/**
* FUNCTION calc_memory
* 
* Calculate memory allocation starting from START OF static content export.
* Return currently allocated memory in bytes and inside this class.
* 
* @param integer $start_time 
* @return integer $mem 
*/
function calc_memory($start_amount) {
	return memory_get_usage() - $start_amount;
}



/**
* FUNCTION create_empty_extension
* 
* Creates an empty extension for
* 
* @param integer $start_time 
* @return integer $mem 
*/
function create_empty_extension() {


	//Behold the allmighty base64 encoded content of a custom extension.config.php


	$ext_conf_php = "PD8KLy8gRXh0ZW5zaW9uIHVuaXF1ZSBJRCwgbXVzdCBiZSB0aGUgc2FtZSB2YWx1ZSBhcyB0aGUgY3VycmVudCBkaXJlY3RvcnkgbmFtZS4KLy8gRG8gbm90IGluY2x1ZGUgc3BhY2VzIG9yIHNwZWNpYWwgY2hhcmFjdGVycy4KJEVYVEVOU0lPTlsnbmFtZSddID0gJyF4eHhfc2F1cnVzX25hbWUhJzsKCi8vIFRpdGxlLCBhcHBlYXJzIGluIHRoZSBzZWN0aW9uIGVkaXRvciBhbmQgZXh0ZW5zaW9ucyBtYW5hbmdlcgokRVhURU5TSU9OWyd0aXRsZSddID0gJyF4eHhfc2F1cnVzX3RpdGxlISc7CgovLyBTaG9ydCBkZXNjcmlwdGlvbiwgbWF5IGluY2x1ZGUgSFRNTCB0YWdzCiRFWFRFTlNJT05bJ2Rlc2NyaXB0aW9uJ10gPSAnVGhpcyBleHRlbnNpb24gaXMgbWVhbnQgdG8gd29yayBhbG9uZ3NpZGUgd2l0aCB0aGUgTW9kZXJuIHBhZ2UgdGVtcGxhdGUnOwoKLy8gQXV0aG9yIG5hbWUsIG1heSBpbmNsdWRlIEhUTUwgdGFncwokRVhURU5TSU9OWydhdXRob3InXSA9ICdTYXVydXMgd3d3LnNhdXJ1cy5pbmZvJzsKCi8vIEV4dGVuc2lvbiB2ZXJzaW9uIG51bWJlcgokRVhURU5TSU9OWyd2ZXJzaW9uJ10gPSAnMS4wJzsKCi8vIFZlcnNpb24gcmVsZWFzZSBkYXRlICh5eXl5LW1tLWRkKQokRVhURU5TSU9OWyd2ZXJzaW9uX2RhdGUnXSA9ICcheHh4X3NhdXJ1c192ZXJzaW9uX2RhdGVfeHh4ISc7CgovLyBQYXRoIHRvIHRoZSBpY29uIGltYWdlCiRFWFRFTlNJT05bJ2ljb25fcGF0aCddID0gJ2xvZ28uZ2lmJzsKCi8vIERlcGVuZGVuY3k6IHRoZSBtaW5pbXVtIFNhdXJ1cyB2ZXJzaW9uIHJlcXVpcmVkCiRFWFRFTlNJT05bJ21pbl9zYXVydXNfdmVyc2lvbiddID0gJzQuNS4zJzsKCj8+";


	//logo.gif that will be added to the extension

	$logo_gif = "R0lGODlhIAAgAOZ5AP////wBAZyctrsEBPkmJtDQ3/sZGfWIiPh3d/g3N/aYmPdWVvhHR8cCAtYCAvhjY/ZsbOOcnPIBAfsLC/ro6MAgIPzy8vSvr8hAQNd3d/eoqPK7u+YBAcU0NOcoKPQODuvr9OgUFPPLy9UsLNBbW/bc3Oc2NvLFxbq6zNRra70XF/q1teiqqv/Kyv/CwsoUFPPz+c9QUP/S0uzCwutDQ+mJieHh7f27u9yHh/Hx+Pb8/Orq8+Xl7+bm8P/c3ODg7NgbG/PPz8YmJupwcPz8/98+Pv39/7W1y+/v9u7u9aqqwq6uxemysvn5/vDw97e3zOfn8Kurw6env+dUVPX1/Lm5zK2txKiowK+vxba2zPj4/uzs9Nzc6aSkvbKyycnJ2p+fuqmpwZ6eudjY5tLS4Onp8vLy+d7e69XV5MzM25aWsbCwx6+vxt25ubGxx6Cgutc1NaOjvPb2/eTk7vT0+uvd3dPT4dfX5f7+/////wAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAHkALAAAAAAgACAAAAf/gHmCg4SFhoeIiYqLjI2IFiIRGZMZEREzIiUUFo6DGxgDFRgxJCQxHR0VFUIYJDgsJYwsAxiXJyJBIicbG0wXLDUZJBiorkxBnIQlKhi3u7wrGysrF9XVGhcKNUOnzCkngzgDERvXGucKGgrr6wcKB/DxQ0UqAySxGBXq7Ozx8AgHEAgcCKEghAUVBnSg0EGIv4ADBRp8QPHBAosLFjCYwoBGg3FCVAyROLFixpMMUtLomKBlAg8DBmQANYLiSY0pc7psSaBnTwMhQjT4mCHFgAZAEqTcmcDnTwNQP0j9wIGGAwcfLcVs4CCoAQJQDXyYQJZsALESJHDg4MGCBqwD/zYsG8p1LYe0AfLqzatgxYS0Eg4AAHDhRQUKeWIcvbpWgl4CNww8pgBAw4QAH3wAsACABQlBERY7eCBZrwIALkojAFCgtevWAnQgzkOhAlcPOlLnNUAZtWTNBQYDaEKlDIgCscMdrTFYBoEAq1vIAHAjevDBRLRsOW5HwKDaLyhrlpFgOgMDN4QvCI4CxZMjSEAImO8ddAoAKwi02AygxW4XAPgwwXUAGNFEDiD0cMcX9eVhQR06TMGBAQAC8IBeBrRwQADsoVDFE2tYIYYaaTToYBtXSfDBDRQYQJaLTRFAIABEwAACGmQgV0gGAziQFgELQOUUAQmwV8URXlwRx6AbYIxhYh4z9AhEUCH45AEBJmQZHB5GyJFEDzz8cAYXT+bB4wsepOlBliYUUQQcI7B3BBZWKBGGFF38UKYFRr0AxAiAAlrBCzEFZwQdOcS3Qw9z6IlIBB3EJKkoKdRwQnBZuMHGElEocYUUNpT5nQgzsIBLCcnkERwVMOTgRBI7QMFDqJ0UEhwMZjjB6aKzitpIATW2qqistNY6CH3IJhsIADs=";

	//We get the site name of the website in question and will convert it into the extension name/folder. 


	//List of folders that need to be created.
	$folder_list = array("css");

	//site_name value is used for the extension name.

	$q = "select sisu from config where nimi='site_name'";
	$sth = new SQL($q);
	$extension_title = $sth->fetchsingle();
	$extension_name = strtolower(safe_filename2($extension_title));
	$extension_date = date("Y-m-d");

	$parent_folder = getcwd() . "/extensions/";
	$new_dir = $parent_folder . $extension_name;


	if (!is_dir($new_dir)) {
		mkdir($new_dir);
		chmod($new_dir, 0777);

		foreach ($folder_list as $folder) {
					mkdir($new_dir . "/" . $folder);
					chmod($new_dir . "/" . $folder, 0777);
		}
	}

	$a = array("!xxx_saurus_version_date_xxx!", "!xxx_saurus_title!", "!xxx_saurus_name!");
	$b = array($extension_date, $extension_title, $extension_name);

	$new_file_body = str_replace($a, $b, base64_decode($ext_conf_php));

	#$file = file_get_contents(getcwd() . "/extensions/foo");
	#base64_encode($file);

	$fn = $new_dir . "/extension.config.php";
	touch($fn);
	chmod($fn, 0777);

	$fp = fopen($fn, 'w');
	fwrite($fp, $new_file_body);
	fclose($fp);

	$fn = $new_dir . "/logo.gif";
	touch($fn);
	chmod($fn, 0777);
	$fp = fopen($fn, 'w');
	fwrite($fp, base64_decode($logo_gif));
	fclose($fp);

	return $extension_name;
}




function css_query($nimi, $field, $default){

	$sql = 'select * from styles where nimi="' . $nimi . '"';
	$result = new SQL($sql);
	if ($row = $result->fetch('ASSOC')) { 

		if ($row[$field] != ""){
			return $row[$field];
		} else {
			return $default;
		}
	} else {
			return $default;
	}
}

function convert_CSS($extension_name) {

$foo = array(
	"convert_01" => css_query("hrz_menu_laius", "layout", "100%"),
	"convert_02" => css_query("sisu_tabeli_laius", "layout", "100%"),
	"convert_03" => css_query("hrz_menu_laius", "layout", "0 %"),
	"convert_04" => css_query("kogu_saidi_joondamine", "layout", "center"),
	"convert_05" => css_query("body_left_margin", "layout", "0"),
	"convert_06" => css_query("body_top_margin", "layout", "0"),
	"convert_07" => css_query("body_margin_width", "layout", "0"),
	"convert_08" => css_query("body_margin_height", "layout", "0"),
	"convert_09" => css_query("bg", "color", "#FFFFFF"),
	"convert_10" => css_query("txt", "font_family", "Verdana"), 
	"convert_11" => css_query("txt", "font_size", "12px"),
	"convert_12" => css_query("txt", "font_weight", "normal"),
	"convert_13" => css_query("txt", "font_style", ""),
	"convert_14" => css_query("txt", "color", "#FFFFFF"),
	"convert_15" => css_query("menyy_taust", "font_style", "#FFFFFF"),
	"convert_16" => css_query("menyy_border", "color", "#CCCCCC"),
	"convert16b" => css_query("alink", "color", ""),
	"convert16c" => css_query("vlink", "color", ""),
	"convert_17" => css_query("navibar", "background_color", "#FFFFFF"),
	"convert_18" => css_query("a__navi_on__active", "color", "#FFFFFF"), 
	"convert_19" => css_query("a__navi_on__active", "font_family", "Verdana, sans-serif;"),
	"convert_20" => css_query("a__navi_on__active", "font_size", "12px"),
	"convert_21" => css_query("a__navi_on__active", "font_weight", "normal"),
	"convert_22" => css_query("activecell", "background_color", "#FFFFFF"),
	"convert_23" => css_query("activecell", "background_color", "#FFFFFF"),
	"convert_24" => (css_query("menyy", "layout", "left")=="vasakul"?"left":"right"),
	"convert_25" => css_query("menyy_laius", "txt", "180px"),
	"convert_26" => css_query("boxhead", "background_color", "#FFFFFF"),
	"convert_27" => css_query("boxhead", "background_color", "#FFFFFF"),
	"convert_28" => css_query("menyy_tyyp", "layout", "box"), 
	"convert_29" => css_query("a__navi2_off__link", "color", "#FFFFFF"),
	"convert_30" => css_query("pealkiri", "font_size", "12px"),
	"convert_31" => css_query("pealkiri", "color", ""),
	"convert_32" => css_query("pealkiri", "font_weight", "normal"),
	"convert_33" => css_query("pealkiri", "font_family", "Verdana"),
	"convert_34" => css_query("link", "color", ""),
	"convert_35" => css_query("searchbtn", "font_family", "Verdana"),
	"convert_36" => css_query("searchbtn", "font_size", "12px"),
	"convert_37" => css_query("searchbtn", "font_weight", "normal"),
	"convert_38" => css_query("searchbtn", "background_color", "Verdana"),
	"convert_39" => css_query("searchbtn", "color", ""),
);

foreach ($foo as $k=>$v) {
	$dummy[] = $k;
	$replacement[] = $v;
}


$body = "/* --------------------------------------*/
/* --------->>> PAGE LAYOUT <<<----------*/
/* --------------------------------------*/
/*
Header width:
Content area width:
Content area height: - deprecated
Content area cellspacing: - deprecated
Site alignment:
Left margin:
Top margin:
Margin width: - deprecated
Margin height: - deprekated
*/

DIV{
	font-size:10px;
}
DIV#scms_Header{
	width:convert_01; 
}
DIV#scms_Content{
	width:convert_02; 
}
DIV#scms_Container{
	margin:0px convert_04; 
	margin:convert_05 convert_06 convert_07 convert_08;
}

/* --------------------------------------*/
/* -->>> Background and main colors <<<--*/
/* --------------------------------------*/

/*
Background color:
Add-on boxes background color:
Add-on boxes border color:
Background picture:
Visited link:
Active link:
*/

BODY{

	background-color:convert_09; 
	background-image:none; /* Background picture */
	font-family:convert_10;
	font-size:convert_11;
	font-weight: convert_12 convert_13; 
	color:convert_14; 
}
DIV.scms_box{
	background-color:convert_15; 
	border:1px solid convert_16; 
}
A.active{ 	color:convert16b; }
A:visited{ 	color:convert16c; }


/* --------------------------------------*/
/* -------->>> Horizontal menu <<<-------*/
/* --------------------------------------*/

DIV#scms_Navigation{
	background-color: convert_17;
}

DIV#scms_Navigation UL{
	/*display:table;
	width:100%;
	table-layout: fixed;*/
	padding:5px 0;
}
DIV#scms_Navigation UL LI{
	margin:0px;
	padding:0px;
	display:inline;
	list-style-type:none;
}
DIV#scms_Navigation UL LI A{
	padding:5px 50px 5px 10px; /* Link padding */
	border-left:1px solid #FFFFFF;
	color:convert_18;
	text-decoration:none;
	font-family: convert_19;
	font-size: convert_20;
	font-weight:convert_21;
}
DIV#scms_Navigation UL LI A:hover{
	background-color:convert_22;
}
DIV#scms_Navigation UL LI A.active{
	background-color:convert_23;
}



/* --------------------------------------*/
/* --------->>> Vertical menu <<<--------*/
/* --------------------------------------*/

/*
Type of menu: (list-style-type)
Location of menu: (left, right)
Menu width:
Color of menu links:
Color of active menu links:
Text style of menu links:
Text style of menu header:
Color of menu header:
Menu backgroud: (image)
*/

/* Left Menus and Addon Boxes */
DIV#scms_ColumnElements{
	float:convert_24;
	width:convert_25; 
	padding:10px;
}
DIV#scms_ColumnContent * {
	line-height:150%;
	font-family:Verdana, Arial, Helvetica, sans-serif;
	font-size:12px;
}
DIV#scms_ColumnContent{
	margin-left:182px; /* Content left margin - depends on DIV#scms_ColumnElements width */
}

/* Menu Header */
DIV.scms_ColumnMenu H1{
	color:convert_26; 
}

/* Menu and Addon */
DIV.scms_box H1{
	color:convert_27;
}

DIV#scms_ColumnMenu UL LI{
	list-style-type:convert_28; 
}

UL#scms_SectionTree LI A {
	color:convert_29; 
	width: 100%;
}


/* --------------------------------------*/
/* ------------>>> Addons <<<------------*/
/* --------------------------------------*/

/* Poll, List of links */
DIV#scms_ColumnAddon{
	display:none;
}
/* Search */
DIV#scms_ColumnSearch{
	display:none;
}

/* --------------------------------------*/
/* ---------->>> Text Styles <<<---------*/
/* --------------------------------------*/

/*
Main text
Headline
Heading2
Heading3
*/



/* Headline */
.pealkiri{
	font-size:convert_30;
	color:convert_31;
	font-weight:convert_32;
	font-family:convert_33;
}


A{
	color:convert_34; 
}



/* --------------------------------------*/
/* --------->>> Button Styles <<<--------*/
/* --------------------------------------*/

/*
Button
Text field
*/

INPUT.button,
INPUT.searchbtn{
	font-family:convert_35;
	font-size:convert_36; /* Size */
	font-weight:convert_37; /* Style */
	background-color:convert_38; /* Background color */
	color:convert_39; /* Text color */
	border:1px solid #A7A6AA;
}
INPUT.input{}

P#scms_ColumnSearchLinks A{
	color:#000; /* Sitemap and Advanced search */
}
P#scms_ColumnSearchLinks A:hover{
	text-decoration:underline;
}

/* --------------------------------------*/
/* ------------->>> Header <<<-----------*/
/* --------------------------------------*/

/* Logo */
DIV#scms_Logo{
	display:none;
}
/* Language select */
DIV#scms_LanguageSelector{
	display:none;
}
/* Title and slogan */
DIV#scms_TitleSlogan{
	display:none;
}
/* Search Box */
DIV#scms_HeaderSearchBox{
	position:absolute;
	right:25%;
	top:150px;
}

";

	$css_body = str_replace($dummy, $replacement, $body);

	$parent_folder = getcwd() . "/extensions/" . $extension_name;
	$fn = $parent_folder . "/css/main.css";
	touch($fn);
	chmod($fn, 0777);

	$fp = fopen($fn, 'w');
	fwrite($fp, $css_body);
	fclose($fp);


	$css_snippet = str_replace("replace_meh", $extension_name, "@import url(extensions/replace_meh/css/main.css);");

	$sql = 'select * from css where name = "custom_css"';
	$result = new SQL($sql);
	if ($row = $result->fetch('ASSOC')) { 
		$row['data'] = $css_snippet . "\n" . $row['data'];
			$sqlu = 'update css set data="' . mysql_real_escape_string(htmlspecialchars(trim($row['data']))) . '" where name = "custom_css"';
			new SQL($sqlu);
	}

}

/**
* FUNCTION convert_language
* 
* 
* @param -
* @return -
*/
function convert_language($language = "") {

	global $DB, $BLOB_TYPE_ARR;

	//$language = $_POST['language'];

	$obj_count = 0;

	## get real table fields
	$objekt_fields = array();
	$objekt_fields = split(",", $DB->get_fields(array(tabel => "objekt")));
	
	if ($language != "") {
		$sql = $DB->prepare("SELECT * FROM objekt WHERE keel=?",
			$language
		);
	} else {
		$sql = $DB->prepare("SELECT * FROM objekt");
	}
	$sth = new SQL($sql);
	if ($sth->error) {
		print "<font color=red>Error: " . $sth->error . "</font>";
	}
	while ($old_data = $sth->fetch()) {
	
		#### GENERATE new data
		$new_data = array();
		foreach($objekt_fields as $fieldname) {
			$new_data[$fieldname] = convert_value($old_data[$fieldname]);
		}

		#### UPDATE objekt
		$values_arr = array();
		foreach ($new_data as $field => $val) {
			$values_arr[] = $DB->prepare($field . "=?", $val);
		}
		$sql = "UPDATE objekt SET " . join(",", $values_arr) . " WHERE objekt_id='" . $old_data['objekt_id'] . "'";
#printr($sql);
		$i = run_sql($sql, 1, 0);	
		$obj_count += (int)$i;

		#################### CONTENT
		## get content table name
		$sql = $DB->prepare("SELECT tabel FROM tyyp WHERE tyyp_id=?", $old_data['tyyp_id']);
		$sth2 = new SQL($sql);
		if ($sth2->error) {
			print "<font color=red>Error: " . $sth2->error . "</font>";
		}
		$tyyp_table = $sth2->fetchsingle();

		## get real table fields
		$content_fields = array();

		$sql = "show fields from " . $tyyp_table;
		$sth2 = new SQL($sql);
		while ($field = $sth2->fetch()) {
			## ignore BLOB fields
			if (!in_array($field['Type'], $BLOB_TYPE_ARR)) {
				$content_fields[] = $field['Field'];
			}
		}

		$sql = $DB->prepare("SELECT * FROM " . $tyyp_table . " WHERE objekt_id=?", $old_data['objekt_id']);
		$sth2 = new SQL($sql);
		if ($sth2->error) {
			print "<font color=red>Error: " . $sth2->error . "</font>";
		}
		$old_content = $sth2->fetch();

		#### GENERATE new data
		$new_data = array();
		foreach ($content_fields as $fieldname) {			
			$new_data[$fieldname] = convert_value($old_content[$fieldname]);
		}

		#### UPDATE objekt content
		$values_arr = array();
		foreach ($new_data as $field=>$val) {
			$values_arr[] = $DB->prepare($field . "=?", $val);
		}
		$sql = "UPDATE " . $tyyp_table . " SET " . join(",", $values_arr) . " WHERE objekt_id='" . $old_data['objekt_id'] . "'";
#printr($sql);
		run_sql($sql, 1, 0);
		

		#################### / CONTENT

		
		if (($i % 100) == 0) {
			echo $i . "...";
			flush(); sleep(1);
		}
	}


	$sql = $DB->prepare("show tables like 'ext\_%'");
	$sth = new SQL($sql);
	$tables = array();

	while ($row = $sth->fetch()) {
		if (strpos($row[0], "ext_pp_") === false) {
			$tables[] = $row[0];
		}
	}
	$tables[] = "users";

	foreach ($tables as $key=>$value) {
		## get real table fields
		$content_fields = array();

		$sql = "show fields from " . $value;
		$sth2 = new SQL($sql);
		$primary_key = "";
		while ($field = $sth2->fetch()) {
			## ignore BLOB fields
			if (!in_array($field['Type'], $BLOB_TYPE_ARR)) {
				$content_fields[] = $field['Field'];
			}
			if ($field['Key'] == "PRI") {
				$primary_key = $field['Field'];
			}
		}
		
		if (!$primary_key) {
			print "<font color=red>Error: Primary key not found for table " . $value . ". Skipping.</font>";
		} else {
			$sql = $DB->prepare("SELECT * FROM " . $value);
			$sth2 = new SQL($sql);
			if ($sth2->error) {
				print "<font color=red>Error: " . $sth2->error . "</font>";
			}
			while ($old_content = $sth2->fetch()) {

				#### GENERATE new data
				$new_data = array();
				foreach ($content_fields as $fieldname) {			
					$new_data[$fieldname] = convert_value($old_content[$fieldname]);
				}

				#### UPDATE objekt content
				$values_arr = array();
				foreach ($new_data as $field=>$val) {
					$values_arr[] = $DB->prepare($field . "=?", $val);
				}
				$sql = "UPDATE " . $value . " SET " . join(", ", $values_arr) . " WHERE " . $primary_key . "=" . $new_data[$primary_key];
				//print $sql . "<br>";
				run_sql($sql, 1, 0);
				$obj_count++;
			}
		}
		flush(); sleep(1);
	}
	return $obj_count;
}
/**
* FUNCTION convert_value
* 
* 
* @param -
* @return -
*/
function convert_value($str) {

	global $DB;

	$ret = $str; # return string

	$convert_function = $_POST['convert_function'];
	$from_encoding = $_POST['from_encoding'];
	$to_encoding = $_POST['to_encoding'];

/*
# Convert Windows-1251 to UTF-8:
$c_str = mb_convert_encoding($str, "UTF-8", "CP1251");
$c_str = iconv("CP1251","UTF-8",$str);
*/

	if($convert_function == 'mbstring') {
		$ret = mb_convert_encoding($str, $to_encoding, $from_encoding);			
	} elseif($convert_function == 'iconv') {
		$ret = iconv($from_encoding, $to_encoding, $str);
	}

	return $ret;
}

/**
* FUNCTION convert_adr
* 
* 
* @param -
* @return -
*/
function convert_adr($table_array) {

	/*10 tables each with their own strucure will be looked for. If found all the data in each of them will the converted as specified . 

	each of the tables will go through this process:

	1. get table fields
	2. get all the table data
	3. convert each row 
	4. update each row

	*/

	global $DB, $BLOB_TYPE_ARR;

	$language = $_POST['language'];

	$obj_count = 0;

	$j  =0;

	echo "ADR conversion in progress: <br>";
	flush();

/*
1. ext_pp_asutus conversion
*/

	# Confirm table existance
	$sql = "SHOW TABLES LIKE 'ext_pp_asutus'";
	$result = new SQL($sql);
	
	if ($result->rows > 0 && in_array('ext_pp_asutus', (array)$table_array)) {	
  	## get real table fields	
  	$objekt_fields = array();
  	$objekt_fields = split(",", $DB->get_fields(array(tabel => "ext_pp_asutus")));
  
  	$sql = $DB->prepare("SELECT * FROM ext_pp_asutus");
  	$sth = new SQL($sql);
  	if (!$sth->error) {  
  		while($old_data = $sth->fetch()) {
  
  			#### GENERATE new data
  			$new_data = array();
  			foreach($objekt_fields as $fieldname) {
  				$new_data[$fieldname] = convert_value($old_data[$fieldname]);
  			}
  
  			#### UPDATE objekt
  			$values_arr = array();
  			foreach ($new_data as $field=>$val) {
				$values_arr[] = $field . "='" . mysql_real_escape_string(trim($val)) . "'";
			}
  			$sql = "UPDATE ext_pp_asutus SET " . join(",", $values_arr) . " WHERE asutus_id='" . $old_data['asutus_id'] . "'";
  			$i = run_sql($sql, 1, 0);	
  			$j++;
  			$obj_count += (int)$i;
  
  			#################### / CONTENT
  			if (($j % 100) == 0) {
  				echo "...";
  				flush(); 
  				#sleep(1);
  			}
  			if (($j % 1000) == 0) {
  				echo "<br>";
  				flush(); 
  				#sleep(1);
  			}
  		}
  		
  		echo '<p>ext_pp_asutus done!</p>';		
  	}
  }


/*
2. ext_pp_asutus_grupp conversion
*/
	
	# Confirm table existance
	$sql = "SHOW TABLES LIKE 'ext_pp_asutus_grupp'";
	$result = new SQL($sql);
	
	if ($result->rows > 0 && in_array('ext_pp_asutus_grupp', (array)$table_array)) {
		## get real table fields 
		$objekt_fields = array();
		$objekt_fields = split(",", $DB->get_fields(array(tabel => "ext_pp_asutus_grupp")));
	  
		$sql = $DB->prepare("SELECT * FROM ext_pp_asutus_grupp");
		$sth = new SQL($sql);
		if (!$sth->error) {  
			while ($old_data = $sth->fetch()) {
	  
				#### GENERATE new data
				$new_data = array();
				foreach($objekt_fields as $fieldname) {
	  				$new_data[$fieldname] = convert_value($old_data[$fieldname]);
				}
	  
				#### UPDATE objekt
				$values_arr = array();
				foreach ($new_data as $field=>$val) {
					$values_arr[] = $field . "='" . mysql_real_escape_string(trim($val)) . "'";
				}
				$sql = "UPDATE ext_pp_asutus_grupp SET " . join(",", $values_arr) . " WHERE asutus_id='" . $old_data['asutus_id'] . "' and grupp_id='" . $old_data['grupp_id'] . "'";
				$i = run_sql($sql, 1, 0);	
				$j++;
				$obj_count += (int)$i;
	  
				#################### / CONTENT
				if (($j % 100) == 0) {
					echo "...";
					flush(); 
					#sleep(1);
				}
				if (($j % 1000) == 0) {
					echo "<br>";
					flush(); 
					#sleep(1);
				}
			}
			
			echo '<p>ext_pp_asutus_grupp done!</p>';
		}
	}

/*
3. ext_pp_asutus_xml conversion
*/

	# Confirm table existance
	$sql = "SHOW TABLES LIKE 'ext_pp_asutus_xml'";
	$result = new SQL($sql);
	
	if ($result->rows > 0 && in_array('ext_pp_asutus_xml', (array)$table_array)) {	
		## get real table fields
		$objekt_fields = array();
		$objekt_fields = split(",", $DB->get_fields(array(tabel => "ext_pp_asutus_xml")));
	  
		$sql = $DB->prepare("SELECT * FROM ext_pp_asutus_xml");
		$sth = new SQL($sql);
		if (!$sth->error) { 
			while($old_data = $sth->fetch()) {
	  
				#### GENERATE new data
				$new_data = array();
				foreach ($objekt_fields as $fieldname){
	  
					$new_data[$fieldname] = convert_value($old_data[$fieldname]);
				}
	  
				#### UPDATE objekt
				$values_arr = array();
				foreach ($new_data as $field=>$val) {
					$values_arr[] = $field . "='" . mysql_real_escape_string(trim($val)) . "'";
				}
				$sql = "UPDATE ext_pp_asutus_xml SET " . join(",", $values_arr) . " WHERE id='" . $old_data['id'] . "'";
				$i = run_sql($sql, 1, 0);	
				$j++;
				$obj_count += (int)$i;
	  
				#################### / CONTENT
				if (($j % 100) == 0) {
					echo "...";
					flush(); 
					#sleep(1);
				}
				if (($j % 1000) == 0) {
					echo "<br>";
					flush(); 
					#sleep(1);
				}
			}
			
			echo '<p>ext_pp_asutus_xml done!</p>';
		}	
	}

/*
7. ext_pp_dummy
*/


	# Confirm table existance
	$sql = "SHOW TABLES LIKE 'ext_pp_dummy'";
	$result = new SQL($sql);
	
	if ($result->rows > 0 && in_array('ext_pp_dummy', (array)$table_array)) {		
		## get real table fields
		$objekt_fields = array();
		$objekt_fields = split(",", $DB->get_fields(array(tabel => "ext_pp_dummy")));	
	  
		$sql = $DB->prepare("SELECT * FROM ext_pp_dummy");
		$sth = new SQL($sql);
		if (!$sth->error) { 
			while($old_data = $sth->fetch()) {
	  
	  
				#### GENERATE new data
				$new_data = array();
				foreach ($objekt_fields as $fieldname) {
	  
					$new_data[$fieldname] = convert_value($old_data[$fieldname]);
				}
	  
				#### UPDATE objekt
				$values_arr = array();
				foreach ($new_data as $field=>$val) {
					$values_arr[] = $field . "='" . mysql_real_escape_string(trim($val)) . "'";
				}
				$sql = "UPDATE ext_pp_dummy SET " . join(",", $values_arr) . " WHERE type='" . $old_data['type'] . "' and value1='" . $old_data['value1'] . "' and value2='" . $old_data['value2'] . "' and value3='" . $old_data['value3'] . "'";
				$i = run_sql($sql, 1, 0);	
				$j++;
				$obj_count += (int)$i;
	  
				#################### / CONTENT
				if (($j % 100) == 0) {
					echo "...";
					flush(); 
					#sleep(1);
				}
				if (($j % 1000) == 0) {
					echo "<br>";
					flush(); 
					#sleep(1);
				}
			}
			
			echo '<p>ext_pp_dummy done!</p>';
		}
	}


/*
8. ext_pp_service
*/

	# Confirm table existance
	$sql = "SHOW TABLES LIKE 'ext_pp_service'";
	$result = new SQL($sql);
	
	if ($result->rows > 0 && in_array('ext_pp_service', (array)$table_array)) {		
		## get real table fields
		$objekt_fields = array();
		$objekt_fields = split(",", $DB->get_fields(array(tabel => "ext_pp_service")));
	  
		$sql = $DB->prepare("SELECT * FROM ext_pp_service");
		$sth = new SQL($sql);
		if (!$sth->error) { 
			while($old_data = $sth->fetch()) { 		
	  
					#### GENERATE new data
					$new_data = array();
					foreach ($objekt_fields as $fieldname) {
	  
						$new_data[$fieldname] = convert_value($old_data[$fieldname]);
					}
	  
					#### UPDATE objekt
					$values_arr = array();
					foreach ($new_data as $field=>$val) {
						$values_arr[] = $field . "='" . mysql_real_escape_string(trim($val)) . "'";
					}
					$sql = "UPDATE ext_pp_service SET " . join(",", $values_arr) . " WHERE id='" . $old_data['id'] . "'";
					$i = run_sql($sql, 1, 0);	
					$j++;
					$obj_count += (int)$i;
	  
					#################### / CONTENT
					if (($j % 100) == 0) {
						echo "...";
						flush(); 
					}
					if (($j % 1000) == 0) {
						echo "<br>";
						flush(); 
						#sleep(1);
					}
			}
			
			echo '<p>ext_pp_service done!</p>';
		}
	}

/*
9. ext_pp_teabenoue
*/

	# Confirm table existance
	$sql = "SHOW TABLES LIKE 'ext_pp_teabenoue'";
	$result = new SQL($sql);
	
	if ($result->rows > 0 && in_array('ext_pp_teabenoue', (array)$table_array)) {			
		## get real table fields
		$objekt_fields = array();
		$objekt_fields = split(",", $DB->get_fields(array(tabel => "ext_pp_teabenoue")));
	  
		$sql = $DB->prepare("SELECT * FROM ext_pp_teabenoue");
		$sth = new SQL($sql);
		if (!$sth->error) {
			while ($old_data = $sth->fetch()) {
	  
				#### GENERATE new data
				$new_data = array();
				foreach ($objekt_fields as $fieldname) {
					$new_data[$fieldname] = convert_value($old_data[$fieldname]);
				}
	  
				#### UPDATE objekt
				$values_arr = array();
				foreach ($new_data as $field=>$val) {
					$values_arr[] = $field . "='" . mysql_real_escape_string(trim($val)) . "'";
				}
				$sql = "UPDATE ext_pp_teabenoue SET " . join(",", $values_arr) . " WHERE id='" . $old_data['id'] . "'";
				$i = run_sql($sql, 1, 0);	
				$j++;
				$obj_count += (int)$i;
	  
				#################### / CONTENT
				if (($j % 100) == 0) {
					echo "...";
					flush(); 
				}
				if (($j % 1000) == 0) {
					echo "<br>";
					flush();
					#sleep(1);
				}
			}
			
		  echo '<p>ext_pp_teabenoue done!</p>';
		}
	}
/*
10. ext_pp_teema
*/

	# Confirm table existance
	$sql = "SHOW TABLES LIKE 'ext_pp_teema'";
	$result = new SQL($sql);
	
	if ($result->rows > 0 && in_array('ext_pp_teema', (array)$table_array)) {	
  	## get real table fields
  	$objekt_fields = array();
  	$objekt_fields = split(",", $DB->get_fields(array(tabel => "ext_pp_teema")));
  
  	$sql = $DB->prepare("SELECT * FROM ext_pp_teema");
  	$sth = new SQL($sql);
  	if (!$sth->error) { 
  		while ($old_data = $sth->fetch()) {
  
  			#### GENERATE new data
  			$new_data = array();
  			foreach ($objekt_fields as $fieldname) {
  				$new_data[$fieldname] = convert_value($old_data[$fieldname]);
  			}
  
  			#### UPDATE objekt
  			$values_arr = array();
  			foreach ($new_data as $field=>$val) {
				$values_arr[] = $field . "='" . mysql_real_escape_string(trim($val)) . "'";
			}
  			$sql = "UPDATE ext_pp_teema SET " . join(",", $values_arr) . " WHERE teema_id='" . $old_data['teema_id'] . "'";
  			$i = run_sql($sql, 1, 0);	
  			$j++;
  			$obj_count += (int)$i;
  
  			#################### / CONTENT
  			if (($j % 100) == 0) {
  				echo "...";
  				flush(); 
  			}
  			if (($j % 1000) == 0) {
  				echo "<br>";
  				flush(); 
  			}
  		}
  		
      echo '<p>ext_pp_teema done!</p>';
  	}
  }
/*
4. ext_pp_dok_teg
*/

	# Confirm table existance
	$sql = "SHOW TABLES LIKE 'ext_pp_dok_teg'";
	$result = new SQL($sql);
	
	if ($result->rows > 0 && in_array('ext_pp_dok_teg', (array)$table_array)) {		
		## get real table fields
		$objekt_fields = array();
		$objekt_fields = split(",", $DB->get_fields(array(tabel => "ext_pp_dok_teg")));
	  
		$sql = $DB->prepare("SELECT * FROM ext_pp_dok_teg");
		$sth = new SQL($sql);
		if (!$sth->error) { 
			while($old_data = $sth->fetch()) {
	  
				#### GENERATE new data
				$new_data = array();
				foreach ($objekt_fields as $fieldname) {
	  					$new_data[$fieldname] = convert_value($old_data[$fieldname]);
				}
	  
				#### UPDATE objekt
				$values_arr = array();
				foreach ($new_data as $field=>$val) {
					$values_arr[] = $field . "='" . mysql_real_escape_string(trim($val)) . "'";
				}
				$sql = "UPDATE ext_pp_dok_teg SET " . join(",", $values_arr) . " WHERE id='" . $old_data['id'] . "'";
				$i = run_sql($sql, 1, 0);	
				$j++;
				$obj_count += (int)$i;
	  
				#################### / CONTENT
				if (($j % 100) == 0) {
					echo "...";
					flush(); 
	  
				}
				if (($j % 1000) == 0) {
					echo "<br>";
					flush(); 
	  
				}
	  
			}
			
			echo '<p>ext_pp_dok_teg done!</p>';
		}
	}

/*
5. ext_pp_dokumendipuu
*/

	# Confirm table existance
	$sql = "SHOW TABLES LIKE 'ext_pp_dokumendipuu'";
	$result = new SQL($sql);
	
	if ($result->rows > 0 && in_array('ext_pp_dokumendipuu', (array)$table_array)) {	
		## get real table fields
		$objekt_fields = array();
		$objekt_fields = split(",",$DB->get_fields(array(tabel => "ext_pp_dokumendipuu")));
	  
		$sql = $DB->prepare("SELECT * FROM ext_pp_dokumendipuu");
		$sth = new SQL($sql);
		if (!$sth->error) {
			while($old_data = $sth->fetch()) {
	  
				#### GENERATE new data
				$new_data = array();
				foreach ($objekt_fields as $fieldname) {
					$new_data[$fieldname] = convert_value($old_data[$fieldname]);
				}
	  
				#### UPDATE objekt
				$values_arr = array();
				foreach ($new_data as $field=>$val) {
					$values_arr[] = $field . "='" . mysql_real_escape_string(trim($val)) . "'";
				}
				$sql = "UPDATE ext_pp_dokumendipuu SET " . join(",", $values_arr) . " WHERE id='" . $old_data['id'] . "'";
	  
				$i = run_sql($sql, 1, 0);	
				$j++;
				$obj_count += (int)$i;
	  
				#################### / CONTENT
				if (($j % 100) == 0) {
					echo "...";
					flush(); 
					#sleep(1);
				}
				if (($j % 1000) == 0) {
					echo "<br>";
					flush(); 
					#sleep(1);
				}
			}
			
		  echo '<p>ext_pp_dokumendipuu done!</p>';
		}
	}
  
/*
6. ext_pp_dokument
*/

	# Confirm table existance
	$sql = "SHOW TABLES LIKE 'ext_pp_dokument'";
	$result = new SQL($sql);
	
	if ($result->rows > 0 && in_array('ext_pp_dokument', (array)$table_array)) {		
		## get real table fields
		$objekt_fields = array();
		$objekt_fields = split(",",$DB->get_fields(array(tabel => "ext_pp_dokument")));
	  
		$sql = $DB->prepare("SELECT * FROM ext_pp_dokument");
		$sth = new SQL($sql);
		if (!$sth->error) {
			while($old_data = $sth->fetch()) {
	  
				#### GENERATE new data
				$new_data = array();
				foreach ($objekt_fields as $fieldname) {
					$new_data[$fieldname] = convert_value($old_data[$fieldname]);
				}
	  
				#### UPDATE objekt
				$values_arr = array();
				foreach ($new_data as $field=>$val) {
					$values_arr[] = $field . "='" . mysql_real_escape_string(trim($val)) . "'";
				}
				$sql = "UPDATE ext_pp_dokument SET " . join(",", $values_arr) . " WHERE dok_id='" . $old_data['dok_id'] . "'";
				$i = run_sql($sql, 1, 0);	
				$j++;
				$obj_count += (int)$i;
	  
				#################### / CONTENT
				if (($j % 100) == 0) {
					echo "...";
					flush(); 
					#sleep(1);
				}
				if (($j % 1000) == 0) {
					echo "<br>";
					flush(); 
					#sleep(1);
				}
	  
			}
			
		  echo '<p>ext_pp_dokument done!</p>';
		}
	}

	return $obj_count;
}
function fix_word_symbols(){



#   - Wordi alustavad jutumrgid
#   - Wordi alustavad jutumrgid
#   - Wordi lpetavad jutumrgid

$sql = "UPDATE obj_artikkel SET lyhi=REPLACE(lyhi,'','\"'), sisu=REPLACE(sisu,'','\"') WHERE lyhi like '%%' or sisu like '%%'";
$i = run_sql($sql, 1, 0);	

print "Asendada alustavad jutumrgid: " . $i . " kirjet (obj_artikkel.lyhi ja .sisu).<br />";

$sql = "UPDATE obj_artikkel SET lyhi=REPLACE(lyhi,'','\"'), sisu=REPLACE(sisu,'','\"') WHERE lyhi like '%%' or sisu like '%%'";
$i = run_sql($sql, 1, 0);	
print "Asendada alustavad jutumrgid: " . $i . " kirjet (obj_artikkel.lyhi ja .sisu).<br />";

$sql = "UPDATE obj_artikkel SET lyhi=REPLACE(lyhi,'','\"'), sisu=REPLACE(sisu,'','\"') WHERE lyhi like '%%' or sisu like '%%'";
$i = run_sql($sql, 1, 0);	
print "Asendada lpetavad jutumrgid: " . $i . " kirjet (obj_artikkel.lyhi ja .sisu).<br />";

#   - Wordi lakoma
$sql = "UPDATE obj_artikkel SET lyhi=REPLACE(lyhi,'','\''), sisu=REPLACE(sisu,'','\'') WHERE lyhi like '%%' or sisu like '%%'";
$i = run_sql($sql, 1, 0);	
print "Asendada lakoma: " . $i . " kirjet (obj_artikkel.lyhi ja .sisu).<br />";


#  pikk sidekriips

$sql = "UPDATE obj_artikkel SET lyhi=REPLACE(lyhi,'','-'), sisu=REPLACE(sisu,'','-') WHERE lyhi like '%%' or sisu like '%%'";
$i = run_sql($sql, 1, 0);	
print "Asendada pikk sidekriips: " . $i . " kirjet (obj_artikkel.lyhi ja .sisu).<br />";

# kigi objektide pealkirjad
$sql = "UPDATE objekt SET pealkiri=REPLACE(pealkiri,'','-') WHERE pealkiri like '%%'";
$i = run_sql($sql, 1, 0);	
print "Asendada pikk sidekriips: " . $i . " kirjet (objekt.pealkiri).<br />";

echo "<br /><br />The conversion is complete<br /><br />";
}


function fix_susisev($from, $to) {

	global $site;

	###### obj_artikkel

	$sql = "SELECT objekt_id FROM obj_artikkel WHERE lyhi like '%" . $from . "%' or sisu like '%" . $from . "%'";
	$i = run_sql($sql, 1, 0);	
	echo "Asenda " . $to . ". Leitud " . $from . ": " . $i . "<br />";
	$sql = "UPDATE obj_artikkel SET lyhi=REPLACE(lyhi,'" . $from . "','" . $to . "'), sisu=REPLACE(sisu,'" . $from . "','" . $to . "') WHERE lyhi like '%" . $from . "%' or sisu like '%" . $from . "%'";
	$i = run_sql($sql, 1, 0);	
	#printr(htmlspecialchars($sql));
	print "Asendada " . $from . " => " . $to . ": " . $i . " kirjet (obj_artikkel.lyhi ja .sisu).<br />";

	###### objekt

	$sql = "SELECT objekt_id FROM objekt WHERE pealkiri like '%" . $from . "%' or pealkiri_strip like '%" . $from . "%' or sisu_strip like '%" . $from . "%'";
	$i = run_sql($sql, 1, 0);	
	echo "Asenda " . $to . ". Leitud " . $from . ": " . $i . "<br />";
	$sql = "UPDATE objekt SET pealkiri=REPLACE(pealkiri,'" . $from . "','" . $to . "'), pealkiri_strip=REPLACE(pealkiri_strip,'" . $from . "','" . $to . "') , sisu_strip=REPLACE(sisu_strip,'" . $from . "','" . $to . "') WHERE pealkiri like '%" . $from . "%' or pealkiri_strip like '%" . $from . "%' or sisu_strip like '%" . $from . "%'";
	$i = run_sql($sql, 1, 0);	
	#printr(htmlspecialchars($sql));
	print "Asendada " . $from . " => " . $to . ": " . $i . " kirjet (objekt.pealkiri, .pealkiri_strip .sisu_strip).<br />";

	###### ext_pp_dokument
	$sql = "SHOW TABLES LIKE 'ext_pp_dokument'";
	$result = new SQL($sql);
	
	if ($result->rows > 0) {
  	$sql = "SELECT dok_id FROM ext_pp_dokument WHERE kellelt like '%" . $from . "%' or kellele like '%" . $from . "%' or pealkiri like '%" . $from . "%' or sisu like '%" . $from . "%'";
  	$i = run_sql($sql, 1, 0);	
  	echo "Asenda " . $to . ". Leitud " . $from . ": " . $i . "<br />";
  	
  	$sql = "UPDATE ext_pp_dokument SET kellelt = REPLACE(kellelt,'" . $from . "','" . $to . "'), kellele=REPLACE(kellele,'" . $from . "','" . $to . "'), pealkiri=REPLACE(pealkiri,'" . $from . "','" . $to . "'), sisu=REPLACE(sisu,'" . $from . "','" . $to . "') WHERE kellelt like '%" . $from . "%' or kellele like '%" . $from . "%' or pealkiri like '%" . $from . "%' or sisu like '%" . $from . "%'";
  	$i = run_sql($sql, 1, 0);
    print "Asendada " . $from . " => " . $to . ": " . $i . " kirjet (ext_pp_dokument.kellelt, .kellele .pealkiri .sisu).<br />";	
  }

}

/**
* sync_extensions2 (public)
* 
* 1) Reads directory "extensions/" and adds new record into table 'extension' for each found directory
* 2) searches for file "extension.config.php" and reads the values in that file into the extension record
*   - adds new admin-pages automatically, if needed
*   - adds new templates automatically, if needed
*	- adds new system word group, if needed
* 
* @package CMS
* 
*/
function sync_extensions2(){
	global $site, $class_path;

	$ext_path = $site->absolute_path . 'extensions/';
	$handle = opendir($ext_path);
	while (false !== ($dir = readdir($handle))) {
		if (is_dir($ext_path . $dir) && $dir != '.' && $dir != '..' && $dir != 'CVS') {
			$dirlist[] = $dir . "/";
		} # if
	} # while
	closedir($handle);
	# if no dirs found => do nothing & return
	if(!count($dirlist)) {
		return;
	}	
	sort($dirlist);	

	############ loop over extension directories
	foreach ($dirlist as $dir) {

		$dir_absolute_path = $ext_path . $dir;
		$dir_relative_path = 'extensions/' . $dir;

#		printr($dir_absolute_path);
#		printr($dir_relative_path);

		####### 1. check if extension exists
		$extension = new extension(array(
			name => substr($dir, 0, -1)
		));

		###### 2. extension not found in database => INSERT it
		if(!$extension->name) {

			$sql = $site->db->prepare("INSERT INTO extensions (name,path,is_active) VALUES (?,?,?)", substr($dir, 0, -1), $dir_relative_path, '0');
			$sth = new SQL($sql);
			#print($sql);
			$site->debug->msg($sth->debug->get_msgs());

			# reload extension:
			$extension = new extension(array(
				name => substr($dir, 0, -1)
			));
		} # INSERT
		else {
		}

		####### 3. search for CONFIG FILE
		$conf_found = $extension->load_extension_config();

		# now all config variables are in array $extension->CONF
		#printr($conf_found);

		####### 4. UPDATE extension record
		# 4.A config file found => we have official ext, overwrite all record values with config file values
		if($conf_found) {
			$sql = $site->db->prepare("UPDATE extensions SET path=?, is_official=?, title=?, description=?, author=?, version=?, version_date=?, icon_path=?, min_saurus_version=?, min_saurus_modules=? WHERE name=?",
				$dir_relative_path,
				'1',
				$extension->CONF['title'],
				$extension->CONF['description'],
				$extension->CONF['author'],
				$extension->CONF['version'],
				$extension->CONF['version_date'],
				$extension->CONF['icon_path'],
				$extension->CONF['min_saurus_version'],
				$extension->CONF['min_saurus_modules'],
				$extension->name
			);
		}
		# 4.B config file NOT found => we have custom ext, dont overwrite user defined record values
		else {
			$sql = $site->db->prepare("UPDATE extensions SET path=?, is_official=? WHERE name=?",
				$dir_relative_path,
				'0',
				$extension->name
			);
		} # official or custom ext
		$sth = new SQL($sql);
		#print($sql);
		$site->debug->msg($sth->debug->get_msgs());

		####### 6. CREATE ADMIN-PAGES
		if (count($extension->CONF['adminpages']) > 0) {
			#printr($extension->CONF['adminpages']);

			## get minimum sorteering from main menu "Extensions"
			$sql = $site->db->prepare("SELECT MIN(sorteering) AS min_sorteering FROM admin_osa WHERE parent_id=?", '86');
			$sth = new SQL($sql);
			#print($sql);
			$site->debug->msg($sth->debug->get_msgs());
			$min_sorteering = $sth->fetchsingle();
			$min_sorteering = intval($min_sorteering) - 1;

			foreach ($extension->CONF['adminpages'] as $adminpage) {
				## parent ID is hardcoded "86": Extensions
				#check if adminpage exists:

				$sql = $site->db->prepare("SELECT id FROM admin_osa WHERE nimetus=? AND parent_id=? AND extension=?", $adminpage["name"], '86', $extension->name);
				$sth = new SQL($sql);
				$adminpage_id = $sth->fetchsingle();

				## if not found => INSERT
				if (!$adminpage_id) {
					$sql = $site->db->prepare("INSERT INTO admin_osa (parent_id, sorteering, nimetus, eng_nimetus, fail, moodul_id, extension) VALUES (?, ?, ?, ?, ?, ?, ?)",
						86,
						$min_sorteering,
						$adminpage["name"],
						$adminpage["name"],
						$site->CONF['wwwroot'] . '/' . $extension->path . $adminpage["file"],
						0,
						$extension->name
					);
				}
				## if found => UPDATE
				else {
					$sql = $site->db->prepare("UPDATE admin_osa SET nimetus=?, eng_nimetus=?, fail=?, extension=?  WHERE id=?",
						$adminpage["name"],
						$adminpage["name"],
						$site->CONF['wwwroot'] . '/' . $extension->path . $adminpage["file"],
						$extension->name,
						$adminpage_id
					);
				}
				$sth = new SQL($sql);
				#print($sql);
				$site->debug->msg($sth->debug->get_msgs());

				#######################
				# save system word to group "admin":
				include_once($class_path . 'adminpage.inc.php');
				save_systemword(array(
					'sysword' => $adminpage['name'],
					'translation' => $adminpage['name'],
					'lang_id' => 1,
					'sst_id' => '12'
				));
			} # loop over adminpages
		} # if adminpages found

		####### 7. CREATE TEMPLATES
		
		if (count($extension->CONF['templates']) > 0) {
			#printr($extension->CONF['templates']);

			$sql = $site->db->prepare("SELECT max(ttyyp_id) FROM templ_tyyp WHERE ttyyp_id >= 1000 AND ttyyp_id < 2000 OR ttyyp_id >= 2100"	); 
			$sth = new SQL($sql);
			$site->debug->msg($sth->debug->get_msgs());	
			$max_id = $sth->fetchsingle();
			if ($max_id) {
				$max_id++;
			} else {
				$max_id = 1000;
			}

			############## loop over templates
			foreach ($extension->CONF['templates'] as $template) {
				#check if template exists:
				
				$template['op'] = translate_ee($template['op']);
				
				/* get op: dont overwrite existing values */
				$sql = $site->db->prepare("SELECT op FROM templ_tyyp WHERE op=? AND nimi<>?;", $template['op'], $template['name']);
				$sth = new SQL($sql);
				$op_found = $sth->fetchsingle();
				if ($op_found) {
					$template['op'] = ''; # dont overwrite
				}
				$sql = $site->db->prepare("SELECT ttyyp_id FROM templ_tyyp WHERE nimi=? AND extension=?", $template["name"], $extension->name);
				$sth = new SQL($sql);
				$template_id = $sth->fetchsingle();

				## if not found => INSERT
				if (!$template_id) {
					$sql = $site->db->prepare("INSERT INTO templ_tyyp (ttyyp_id, nimi, templ_fail, on_page_templ, on_nahtav, extension, op, is_readonly) VALUES (?, ?, ?, ?, ?, ?, ?, ?)",
						$max_id,
						$template['name'],
						'../../../'.$extension->path.$template['file'],
						($template['is_page'] ? 1 : 0),
						($template['is_visible'] ? 1 : 0),
						$extension->name,
						$template['op'],
						($template['is_readonly'] ? 1 : 0)
					);
					$max_id++;
				}
				## if found => UPDATE
				else {
					$sql = $site->db->prepare("UPDATE templ_tyyp SET nimi=?, templ_fail=?, on_page_templ=?, on_nahtav=?, extension=?, op=?, is_readonly=?  WHERE ttyyp_id=?",
						$template['name'],
						'../../../' . $extension->path . $template['file'],
						($template['is_page'] ? 1 : 0),
						($template['is_visible'] ? 1 : 0),
						$extension->name,
						$template['op'],
						($template['is_readonly'] ? 1 : 0),
						$template_id
					);
				}
				$sth = new SQL($sql);
				#print($sql.'<br />');
				$site->debug->msg($sth->debug->get_msgs());

			} # loop over templates

		} # if templates found

		####### 8. CREATE SYSTEMWORD GROUP in GLOSSARY

		# check if systemword group with that name exists
		$sql = $site->db->prepare("SELECT sst_id FROM sys_sona_tyyp WHERE voti=?", $extension->name); 
		$sth = new SQL($sql);
		$sst_id = $sth->fetchsingle();

		# UPDATE glossary group name
		if ($sst_id) {
			$sql = $site->db->prepare("UPDATE sys_sona_tyyp SET voti=?, nimi=?, extension=? WHERE sst_id=?", 
				$extension->name,
				($extension->CONF['title'] ? $extension->CONF['title'] : $extension->name),
				$extension->name,
				$sst_id
			);
			$sth = new SQL($sql);
		}
		# INSERT new glossary group
		else {
			# find new sst ID (must be >= 100; 0...100 are reserved for Saurus internal use)
			$sql = $site->db->prepare("SELECT MAX(sst_id) FROM sys_sona_tyyp"); 
			$sth = new SQL($sql);
			$site->debug->msg($sth->debug->get_msgs());	
			$max_id = $sth->fetchsingle();
			if ($max_id >= 100) {
				$max_id++;
			} else {
				$max_id = 100;
			}

			$sql = $site->db->prepare("INSERT INTO sys_sona_tyyp (sst_id, voti, nimi, extension) VALUES (?,?,?,?)", 
				$max_id,
				$extension->name,
				($extension->CONF['title'] ? $extension->CONF['title'] : $extension->name),
				$extension->name
			);
			$sth = new SQL($sql);


		}



		############# 9. CHECK DEPENDENCIES
		$extension->check_dependencies();

	}
	############ / loop over extension directories


}
# / sync_extensions
##########################

function show_help () {
?>
<script type="text/javascript">
function hidediv(divId) {
	var arr = document.getElementById(divId)
	if ( arr!= null ) {
		arr.style.display = (arr.style.display == 'none') ? 'block' : 'none';
	}
} 
</script> 
<a href="#" onClick="hidediv('help');return false;"><b>Click here to Show/hide help and tips</b></a><br /><br />
<table cellpadding="3" cellspacing="3" border="0" id="help" style="display: none; background: #f9f9ff;">
<tr><td><h3>Step 1 - export database of the source site</h3></td></tr>
<tr>
<td>
Source site: create database dump file: 
  
<pre>$ mysqldump -u&lt;username&gt; -p --default-character-set=latin1 --skip-opt -Q &lt;ver3db&gt; > ver3.dump</pre>

Note: Use parameter "--skip-opt" only in MySQL 4.1 and later, otherwise remove it.
</td>
</tr>

<tr><td><br /><br /></td></tr>

<tr><td><h3>Step 2 - import database into the target site</h3></td></tr>
<tr>
<td valign="top" style="border: 1px solid;"><u><b>2A If created dump file size is &gt; 50 MB and you have linux shell access to server</b></u>
<br />
<ol>
<li>
Run shell command that creates a new dump file "new_ver3.dump":
<pre>$ bash ./addprefix2dump.sh ver3.dump</pre>
</li>
<li>
Import dump file "new_ver3.dump" into the target site database:
<pre>$ mysql -u&lt;user&gt; -p --default-character-set=latin1 &lt;ver4db&gt; &lt; new_ver3.dump</pre>
</li>
</ol>
</td>
</tr>
<tr>
<td valign="top" style="border: 1px solid;"><u><b>2B If created dump file size is &gt; 50 MB and you don't have shell access</b></u>
<br />
<ol>
<li>
Run windows executable addprefix2dump.exe and convert your database dump.
</li>
</ol>
</td>
</tr>
<tr>
<td valign="top" style="border: 1px solid;"><u><b>2C If created dump file size is &lt;= 50 MB</b></u> (exact limit depends on your server settings)
<br /><br />
Proceed with Step 3
</td>
</tr>

<tr><td><br /><br /></td></tr>

<tr><td><h3>Step 3 - copy files</h3></td></tr>

<tr>
<td>
<ol>
<li>create a new folder "ver3" under target website root folder
<pre>$ mkdir ver3</pre>
</li>
<li>copy database dump file and the following folders from source site to the target site:</li>
	<table cellpadding="2" cellspacing="0" border="0">
	<tr><td><b>Source site</b></td><td><b>Target site</b></td></tr>
	<tr><td>ver3.dump</td><td>=> ver3/ver3.dump (skip it if you passed step 2A)</td></tr>
	<tr><td>failid/</td><td>=> ver3/failid/</td></tr>
	<tr><td>classes/smarty/templates/</td><td>=> ver3/templates/</td></tr>
	<tr><td>px_custom/*</td><td>=> px_custom/*</td></tr>
	</table>

<pre>Sample: $ cp -a /path/to/sourcesite/failid/ /path/to/targetsite/ver3/</pre>

<li>copy conversion script "convert.php" to the target website root folder</li>
</ol>
</td>
</tr>

<tr><td><br /><br /></td></tr>

<tr><td><h3>Step 4 - run conversion</h3></td></tr>
<tr><td>
<ol>
<li>Open "convert.php" in the browser, eg http://www.yoursite.com/convert.php. Follow instructions on the screen.
<br><b>NB!</b> Check also system information displayed in the Step 1, you may need to increase PHP settings.
</li>
<li>When viewing conversion results in Step 3, search for string "error" to be sure in conversion accuracy.</li>
</ol>
</td></tr>

<tr><td><br /><br /></td></tr>

<tr><td><h3>Step 5 (optional) - site encoding conversion </h3></td></tr>
<tr><td>
In case your website encoding is not UTF-8, we suggest to convert site content to the UTF-8 encoding. 
</td></tr>

<tr><td><br /><br /></td></tr>

<tr><td><h3>Step 6 - delete conversion files</h3></td></tr>
<tr><td>
<ol>
<li>Delete file "convert.php"</li>
<li>Delete folder "ver3/"</li>
</ol>
</td></tr>

<tr><td><br /><br /></td></tr>

<tr><td><h3>Step 7 - upgrade Saurus CMS version</h3></td></tr>
<tr><td>
Upgrade your website to the latest official version of Saurus CMS.
</td></tr>

<tr><td><br /><br /></td></tr>

<tr><td><h3>Step 8 - enter a license</h3></td></tr>
<tr><td>
Log in to the admin/ environment and enter a correct site license key.
<br /><br /><br /><br />
</td></tr>



</table>
<?

}

function fix_xss_bug() {
	global $DB;

	### ALTER TABLE here (avoid errors in install.php)

	$sql = "ALTER TABLE obj_file ADD kirjeldus text NULL";
	$sth = new SQL2($sql);


	######### 1. Liiguta Custom CSS tabelist "styles" (deprecated) uude tabelisse "css".

	$sql = "SELECT * FROM styles WHERE nimi='custom_css'";
	$sth = new SQL($sql);
	$style = $sth->fetch();
	$old_custom_css = $style['layout'];


	######### 2. Konverteeri styles.php sisu CSS-i tabelisse Custom css-i lppu.

		$sql = "SELECT * FROM styles";
		$sth = new SQL($sql);

		# Vljad, kus layout vib vrrelda '0', aga stiilitabelis ei pea olema:
		$peidetud = array('show_horisontaal_menu', 'kusmaolen_riba_korgus', 'body_left_margin', 'body_top_margin', 'body_margin_width', 'body_margin_height');

		$params = array('font_family', 'font_size', 'text_decoration', 'font_weight', 'font_style', 'background_color', 'color', 'line_height', 'width, height', 'margin_top', 'margin_right', 'margin_bottom', 'margin_left', 'padding_top', 'padding_right', 'padding_bottom', 'padding_left', 'border_color', 'border_style', 'border_top_width', 'border_right_width', 'border_bottom_width', 'border_left_width');

		while ($style = $sth->fetch()) {

			if ($style['nimi']=='custom_css'){
				$custom_css = $style['layout'];
			}
			if ($style['on_toimetajalt'] || $style['nimi'] == 'pealkiri' || $style['nimi'] == 'txt'){
				$is_wysiwyg = true;
			} else { $is_wysiwyg = false; }

			$style['nimi'] = preg_replace("/^a__/i", "A.", $style['nimi']);
			$style['nimi'] = preg_replace("/__/i", ":", $style['nimi']);
			$tmpnimi2=$style['nimi'];
			
			# pane . ette
			if (!preg_match("/\w+\./", $style['nimi'])) {
				$style['nimi'] = '.'.$style['nimi'];
			}		


			if (!$style['layout'] && !in_array($tmpnimi2, $peidetud)) {
				############## WYSIWYG CSS
				if ($is_wysiwyg){

					### muuda stiil "pealkiri" => "h1.pealkiri"
					if ($style['nimi'] == '.pealkiri'){

						$remember_pealkiri =  $style['nimi']." { ";
						$remember_pealkirih1 = 'h1'.$style['nimi']." { ";
						foreach ($params as $val) {
							$tmp .= ($style[$val] ? preg_replace("/_/", "-", $val).": ".$style[$val]."; " : "");
						}
						$remember_pealkiri .= $tmp. " } \n";
						$remember_pealkirih1 .= $tmp. " } \n";
						
					}
					## default
					else {
						$old_wysiwyg .=  $style['nimi']." { ";
						foreach ($params as $val) {
							$old_wysiwyg .=  ($style[$val] ? preg_replace("/_/", "-", $val).": ".$style[$val]."; " : "");
						}
						$old_wysiwyg .=  " } \n";
					} # pealkiri or not
				}

				############ OLD STYLES
				else {
					$old_styles .=  $style['nimi']." { ";
					foreach ($params as $val) {
						$old_styles .=  ($style[$val] ? preg_replace("/_/", "-", $val).": ".$style[$val]."; " : "");
					}
					$old_styles .=  " } \n";			
				}
			
			}
		} # while

	############### STYLES IN FIXED TEMPLATES (not in database, just set them free)

	$old_styles .= '
	/* New comment message text input area */
	#scms_comment_add_table TEXTAREA {
		width: 445px;
		height: 100px;
	}';


	################################ TO table "css"

	$sql = "SELECT * FROM css WHERE name='custom_css'";
	$sth = new SQL($sql);
	$css = $sth->fetch();

	########## 1. Styles from version 3
	$all_css = "/***********************************************************\n Styles from version 3:\n adminpages \"Visual Design > Site Styles\", \"Visual Design > Text Styles\"\n***********************************************************/\n\n";
	$all_css .= $old_styles."\n\n";

	########## 2. WYSIWYG CSS (was included in the end of the old ver3 styles)
	$all_css .= "/************************************************************\n WYSIWYG CSS\n***********************************************************/\n".$remember_pealkiri.$old_wysiwyg."\n";


	########### 3. Custom CSS
	$all_css .= "/***********************************************************\n Custom CSS\n***********************************************************/\n".$old_custom_css;


	### UPDATE
	if($sth->rows){ 
		$sql = "UPDATE css SET data='".$all_css."', is_active='1' WHERE name='custom_css'";
		#print $sql;
		$sth = new SQL($sql);
	}
	### INSERT
	else {
		$sql = "INSERT INTO css (name, data, is_active) VALUES('custom_css','".$all_css."',1)";
		$sth = new SQL($sql);
	}



	###################################### WYSIWYG CSS 

	$sql = "SELECT * FROM css WHERE name='wysiwyg_css'";
	$sth = new SQL($sql);
	$css = $sth->fetch();


	### UPDATE
	if($sth->rows){ 
		$sql = "UPDATE css SET data='".$remember_pealkirih1.$old_wysiwyg."', is_active=1 WHERE name='wysiwyg_css'";
		#print $sql;
		$sth = new SQL($sql);
	}
	### INSERT
	else {
		$sql = "INSERT INTO css (name, data, is_active) VALUES('wysiwyg_css','".$remember_pealkirih1.$old_wysiwyg."',1)";
		#print $sql;
		$sth = new SQL($sql);
	}


	###################################### WYSIWYG GENERAL

	$sql = "SELECT * FROM css WHERE name='wysiwyg_css_general'";
	$sth = new SQL($sql);
	$css = $sth->fetch();

	$wysiwyg_css_general = "body {
		font-family: Arial, Verdana, Sans-Serif;
		font-size: 12px;
		padding: 5px 5px 5px 5px;
		margin: 0px;
		border-style: none;
		background-color: #ffffff;
	}";

	### UPDATE
	if($sth->rows){ 
		$sql = "UPDATE css SET data='".$wysiwyg_css_general."', is_active=1 WHERE name='wysiwyg_css_general'";
		#print $sql;
		$sth = new SQL($sql);
	}
	### INSERT
	else {
		$sql = "INSERT INTO css (name, data, is_active) VALUES('wysiwyg_css_general','".$wysiwyg_css_general."',1)";
		#print $sql;
		$sth = new SQL($sql);
	}

}
?>