<?php
######################################################
# Saurus CMS site encoding converter
#
# Copyright (C) 2000-2006 Saurus http://www.saurus.info
######################################################

# This script is for converting site data from one character encoding to another.
# Script usage: http://www.yoursauruscmssite.com/convert_encoding.php
#
# 
# Changelog:
# 1.2 [28 Oct 2008]
#   - ADR support: Under the Language/Option selection there is 'ADR module conversion'. It must be done alongside with the languge conversions. 
#   - Added custom character conversion support that converts  characters and other types that the initial conversion ignores. Must be done after the languages have been converted into UTF-8. !!!! Works only with UTF-8 encoding. 
#   - 
# 1.1 [14 Dec 2006]
#   - Fixed bug: all binary fields must be ignored during conversion
# 1.0 [28 Nov 2006]
#   - initial release
######################################################

# Known bugs:
# Site Encoding Converter: system tables (eg users) are not included in encoding conversion.
# Site Encoding Converter: glossary is in the wrong encoding after conversion process.
# - teha fix susisevatele
# - teha fix wordi x smbolitele

error_reporting(7);

# set script execution time to 10 min only  if general value is smaller
if ( intval(ini_get('max_execution_time')) < 6000 ) {
	set_time_limit ( 6000 ) ;
}
if ( intval(ini_get('memory_limit')) < 1200 ) {
	ini_set ( "memory_limit", "1200M" );
}

# array of binary field types to ignore
$BLOB_TYPE_ARR = array('tinyblob', 'blob', 'mediumblob', 'longblob');

/***********************************/
/* INCLUDED FILES                  */
/***********************************/
$class_path = "./classes/";

if(!file_exists($class_path."port.inc.php")){
	echo "Error: Saurus CMS not found! Copy this script to your website root folder!";
	exit;
}
else {
	include($class_path."port.inc.php");
}

$CONFDB = ReadConfDB(); # db connect data from config table (ver4)
#printr($CONFDB);

ini_set('display_errors', 1);




/***********************************/
/* GLOBAL                          */
/***********************************/

$op = ($_POST["op"] ? $_POST["op"] : 'step1' );
$step_nr = substr(strtolower($op?$op:"step1"),-1);
$step_count = '2';


/***********************************/
/* HTML START                      */
/***********************************/
?>
<html>
	<head>
		<title>Saurus CMS site encoding converter</title>
		<meta name="author" content="Saurus - www.saurus.info">
		<meta http-equiv="Cache-Control" content="no-cache">
		<meta http-equiv="Content-Type" content="text/html; charset=<?=(isset($_POST['to_encoding'])?$_POST['to_encoding']:'UTF-8')?>">
		<link rel="stylesheet" href="styles/default/scms_general.css">
		<link rel="stylesheet" href="styles/default/scms_install.css">
		<style type="text/css">
		body {
			overflow: auto !important; 
		}
		</style>
	</head>

<body>
<font class="txt">
<center>

<div id="installheader">
	<table width="750">
	<tr>
		<td valign="bottom"><h1>Saurus CMS site encoding converter: Step <?=$step_nr?> of 
		<?=$step_count?></h1></td>
		<td align="right"><img class="logo" src="styles/default/gfx/install/logo.gif" height="20" width="101" alt="Saurus" /></td>
	</tr>
	</table>
</div>

<?
######################
# wizard
?>  

<table width="750" border="0" cellspacing="0" cellpadding="0">
<tr> 
<td valign=top style="height:450px;"> 
	<!-- Scrollable area -->
	<div id="listing" class="scms_scroll_div">

 


<?
/***********************************/
/* STEPS START                     */
/***********************************/
switch(@$op) {

	case "step1":

############################
# STEP 1
# - ask settings
############################

$languages = array();
$sql = 'select nimi, keel_id, encoding from keel where on_kasutusel = 1 order by nimi;';
$result = new SQL($sql);
while ($row = $result->fetch('ASSOC')) { 
	$languages[] = $row; 
}
$language_id = (int)$site->fdat['language'];

$enc_arr = array( 
 "ISO-8859-1",
 "ISO-8859-2",
 "ISO-8859-3",
 "ISO-8859-4",
 "ISO-8859-5",
 "ISO-8859-6",
 "ISO-8859-6-e",
 "ISO-8859-6-i",
 "ISO-8859-7",
 "ISO-8859-8",
 "ISO-8859-8-e",
 "ISO-8859-8-i",
 "ISO-8859-9",
 "ISO-8859-10",
 "ISO-8859-13",
 "ISO-8859-14",
 "ISO-8859-15",
 "UTF-8",
 "ISO-2022-JP",
 "EUC-JP",
 "Shift_JIS",
 "GB2312",
 "Big5",
 "EUC-KR",
 "windows-1250",
 "windows-1251",
 "windows-1252",
 "windows-1253",
 "windows-1254",
 "windows-1255",
 "windows-1256",
 "windows-1257",
 "windows-1258",
 "KOI8-R",
 "KOI8-U",
 "cp866",
 "cp874",
 "TIS-620",
 "VISCII",
 "VPS",
 "TCVN-5712");	

$ext_array = array();

$sql = "SHOW TABLES LIKE 'ext_pp_%'";
$result = new SQL($sql);
while ($row = $result->fetchsingle()) {
  $ext_array[] = $row; 
}
	?>
	<form action="<?=$_SERVER['PHP_SELF'];?>" method="post" name="form">

	<h1>Introduction</h1>
	<br />
	This script converts all content objects in one language from one character encoding to another.
	<br />
	<br />

	<table border=0 width="100%">
	<tr><td colspan=2><b>Settings</b></td></tr>

	<?############# function?>
	<tr>
	<td valign="top">PHP functions to use:</td>
	<td nowrap>
	<input type="radio" name="convert_function" id="mbstring" value="mbstring" checked><label for="mbstring"><b>mbstring</b></label>
(PHP must be compiled with '--enable-mbstring')
	<br />
	<?if(!function_exists("mb_convert_encoding"))	{
		print "<font color=red><b>Function mb_convert_encoding() not found!</b></font><br />";
	}?>
	<input type="radio" name="convert_function" id="iconv" value="iconv"><label for="iconv"><b>iconv</b></label>
(PHP must be compiled with '--with-iconv')
	<br />
	<?if(!function_exists("iconv"))	{
		print "<font color=red><b>Function iconv() not found!</b></font><br />";
	}?>
	</td>
	</tr>

	<?############# language?>
	<tr>
	<td>Language/Option to convert:</td>
	<td>
	<select name="language" class="select" onchange="if (this.options[this.selectedIndex].value == 'ADR') { document.getElementById('adr_options').style.display = ''; } else { document.getElementById('adr_options').style.display = 'none'; }">
	<? foreach($languages as $language) { ?>
		<option value="<?=$language['keel_id'];?>"<?=($language['keel_id'] == $language_id ? ' selected="selected"' : '');?>><?=$language['nimi'].' ('.$language['encoding'].')';?></option>
	<? 
		if($language['keel_id'] == $language_id ) $selected_enc = $language['encoding'];
	} 
	?>
		<option value="ADR">ADR module conversion</option>
		<option value="FIXSYMBOLS">Fix non-standard symbols</option>
	</select>
	</td>
	</tr>

	<tr id="adr_options" style="vertical-align: top; display: none;">
  	<td>
      ADR tables to convert:
    </td>
  	<td>
      <? if (in_array('ext_pp_asutus', $ext_array)) { ?>
      <label>
        <input type="checkbox" name="adr_table[]" value="ext_pp_asutus" checked="checked"> ext_pp_asutus
      </label>
      <br>
      <? } ?>
      <? if (in_array('ext_pp_asutus_grupp', $ext_array)) { ?>      
      <label>
        <input type="checkbox" name="adr_table[]" value="ext_pp_asutus_grupp" checked="checked"> ext_pp_asutus_grupp
      </label>
      <br>
      <? } ?>
      <? if (in_array('ext_pp_asutus_xml', $ext_array)) { ?> 
      <label>
        <input type="checkbox" name="adr_table[]" value="ext_pp_asutus_xml" checked="checked"> ext_pp_asutus_xml
      </label>
      <br>
      <? } ?>
      <? if (in_array('ext_pp_dummy', $ext_array)) { ?> 
      <label>
        <input type="checkbox" name="adr_table[]" value="ext_pp_dummy" checked="checked"> ext_pp_dummy
      </label>
      <br>
      <? } ?>
      <? if (in_array('ext_pp_service', $ext_array)) { ?> 
      <label>
        <input type="checkbox" name="adr_table[]" value="ext_pp_service" checked="checked"> ext_pp_service
      </label>
      <br>
      <? } ?>
      <? if (in_array('ext_pp_teabenoue', $ext_array)) { ?> 
      <label>
        <input type="checkbox" name="adr_table[]" value="ext_pp_teabenoue" checked="checked"> ext_pp_teabenoue
      </label>
      <br>
      <? } ?>
      <? if (in_array('ext_pp_teema', $ext_array)) { ?> 
      <label>
        <input type="checkbox" name="adr_table[]" value="ext_pp_teema" checked="checked"> ext_pp_teema
      </label>
      <br>
      <? } ?>
      <? if (in_array('ext_pp_dok_teg', $ext_array)) { ?> 
      <label>
        <input type="checkbox" name="adr_table[]" value="ext_pp_dok_teg" checked="checked"> ext_pp_dok_teg
      </label>
      <br>
      <? } ?>
      <? if (in_array('ext_pp_dokumendipuu', $ext_array)) { ?> 
      <label>
        <input type="checkbox" name="adr_table[]" value="ext_pp_dokumendipuu" checked="checked"> ext_pp_dokumendipuu
      </label>
      <br>
      <? } ?>
      <? if (in_array('ext_pp_dokument', $ext_array)) { ?> 
      <label>
        <input type="checkbox" name="adr_table[]" value="ext_pp_dokument" checked="checked"> ext_pp_dokument
      </label>
      <? } ?> 
  	</td>
	</tr>

	<?############# from => to encoding?>
	<tr>
	<td>Convert encoding:</td>
	<td>
	from
	<select name="from_encoding" class="select">
	<? foreach($languages as $language) { ?>
		<option value="<?=$language['encoding'];?>"  <?=($language['encoding']==$selected_enc ? "selected" : "")?>><?=$language['encoding'];?></option>
	<? } ?>

	</select>
	to
	<select name="to_encoding" class="select">
	<? foreach($enc_arr as $enc) {?>
			<option value="<?=$enc?>"><?=$enc?></option>
	<?}?>
	</select>
	</td>
	</tr>

	</table>
	<br />
	<br />
	<b><font color="red">NB! Next step will modify your website data! Be sure you have backed up your database before clicking Next button.</font></b>
	<br />
	<br />
			<center>
			<INPUT type="hidden" name="op" value="step2">
			<INPUT type="submit" value="Next" class="redbutton">
			</center>
	</form>

	<?############ system info ?>
	<b>System info</b><br />
	<ul>
	<li>max_execution_time = <b><?=ini_get('max_execution_time')?></b> sec</li>
	<li>memory_limit = <b><?=ini_get('memory_limit')?></b></li>		
	</ul>

	Depending on your website data amount you may need to increase these PHP settings in .htaccess file.
		
	<br />

<?


	break;

	case "step2":
############################
# STEP 2
# - convert encoding
############################

	if($_POST['language']=="ADR"){
		$obj_count = convert_adr($_POST['adr_table']);
	}elseif($_POST['language']=="FIXSYMBOLS"){

$obj_count = fix_word_symbols();

######## zh
fix_susisev(chr(194).chr(158),chr(197).chr(190));
######### ZH => Ž
fix_susisev(chr(194).chr(142),chr(197).chr(189));

######### sh => ?
fix_susisev(chr(194).chr(154),chr(197).chr(161));

######### SH => Š
fix_susisev(chr(194).chr(138),chr(197).chr(160));

	}else{
		$obj_count = convert_language();
	}

?>
		<br />
		<br />
		Data conversion completed. <b><?=$obj_count?><b> content objects modified.
		<br /><br />

<?	
	default:

	# do nothing
}

/**************************
END HTML
***************************/
?>

	</font>

</blockquote></blockquote></blockquote></blockquote></blockquote>
<br /><br /><br />
</body>
</html>
<?




/**
* FUNCTION run_dumpfile
* Run database dump file with sql querys
* 
* @param -
* @return string Return error string
*/

/**
* FUNCTION run_sql
* 
* 
* @param string $sql SQL
* @param string $silent Run silently - dont display errors
* @return -
*/
function run_sql($sql,$silent,$display=true) {

	global $conn, $CONF;

	$sth = new SQL($sql);
	if($display) {
		print $sql." (<b>".$sth->rows."</b>)<br />";
	}
	if ($sth->error && !$silent) { print "<font color=red>Error: ".$sth->error."</font><br />"; }
	flush();
	if($sth->insert_id) { return $sth->insert_id; }
	if($sth->rows) { return $sth->rows; }

}
/**
* FUNCTION ReadConfDB
* It's copy-paste from classes/site.class.php (except 1 line, see below) 
* 
* @param -
* @return array $conf Array of configuration variables
*/
function ReadConfDB() {

// NB! exception in copy-paste: this 1 line must be added
	global $conn;
	$sql = "SELECT nimi,sisu FROM config";
	$sth = new SQL($sql);
	if ($sth->error) { print "<font color=red>Error: ".$sth->error."</font>"; }
	while ($conf_rida = $sth->fetch()) {
		$conf[$conf_rida['nimi']] = $conf_rida['sisu'];
	}
	return $conf;
}

/**
* FUNCTION convert_language
* 
* 
* @param -
* @return -
*/
function convert_language(){

	global $DB, $BLOB_TYPE_ARR;

	$language = $_POST['language'];

	$obj_count = 0;

	## get real table fields
	$objekt_fields = array();
	$objekt_fields = split(",",$DB->get_fields(array(tabel => "objekt")));
	

	$sql = $DB->prepare("SELECT * FROM objekt WHERE keel=?",
		$language
	);
	$sth = new SQL($sql);
	if ($sth->error) { print "<font color=red>Error: ".$sth->error."</font>"; }
	while($old_data = $sth->fetch()) {
	


		#### GENERATE new data
		$new_data = array();
		foreach($objekt_fields as $fieldname){
			$new_data[$fieldname] = convert_value($old_data[$fieldname]);
		}

		#### UPDATE objekt
		$values_arr = array();
		foreach ($new_data as $field=>$val) { $values_arr[] = $DB->prepare($field."=?",$val); }
		$sql = "UPDATE objekt SET ".join(",",$values_arr)." WHERE objekt_id='".$old_data['objekt_id']."'";
#printr($sql);
		$i = run_sql($sql,1,0);	
		$obj_count += (int)$i;

		#################### CONTENT
		## get content table name
		$sql = $DB->prepare("SELECT tabel FROM tyyp WHERE tyyp_id=?", $old_data['tyyp_id']);
		$sth2 = new SQL($sql);
		if ($sth2->error) { print "<font color=red>Error: ".$sth2->error."</font>"; }
		$tyyp_table = $sth2->fetchsingle();

		## get real table fields
		$content_fields = array();

		$sql = "show fields from ".$tyyp_table;
		$sth2 = new SQL($sql);
		while($field = $sth2->fetch()){
			## ignore BLOB fields
			if(!in_array($field['Type'],$BLOB_TYPE_ARR)) {
				$content_fields[] = $field['Field'];
			}
		}

		$sql = $DB->prepare("SELECT * FROM ".$tyyp_table." WHERE objekt_id=?", $old_data['objekt_id']);
		$sth2 = new SQL($sql);
		if ($sth2->error) { print "<font color=red>Error: ".$sth2->error."</font>"; }
		$old_content = $sth2->fetch();

		#### GENERATE new data
		$new_data = array();
		foreach($content_fields as $fieldname){			
			$new_data[$fieldname] = convert_value($old_content[$fieldname]);
		}

		#### UPDATE objekt content
		$values_arr = array();
		foreach ($new_data as $field=>$val) { $values_arr[] = $DB->prepare($field."=?",$val); }
		$sql = "UPDATE ".$tyyp_table." SET ".join(",",$values_arr)." WHERE objekt_id='".$old_data['objekt_id']."'";
#printr($sql);
		run_sql($sql,1,0);
		

		#################### / CONTENT

		
		if(($i % 100)==0){
			echo $i."...";
			flush(); sleep(1);
		}
	}
	return $obj_count;
}
/**
* FUNCTION convert_value
* 
* 
* @param -
* @return -
*/
function convert_value($str){

	global $DB;

	$ret = $str; # return string

	$convert_function = $_POST['convert_function'];
	$from_encoding = $_POST['from_encoding'];
	$to_encoding = $_POST['to_encoding'];

/*
# Convert Windows-1251 to UTF-8:
$c_str = mb_convert_encoding($str, "UTF-8", "CP1251");
$c_str = iconv("CP1251","UTF-8",$str);
*/

	if($convert_function == 'mbstring') {
		$ret = mb_convert_encoding($str, $to_encoding, $from_encoding);			
	}
	elseif($convert_function == 'iconv') {
		$ret = iconv($from_encoding, $to_encoding, $str);
	}

	return $ret;
}

/**
* FUNCTION calc_memory
* 
* Calculate memory allocation starting from START OF static content export.
* Return currently allocated memory in bytes and inside this class.
* 
* @param integer $start_time 
* @return integer $mem 
*/
function calc_memory($start_amount) {
	return memory_get_usage() - $start_amount;
}


/**
* FUNCTION convert_adr
* 
* 
* @param -
* @return -
*/
function convert_adr($table_array) {

	/*10 tables each with their own strucure will be looked for. If found all the data in each of them will the converted as specified . 

	each of the tables will go through this process:
	
	1. get table fields
	2. get all the table data
	3. convert each row 
	4. update each row

	*/

	global $DB, $BLOB_TYPE_ARR;

	$language = $_POST['language'];

	$obj_count = 0;

	$j=0;

  echo "ADR conversion in progress: <br>";
  flush();

/*
1. ext_pp_asutus conversion
*/

	# Confirm table existance
	$sql = "SHOW TABLES LIKE 'ext_pp_asutus'";
	$result = new SQL($sql);
	
	if ($result->rows > 0 && in_array('ext_pp_asutus', (array)$table_array)) {	
  	## get real table fields	
  	$objekt_fields = array();
  	$objekt_fields = split(",",$DB->get_fields(array(tabel => "ext_pp_asutus")));
  
  	$sql = $DB->prepare("SELECT * FROM ext_pp_asutus");
  	$sth = new SQL($sql);
  	if (!$sth->error) {  
  		while($old_data = $sth->fetch()) {
  
  			#### GENERATE new data
  			$new_data = array();
  			foreach($objekt_fields as $fieldname){
  				$new_data[$fieldname] = convert_value($old_data[$fieldname]);
  			}
  
  			#### UPDATE objekt
  			$values_arr = array();
  			foreach ($new_data as $field=>$val) { $values_arr[]=$field."='".mysql_real_escape_string(trim($val))."'"; }
  			$sql = "UPDATE ext_pp_asutus SET ".join(",",$values_arr)." WHERE asutus_id='".$old_data['asutus_id']."'";
  			$i = run_sql($sql,1,0);	
  			$j++;
  			$obj_count += (int)$i;
  
  			#################### / CONTENT
  			if(($j % 100)==0){
  				echo "...";
  				flush(); 
  				#sleep(1);
  			}
  			if(($j % 1000)==0){
  				echo "<br>";
  				flush(); 
  				#sleep(1);
  			}
  		}
  		
  		echo '<p>ext_pp_asutus done!</p>';		
  	}
  }


/*
2. ext_pp_asutus_grupp conversion
*/
	
	# Confirm table existance
	$sql = "SHOW TABLES LIKE 'ext_pp_asutus_grupp'";
	$result = new SQL($sql);
	
	if ($result->rows > 0 && in_array('ext_pp_asutus_grupp', (array)$table_array)) {
    ## get real table fields 
  	$objekt_fields = array();
  	$objekt_fields = split(",",$DB->get_fields(array(tabel => "ext_pp_asutus_grupp")));
  
  	$sql = $DB->prepare("SELECT * FROM ext_pp_asutus_grupp");
  	$sth = new SQL($sql);
  	if (!$sth->error) {  
  		while($old_data = $sth->fetch()) {
  		
  
  
  			#### GENERATE new data
  			$new_data = array();
  			foreach($objekt_fields as $fieldname){
  
  				$new_data[$fieldname] = convert_value($old_data[$fieldname]);
  			}
  
  			#### UPDATE objekt
  			$values_arr = array();
  			foreach ($new_data as $field=>$val) { $values_arr[]=$field."='".mysql_real_escape_string(trim($val))."'"; }
  			$sql = "UPDATE ext_pp_asutus_grupp SET ".join(",",$values_arr)." WHERE asutus_id='".$old_data['asutus_id']."' and grupp_id='".$old_data['grupp_id']."'";
  			$i = run_sql($sql,1,0);	
  			$j++;
  			$obj_count += (int)$i;
  
  			#################### / CONTENT
  			if(($j % 100)==0){
  				echo "...";
  				flush(); 
  				#sleep(1);
  			}
  			if(($j % 1000)==0){
  				echo "<br>";
  				flush(); 
  				#sleep(1);
  			}
  		}
  		
  		echo '<p>ext_pp_asutus_grupp done!</p>';
  	}
  }

/*
3. ext_pp_asutus_xml conversion
*/

	# Confirm table existance
	$sql = "SHOW TABLES LIKE 'ext_pp_asutus_xml'";
	$result = new SQL($sql);
	
	if ($result->rows > 0 && in_array('ext_pp_asutus_xml', (array)$table_array)) {	
  	## get real table fields
  	$objekt_fields = array();
  	$objekt_fields = split(",",$DB->get_fields(array(tabel => "ext_pp_asutus_xml")));
  
  	$sql = $DB->prepare("SELECT * FROM ext_pp_asutus_xml");
  	$sth = new SQL($sql);
  	if (!$sth->error) { 
  		while($old_data = $sth->fetch()) {
  
  			#### GENERATE new data
  			$new_data = array();
  			foreach($objekt_fields as $fieldname){
  
  				$new_data[$fieldname] = convert_value($old_data[$fieldname]);
  			}
  
  			#### UPDATE objekt
  			$values_arr = array();
  			foreach ($new_data as $field=>$val) { $values_arr[]=$field."='".mysql_real_escape_string(trim($val))."'"; }
  			$sql = "UPDATE ext_pp_asutus_xml SET ".join(",",$values_arr)." WHERE id='".$old_data['id']."'";
  			$i = run_sql($sql,1,0);	
  			$j++;
  			$obj_count += (int)$i;
  
  			#################### / CONTENT
  			if(($j % 100)==0){
  				echo "...";
  				flush(); 
  				#sleep(1);
  			}
  			if(($j % 1000)==0){
  				echo "<br>";
  				flush(); 
  				#sleep(1);
  			}
  		}
  		
  		echo '<p>ext_pp_asutus_xml done!</p>';
  	}	
	}

/*
7. ext_pp_dummy
*/


	# Confirm table existance
	$sql = "SHOW TABLES LIKE 'ext_pp_dummy'";
	$result = new SQL($sql);
	
	if ($result->rows > 0 && in_array('ext_pp_dummy', (array)$table_array)) {		
  	## get real table fields
  	$objekt_fields = array();
  	$objekt_fields = split(",",$DB->get_fields(array(tabel => "ext_pp_dummy")));	
  
  	$sql = $DB->prepare("SELECT * FROM ext_pp_dummy");
  	$sth = new SQL($sql);
  	if (!$sth->error) { 
  		while($old_data = $sth->fetch()) {
  
  
  			#### GENERATE new data
  			$new_data = array();
  			foreach($objekt_fields as $fieldname){
  
  				$new_data[$fieldname] = convert_value($old_data[$fieldname]);
  			}
  
  			#### UPDATE objekt
  			$values_arr = array();
  			foreach ($new_data as $field=>$val) { $values_arr[]=$field."='".mysql_real_escape_string(trim($val))."'"; }
  			$sql = "UPDATE ext_pp_dummy SET ".join(",",$values_arr)." WHERE type='".$old_data['type']."' and value1='".$old_data['value1']."' and value2='".$old_data['value2']."' and value3='".$old_data['value3']."'";
  			$i = run_sql($sql,1,0);	
  			$j++;
  			$obj_count += (int)$i;
  
  			#################### / CONTENT
  			if(($j % 100)==0){
  				echo "...";
  				flush(); 
  				#sleep(1);
  			}
  			if(($j % 1000)==0){
  				echo "<br>";
  				flush(); 
  				#sleep(1);
  			}
  		}
  		
  		echo '<p>ext_pp_dummy done!</p>';
  	}
  }


/*
8. ext_pp_service
*/

	# Confirm table existance
	$sql = "SHOW TABLES LIKE 'ext_pp_service'";
	$result = new SQL($sql);
	
	if ($result->rows > 0 && in_array('ext_pp_service', (array)$table_array)) {		
  	## get real table fields
  	$objekt_fields = array();
  	$objekt_fields = split(",",$DB->get_fields(array(tabel => "ext_pp_service")));
  
  	$sql = $DB->prepare("SELECT * FROM ext_pp_service");
  	$sth = new SQL($sql);
  	if (!$sth->error) { 
  		while($old_data = $sth->fetch()) { 		
  
  				#### GENERATE new data
  				$new_data = array();
  				foreach($objekt_fields as $fieldname){
  
  					$new_data[$fieldname] = convert_value($old_data[$fieldname]);
  				}
  
  				#### UPDATE objekt
  				$values_arr = array();
  			foreach ($new_data as $field=>$val) { $values_arr[]=$field."='".mysql_real_escape_string(trim($val))."'"; }
  				$sql = "UPDATE ext_pp_service SET ".join(",",$values_arr)." WHERE id='".$old_data['id']."'";
  				$i = run_sql($sql,1,0);	
  				$j++;
  				$obj_count += (int)$i;
  
  				#################### / CONTENT
  				if(($j % 100)==0){
  					echo "...";
  					flush(); 
  				}
  				if(($j % 1000)==0){
  					echo "<br>";
  					flush(); 
  					#sleep(1);
  				}
  		}
  		
  		echo '<p>ext_pp_service done!</p>';
  	}
  }

/*
9. ext_pp_teabenoue
*/

	# Confirm table existance
	$sql = "SHOW TABLES LIKE 'ext_pp_teabenoue'";
	$result = new SQL($sql);
	
	if ($result->rows > 0 && in_array('ext_pp_teabenoue', (array)$table_array)) {			
  	## get real table fields
  	$objekt_fields = array();
  	$objekt_fields = split(",",$DB->get_fields(array(tabel => "ext_pp_teabenoue")));
  
  	$sql = $DB->prepare("SELECT * FROM ext_pp_teabenoue");
  	$sth = new SQL($sql);
  	if (!$sth->error) {
  		while($old_data = $sth->fetch()) {
  
  			#### GENERATE new data
  			$new_data = array();
  			foreach($objekt_fields as $fieldname){
  				$new_data[$fieldname] = convert_value($old_data[$fieldname]);
  			}
  
  			#### UPDATE objekt
  			$values_arr = array();
  			foreach ($new_data as $field=>$val) { $values_arr[]=$field."='".mysql_real_escape_string(trim($val))."'"; }
  			$sql = "UPDATE ext_pp_teabenoue SET ".join(",",$values_arr)." WHERE id='".$old_data['id']."'";
  			$i = run_sql($sql,1,0);	
  			$j++;
  			$obj_count += (int)$i;
  
  			#################### / CONTENT
  			if(($j % 100)==0){
  				echo "...";
  				flush(); 
  			}
  			if(($j % 1000)==0){
  				echo "<br>";
  				flush();
  				#sleep(1);
  			}
  		}
  		
      echo '<p>ext_pp_teabenoue done!</p>';
  	}
  }
/*
10. ext_pp_teema
*/

	# Confirm table existance
	$sql = "SHOW TABLES LIKE 'ext_pp_teema'";
	$result = new SQL($sql);
	
	if ($result->rows > 0 && in_array('ext_pp_teema', (array)$table_array)) {	
  	## get real table fields
  	$objekt_fields = array();
  	$objekt_fields = split(",",$DB->get_fields(array(tabel => "ext_pp_teema")));
  
  	$sql = $DB->prepare("SELECT * FROM ext_pp_teema");
  	$sth = new SQL($sql);
  	if (!$sth->error) { 
  		while($old_data = $sth->fetch()) {
  		
  
  			#### GENERATE new data
  			$new_data = array();
  			foreach($objekt_fields as $fieldname){
  				$new_data[$fieldname] = convert_value($old_data[$fieldname]);
  			}
  
  			#### UPDATE objekt
  			$values_arr = array();
  			foreach ($new_data as $field=>$val) { $values_arr[]=$field."='".mysql_real_escape_string(trim($val))."'"; }
  			$sql = "UPDATE ext_pp_teema SET ".join(",",$values_arr)." WHERE teema_id='".$old_data['teema_id']."'";
  			$i = run_sql($sql,1,0);	
  			$j++;
  			$obj_count += (int)$i;
  
  			#################### / CONTENT
  			if(($j % 100)==0){
  				echo "...";
  				flush(); 
  			}
  			if(($j % 1000)==0){
  				echo "<br>";
  				flush(); 
  			}
  		}
  		
      echo '<p>ext_pp_teema done!</p>';
  	}
  }
/*
4. ext_pp_dok_teg
*/

	# Confirm table existance
	$sql = "SHOW TABLES LIKE 'ext_pp_dok_teg'";
	$result = new SQL($sql);
	
	if ($result->rows > 0 && in_array('ext_pp_dok_teg', (array)$table_array)) {		
  	## get real table fields
  	$objekt_fields = array();
  	$objekt_fields = split(",",$DB->get_fields(array(tabel => "ext_pp_dok_teg")));
  
  	$sql = $DB->prepare("SELECT * FROM ext_pp_dok_teg");
  	$sth = new SQL($sql);
  	if (!$sth->error) { 
  		while($old_data = $sth->fetch()) {
  
  			#### GENERATE new data
  			$new_data = array();
  			foreach($objekt_fields as $fieldname){
  
  				$new_data[$fieldname] = convert_value($old_data[$fieldname]);
  			}
  
  			#### UPDATE objekt
  			$values_arr = array();
  			foreach ($new_data as $field=>$val) { $values_arr[]=$field."='".mysql_real_escape_string(trim($val))."'"; }
  			$sql = "UPDATE ext_pp_dok_teg SET ".join(",",$values_arr)." WHERE id='".$old_data['id']."'";
  			$i = run_sql($sql,1,0);	
  			$j++;
  			$obj_count += (int)$i;
  
  			#################### / CONTENT
  			if(($j % 100)==0){
  				echo "...";
  				flush(); 
  
  			}
  			if(($j % 1000)==0){
  				echo "<br>";
  				flush(); 
  
  			}
  
  		}
  		
  		echo '<p>ext_pp_dok_teg done!</p>';
  	}
  }

/*
5. ext_pp_dokumendipuu
*/

	# Confirm table existance
	$sql = "SHOW TABLES LIKE 'ext_pp_dokumendipuu'";
	$result = new SQL($sql);
	
	if ($result->rows > 0 && in_array('ext_pp_dokumendipuu', (array)$table_array)) {	
  	## get real table fields
  	$objekt_fields = array();
  	$objekt_fields = split(",",$DB->get_fields(array(tabel => "ext_pp_dokumendipuu")));
  
  	$sql = $DB->prepare("SELECT * FROM ext_pp_dokumendipuu");
  	$sth = new SQL($sql);
  	if (!$sth->error) {
  		while($old_data = $sth->fetch()) {
  		
  
  
  			#### GENERATE new data
  			$new_data = array();
  			foreach($objekt_fields as $fieldname){
  
  				$new_data[$fieldname] = convert_value($old_data[$fieldname]);
  			}
  
  			#### UPDATE objekt
  			$values_arr = array();
  			foreach ($new_data as $field=>$val) { $values_arr[]=$field."='".mysql_real_escape_string(trim($val))."'"; }
  			$sql = "UPDATE ext_pp_dokumendipuu SET ".join(",",$values_arr)." WHERE id='".$old_data['id']."'";
  
  			$i = run_sql($sql,1,0);	
  			$j++;
  			$obj_count += (int)$i;
  
  			#################### / CONTENT
  			if(($j % 100)==0){
  				echo "...";
  				flush(); 
  				#sleep(1);
  			}
  			if(($j % 1000)==0){
  				echo "<br>";
  				flush(); 
  				#sleep(1);
  			}
  		}
  		
      echo '<p>ext_pp_dokumendipuu done!</p>';
  	}
  }
  
/*
6. ext_pp_dokument
*/

	# Confirm table existance
	$sql = "SHOW TABLES LIKE 'ext_pp_dokument'";
	$result = new SQL($sql);
	
	if ($result->rows > 0 && in_array('ext_pp_dokument', (array)$table_array)) {		
  	## get real table fields
  	$objekt_fields = array();
  	$objekt_fields = split(",",$DB->get_fields(array(tabel => "ext_pp_dokument")));
  
  	$sql = $DB->prepare("SELECT * FROM ext_pp_dokument");
  	$sth = new SQL($sql);
  	if (!$sth->error) {
  		while($old_data = $sth->fetch()) {
  
  			#### GENERATE new data
  			$new_data = array();
  			foreach($objekt_fields as $fieldname){
  
  				$new_data[$fieldname] = convert_value($old_data[$fieldname]);
  			}
  
  			#### UPDATE objekt
  			$values_arr = array();
  			foreach ($new_data as $field=>$val) { $values_arr[]=$field."='".mysql_real_escape_string(trim($val))."'"; }
  			$sql = "UPDATE ext_pp_dokument SET ".join(",",$values_arr)." WHERE dok_id='".$old_data['dok_id']."'";
  			$i = run_sql($sql,1,0);	
  			$j++;
  			$obj_count += (int)$i;
  
  			#################### / CONTENT
  			if(($j % 100)==0){
  				echo "...";
  				flush(); 
  				#sleep(1);
  			}
  			if(($j % 1000)==0){
  				echo "<br>";
  				flush(); 
  				#sleep(1);
  			}
  
  		}
  		
      echo '<p>ext_pp_dokument done!</p>';
  	}
  }

	return $obj_count;
}


function fix_word_symbols(){



#   - Wordi alustavad jutumrgid
#   - Wordi alustavad jutumrgid
#   - Wordi lpetavad jutumrgid

$sql = "UPDATE obj_artikkel SET lyhi=REPLACE(lyhi,'','\"'), sisu=REPLACE(sisu,'','\"') WHERE lyhi like '%%' or sisu like '%%'";
$i = run_sql($sql,1,0);	

print "Asendada alustavad jutumrgid: ".$i. " kirjet (obj_artikkel.lyhi ja .sisu).<br />";

$sql = "UPDATE obj_artikkel SET lyhi=REPLACE(lyhi,'','\"'), sisu=REPLACE(sisu,'','\"') WHERE lyhi like '%%' or sisu like '%%'";
$i = run_sql($sql,1,0);	
print "Asendada alustavad jutumrgid: ".$i. " kirjet (obj_artikkel.lyhi ja .sisu).<br />";

$sql = "UPDATE obj_artikkel SET lyhi=REPLACE(lyhi,'','\"'), sisu=REPLACE(sisu,'','\"') WHERE lyhi like '%%' or sisu like '%%'";
$i = run_sql($sql,1,0);	
print "Asendada lpetavad jutumrgid: ".$i. " kirjet (obj_artikkel.lyhi ja .sisu).<br />";

#   - Wordi lakoma
$sql = "UPDATE obj_artikkel SET lyhi=REPLACE(lyhi,'','\''), sisu=REPLACE(sisu,'','\'') WHERE lyhi like '%%' or sisu like '%%'";
$i = run_sql($sql,1,0);	
print "Asendada lakoma: ".$i. " kirjet (obj_artikkel.lyhi ja .sisu).<br />";


#  pikk sidekriips

$sql = "UPDATE obj_artikkel SET lyhi=REPLACE(lyhi,'','-'), sisu=REPLACE(sisu,'','-') WHERE lyhi like '%%' or sisu like '%%'";
$i = run_sql($sql,1,0);	
print "Asendada pikk sidekriips: ".$i. " kirjet (obj_artikkel.lyhi ja .sisu).<br />";

# kigi objektide pealkirjad
$sql = "UPDATE objekt SET pealkiri=REPLACE(pealkiri,'','-') WHERE pealkiri like '%%'";
$i = run_sql($sql,1,0);	
print "Asendada pikk sidekriips: ".$i. " kirjet (objekt.pealkiri).<br />";

echo "<br /><br />Part 1 of the conversion is complete<br /><br />";
}


function fix_susisev($from,$to){

	global $site;

	###### obj_artikkel

	$sql = "SELECT objekt_id FROM obj_artikkel WHERE lyhi like '%".$from."%' or sisu like '%".$from."%'";
	$i = run_sql($sql,1,0);	
	echo "Asenda ".$to.". Leitud ".$from.": ".$i."<br />";
	$sql = "UPDATE obj_artikkel SET lyhi=REPLACE(lyhi,'".$from."','".$to."'), sisu=REPLACE(sisu,'".$from."','".$to."') WHERE lyhi like '%".$from."%' or sisu like '%".$from."%'";
	$i = run_sql($sql,1,0);	
	#printr(htmlspecialchars($sql));
	print "Asendada ".$from." => ".$to.": ".$i. " kirjet (obj_artikkel.lyhi ja .sisu).<br />";

	###### objekt

	$sql = "SELECT objekt_id FROM objekt WHERE pealkiri like '%".$from."%' or pealkiri_strip like '%".$from."%' or sisu_strip like '%".$from."%'";
	$i = run_sql($sql,1,0);	
	echo "Asenda ".$to.". Leitud ".$from.": ".$i."<br />";
	$sql = "UPDATE objekt SET pealkiri=REPLACE(pealkiri,'".$from."','".$to."'), pealkiri_strip=REPLACE(pealkiri_strip,'".$from."','".$to."') , sisu_strip=REPLACE(sisu_strip,'".$from."','".$to."') WHERE pealkiri like '%".$from."%' or pealkiri_strip like '%".$from."%' or sisu_strip like '%".$from."%'";
	$i = run_sql($sql,1,0);	
	#printr(htmlspecialchars($sql));
	print "Asendada ".$from." => ".$to.": ".$i. " kirjet (objekt.pealkiri, .pealkiri_strip .sisu_strip).<br />";

	###### ext_pp_dokument
	$sql = "SHOW TABLES LIKE 'ext_pp_dokument'";
	$result = new SQL($sql);
	
	if ($result->rows > 0) {
  	$sql = "SELECT dok_id FROM ext_pp_dokument WHERE kellelt like '%".$from."%' or kellele like '%".$from."%' or pealkiri like '%".$from."%' or sisu like '%".$from."%'";
  	$i = run_sql($sql,1,0);	
  	echo "Asenda ".$to.". Leitud ".$from.": ".$i."<br />";
  	
  	$sql = "UPDATE ext_pp_dokument SET kellelt = REPLACE(kellelt,'".$from."','".$to."'), kellele=REPLACE(kellele,'".$from."','".$to."'), pealkiri=REPLACE(pealkiri,'".$from."','".$to."'), sisu=REPLACE(sisu,'".$from."','".$to."') WHERE kellelt like '%".$from."%' or kellele like '%".$from."%' or pealkiri like '%".$from."%' or sisu like '%".$from."%'";
  	$i = run_sql($sql,1,0);
    print "Asendada ".$from." => ".$to.": ".$i. " kirjet (ext_pp_dokument.kellelt, .kellele .pealkiri .sisu).<br />";	
  }

}
?>