<?php
session_start();

// Checks if user has editing rights to specified class
function isEditable($user, $class)
{
	global $objId, $users;
	
	if ((count($user["rights"]) == 1) && ($user["rights"][0]["class_name"] == null))
		return "checked=\"checked\"";
		
	foreach ($user["rights"] as $rights)
	{
		if ($rights["class_name"] == $class["class_name"])
			return "checked=\"checked\"";
	}
	
	return "";
}

$objId = (int)$_REQUEST["objId"];

//define('C_DOC_ROOT', $_SERVER['DOCUMENT_ROOT'] . '/Mwx.Fi');
define('C_DOC_ROOT', '/home/finants/html/newstuff');
//define('C_DOC_ROOT', '/home/finants/test2/newstuff');

include_once C_DOC_ROOT . '/shared/classes/core/simplerequest.cls.php';

$GLOBALS['debug'] = 1;
$GLOBALS['showErrors'] = 1;

include_once C_DOC_ROOT . '/local/classes/saurus/saurusenv.cls.php';
$lng = saurusenv::getLanguage();
include_once C_DOC_ROOT . '/cfg/' . $lng . '.res.php';
require_once C_DOC_ROOT . '/local/classes/db/objectq.cls.php';
require_once C_DOC_ROOT . '/shared/classes/core/resources.cls.php';

// Check rights
if (!saurusenv::isAdmin())
{
	exit();
}

$oq = new objectq();

$obj = $oq->getObjectById($objId, $lng);
$schema = $oq->getSchema($obj['class_name'], $lng);
$users = $oq->getAllObjectWriters($objId);

array_unshift($schema["classes"], array("class_name" => "attributes", "class_value" => resources::getText("attributes")));

// Handle save
if (!empty($_POST["btnSave"]))
{
	$toDelete = array();
	$toInsert = array();
	
	foreach ($users as $user)
	{
		$user["rights"] = $oq->getObjectWriterClasses($objId, $user["username"]);
		
		$rights = array();
		
		$allSet = true;
		foreach ($schema["classes"] as $class)
		{
			if (!empty($_POST["chk_" . $user["username"] . "_" . str_replace(".", "_", $class["class_name"])]))
			{
				$rights[] = array("val_object_id" => $objId, "username" => $user["username"], "class_name" => $class["class_name"]);
			}
			else
				$allSet = false;
		}
		
		if ($allSet)
		{
			// All checkboxes are set, so we just add one entry with class_name set to NULL (which means 'has access to everything')
			$rights = array();
			$rights[] = array("val_object_id" => $objId, "username" => $user["username"], "class_name" => NULL);
		}
		
		$toDelete = array_merge($toDelete, $user["rights"]);
		$toInsert = array_merge($toInsert, $rights);
	}
	
	$oq->saveObjectWriterClasses($toDelete, $toInsert);
}
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
	<head>
		<title>Kasutajaiguste haldus</title>
		<link rel="stylesheet" href="/newstuff/css/template.css" type="text/css">
		<link rel="stylesheet" href="/newstuff/css/register.css" type="text/css">
		<!--<link rel="stylesheet" type="text/css" href="http://www.fi.ee/saxon_web/styles.css">-->
		<!--<meta http-equiv="Content-Type" content="text/html; charset=utf-8">-->
		<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1">
		<style>
		table#tblUserlist td.itemCell
		{
			border-bottom:1px solid #CCCCCC;
			border-right:1px solid #CCCCCC;
		}
		</style>
	</head>
	<body>
		<form method="post" name="frmUsers">
		<input type="hidden" name="objId" value="<?= $objId ?>">

		<div id="contentarea">
		
		<table>
			<tr>
				<td id="content">
				
					<table id="tblUserlist" border="0" cellspacing="0" cellpadding="5">
						<tr bgcolor="#CCCCCC">
							<td>&nbsp;</td>
							<?php foreach ($schema["classes"] as $class) { ?>
							<td align="center"><strong><?= $class["class_value"] ?></strong></td>
							<?php } ?>
						</tr>
						<?php foreach ($users as $user) {
							$user["rights"] = $oq->getObjectWriterClasses($objId, $user["username"]);
						?>
						<tr>
							<td bgcolor="#CCCCCC"><strong><?= $user["username"] ?></strong></td>
							<?php foreach ($schema["classes"] as $class) { ?>
							<td align="center" valign="middle" class="itemCell">
								<input type="checkbox" name="chk_<?= $user["username"] ?>_<?= str_replace(".", "_", $class["class_name"]) ?>" value="1" <?= isEditable($user, $class) ?> />
							</td>
							<?php } ?>
						</tr>
						<?php } ?>
					</table>
					<center><input type="submit" name="btnSave" value="<?= resources::getText('save') ?>" /></center>
			
				</td>
			</tr>
		</table>
		
		</div>
		
		</form>
	</body>
</html>