<?php
class WebService_DigiDocService_DigiDocService extends SOAP_Client
{
    function WebService_DigiDocService_DigiDocService()
{
        $this->SOAP_Client("https://digidocservice.sk.ee/DigiDocService", 0);
    }
    function &StartSession($SigningProfile, $SigDocXML, $bHoldSession, $datafile) {
        // datafile is a ComplexType DataFileData,
        //refer to wsdl for more info
        $datafile =& new SOAP_Value('datafile','{http://www.sk.ee/DigiDocService/DigiDocService_2_3.wsdl}DataFileData',$datafile);
        return $this->call("StartSession", 
                        $v = array("SigningProfile"=>$SigningProfile, "SigDocXML"=>$SigDocXML, "bHoldSession"=>$bHoldSession, "datafile"=>$datafile), 
                        array('namespace'=>'http://www.sk.ee/DigiDocService/DigiDocService_2_3.wsdl',
                            'soapaction'=>'',
                            'style'=>'rpc',
                            'use'=>'encoded' ));
    }
    function &CloseSession($Sesscode) {
        return $this->call("CloseSession", 
                        $v = array("Sesscode"=>$Sesscode), 
                        array('namespace'=>'http://www.sk.ee/DigiDocService/DigiDocService_2_3.wsdl',
                            'soapaction'=>'',
                            'style'=>'rpc',
                            'use'=>'encoded' ));
    }
    function &CreateSignedDoc($Sesscode, $Format, $Version) {
        return $this->call("CreateSignedDoc", 
                        $v = array("Sesscode"=>$Sesscode, "Format"=>$Format, "Version"=>$Version), 
                        array('namespace'=>'http://www.sk.ee/DigiDocService/DigiDocService_2_3.wsdl',
                            'soapaction'=>'',
                            'style'=>'rpc',
                            'use'=>'encoded' ));
    }
    function &AddDataFile($Sesscode, $FileName, $MimeType, $ContentType, $Size, $DigestType, $DigestValue, $Content) {
        return $this->call("AddDataFile", 
                        $v = array("Sesscode"=>$Sesscode, "FileName"=>$FileName, "MimeType"=>$MimeType, "ContentType"=>$ContentType, "Size"=>$Size, "DigestType"=>$DigestType, "DigestValue"=>$DigestValue, "Content"=>$Content), 
                        array('namespace'=>'http://www.sk.ee/DigiDocService/DigiDocService_2_3.wsdl',
                            'soapaction'=>'',
                            'style'=>'rpc',
                            'use'=>'encoded' ));
    }
    function &RemoveDataFile($Sesscode, $DataFileId) {
        return $this->call("RemoveDataFile", 
                        $v = array("Sesscode"=>$Sesscode, "DataFileId"=>$DataFileId), 
                        array('namespace'=>'http://www.sk.ee/DigiDocService/DigiDocService_2_3.wsdl',
                            'soapaction'=>'',
                            'style'=>'rpc',
                            'use'=>'encoded' ));
    }
    function &GetSignedDoc($Sesscode) {
        return $this->call("GetSignedDoc", 
                        $v = array("Sesscode"=>$Sesscode), 
                        array('namespace'=>'http://www.sk.ee/DigiDocService/DigiDocService_2_3.wsdl',
                            'soapaction'=>'',
                            'style'=>'rpc',
                            'use'=>'encoded' ));
    }
    function &GetSignedDocInfo($Sesscode) {
        return $this->call("GetSignedDocInfo", 
                        $v = array("Sesscode"=>$Sesscode), 
                        array('namespace'=>'http://www.sk.ee/DigiDocService/DigiDocService_2_3.wsdl',
                            'soapaction'=>'',
                            'style'=>'rpc',
                            'use'=>'encoded' ));
    }
    function &GetDataFile($Sesscode, $DataFileId) {
        return $this->call("GetDataFile", 
                        $v = array("Sesscode"=>$Sesscode, "DataFileId"=>$DataFileId), 
                        array('namespace'=>'http://www.sk.ee/DigiDocService/DigiDocService_2_3.wsdl',
                            'soapaction'=>'',
                            'style'=>'rpc',
                            'use'=>'encoded' ));
    }
    function &GetSignersCertificate($Sesscode, $SignatureId) {
        return $this->call("GetSignersCertificate", 
                        $v = array("Sesscode"=>$Sesscode, "SignatureId"=>$SignatureId), 
                        array('namespace'=>'http://www.sk.ee/DigiDocService/DigiDocService_2_3.wsdl',
                            'soapaction'=>'',
                            'style'=>'rpc',
                            'use'=>'encoded' ));
    }
    function &GetNotarysCertificate($Sesscode, $SignatureId) {
        return $this->call("GetNotarysCertificate", 
                        $v = array("Sesscode"=>$Sesscode, "SignatureId"=>$SignatureId), 
                        array('namespace'=>'http://www.sk.ee/DigiDocService/DigiDocService_2_3.wsdl',
                            'soapaction'=>'',
                            'style'=>'rpc',
                            'use'=>'encoded' ));
    }
    function &GetNotary($Sesscode, $SignatureId) {
        return $this->call("GetNotary", 
                        $v = array("Sesscode"=>$Sesscode, "SignatureId"=>$SignatureId), 
                        array('namespace'=>'http://www.sk.ee/DigiDocService/DigiDocService_2_3.wsdl',
                            'soapaction'=>'',
                            'style'=>'rpc',
                            'use'=>'encoded' ));
    }
    function &GetTSACertificate($Sesscode, $TimestampId) {
        return $this->call("GetTSACertificate", 
                        $v = array("Sesscode"=>$Sesscode, "TimestampId"=>$TimestampId), 
                        array('namespace'=>'http://www.sk.ee/DigiDocService/DigiDocService_2_3.wsdl',
                            'soapaction'=>'',
                            'style'=>'rpc',
                            'use'=>'encoded' ));
    }
    function &GetTimestamp($Sesscode, $TimestampId) {
        return $this->call("GetTimestamp", 
                        $v = array("Sesscode"=>$Sesscode, "TimestampId"=>$TimestampId), 
                        array('namespace'=>'http://www.sk.ee/DigiDocService/DigiDocService_2_3.wsdl',
                            'soapaction'=>'',
                            'style'=>'rpc',
                            'use'=>'encoded' ));
    }
    function &GetCRL($Sesscode, $SignatureId) {
        return $this->call("GetCRL", 
                        $v = array("Sesscode"=>$Sesscode, "SignatureId"=>$SignatureId), 
                        array('namespace'=>'http://www.sk.ee/DigiDocService/DigiDocService_2_3.wsdl',
                            'soapaction'=>'',
                            'style'=>'rpc',
                            'use'=>'encoded' ));
    }
    function &GetSignatureModules($Sesscode, $Platform, $Phase, $Type) {
        return $this->call("GetSignatureModules", 
                        $v = array("Sesscode"=>$Sesscode, "Platform"=>$Platform, "Phase"=>$Phase, "Type"=>$Type), 
                        array('namespace'=>'http://www.sk.ee/DigiDocService/DigiDocService_2_3.wsdl',
                            'soapaction'=>'',
                            'style'=>'rpc',
                            'use'=>'encoded' ));
    }
    function &PrepareSignature($Sesscode, $SignersCertificate, $SignersTokenId, $Role, $City, $State, $PostalCode, $Country, $SigningProfile) {
        return $this->call("PrepareSignature", 
                        $v = array("Sesscode"=>$Sesscode, "SignersCertificate"=>$SignersCertificate, "SignersTokenId"=>$SignersTokenId, "Role"=>$Role, "City"=>$City, "State"=>$State, "PostalCode"=>$PostalCode, "Country"=>$Country, "SigningProfile"=>$SigningProfile), 
                        array('namespace'=>'http://www.sk.ee/DigiDocService/DigiDocService_2_3.wsdl',
                            'soapaction'=>'',
                            'style'=>'rpc',
                            'use'=>'encoded' ));
    }
    function &FinalizeSignature($Sesscode, $SignatureId, $SignatureValue) {
        return $this->call("FinalizeSignature", 
                        $v = array("Sesscode"=>$Sesscode, "SignatureId"=>$SignatureId, "SignatureValue"=>$SignatureValue), 
                        array('namespace'=>'http://www.sk.ee/DigiDocService/DigiDocService_2_3.wsdl',
                            'soapaction'=>'',
                            'style'=>'rpc',
                            'use'=>'encoded' ));
    }
    function &RemoveSignature($Sesscode, $SignatureId) {
        return $this->call("RemoveSignature", 
                        $v = array("Sesscode"=>$Sesscode, "SignatureId"=>$SignatureId), 
                        array('namespace'=>'http://www.sk.ee/DigiDocService/DigiDocService_2_3.wsdl',
                            'soapaction'=>'',
                            'style'=>'rpc',
                            'use'=>'encoded' ));
    }
    function &GetVersion() {
        return $this->call("GetVersion", 
                        $v = null, 
                        array('namespace'=>'http://www.sk.ee/DigiDocService/DigiDocService_2_3.wsdl',
                            'soapaction'=>'',
                            'style'=>'rpc',
                            'use'=>'encoded' ));
    }
    function &MobileSign($Sesscode, $SignerIDCode, $SignersCountry, $SignerPhoneNo, $ServiceName, $AdditionalDataToBeDisplayed, $Language, $Role, $City, $StateOrProvince, $PostalCode, $CountryName, $SigningProfile, $MessagingMode, $AsyncConfiguration, $ReturnDocInfo, $ReturnDocData) {
        return $this->call("MobileSign", 
                        $v = array("Sesscode"=>$Sesscode, "SignerIDCode"=>$SignerIDCode, "SignersCountry"=>$SignersCountry, "SignerPhoneNo"=>$SignerPhoneNo, "ServiceName"=>$ServiceName, "AdditionalDataToBeDisplayed"=>$AdditionalDataToBeDisplayed, "Language"=>$Language, "Role"=>$Role, "City"=>$City, "StateOrProvince"=>$StateOrProvince, "PostalCode"=>$PostalCode, "CountryName"=>$CountryName, "SigningProfile"=>$SigningProfile, "MessagingMode"=>$MessagingMode, "AsyncConfiguration"=>$AsyncConfiguration, "ReturnDocInfo"=>$ReturnDocInfo, "ReturnDocData"=>$ReturnDocData), 
                        array('namespace'=>'http://www.sk.ee/DigiDocService/DigiDocService_2_3.wsdl',
                            'soapaction'=>'',
                            'style'=>'rpc',
                            'use'=>'encoded' ));
    }
    function &GetStatusInfo($Sesscode, $ReturnDocInfo, $WaitSignature) {
        return $this->call("GetStatusInfo", 
                        $v = array("Sesscode"=>$Sesscode, "ReturnDocInfo"=>$ReturnDocInfo, "WaitSignature"=>$WaitSignature), 
                        array('namespace'=>'http://www.sk.ee/DigiDocService/DigiDocService_2_3.wsdl',
                            'soapaction'=>'',
                            'style'=>'rpc',
                            'use'=>'encoded' ));
    }
    function &MobileAuthenticate($IDCode, $CountryCode, $PhoneNo, $Language, $ServiceName, $MessageToDisplay, $SPChallenge, $MessagingMode, $AsyncConfiguration, $ReturnCertData, $ReturnRevocationData) {
        return $this->call("MobileAuthenticate", 
                        $v = array("IDCode"=>$IDCode, "CountryCode"=>$CountryCode, "PhoneNo"=>$PhoneNo, "Language"=>$Language, "ServiceName"=>$ServiceName, "MessageToDisplay"=>$MessageToDisplay, "SPChallenge"=>$SPChallenge, "MessagingMode"=>$MessagingMode, "AsyncConfiguration"=>$AsyncConfiguration, "ReturnCertData"=>$ReturnCertData, "ReturnRevocationData"=>$ReturnRevocationData), 
                        array('namespace'=>'http://www.sk.ee/DigiDocService/DigiDocService_2_3.wsdl',
                            'soapaction'=>'',
                            'style'=>'rpc',
                            'use'=>'encoded' ));
    }
    function &GetMobileAuthenticateStatus($Sesscode, $WaitSignature) {
        return $this->call("GetMobileAuthenticateStatus", 
                        $v = array("Sesscode"=>$Sesscode, "WaitSignature"=>$WaitSignature), 
                        array('namespace'=>'http://www.sk.ee/DigiDocService/DigiDocService_2_3.wsdl',
                            'soapaction'=>'',
                            'style'=>'rpc',
                            'use'=>'encoded' ));
    }
    function &MobileCreateSignature($IDCode, $SignersCountry, $PhoneNo, $Language, $ServiceName, $MessageToDisplay, $Role, $City, $StateOrProvince, $PostalCode, $CountryName, $SigningProfile, $DataFiles, $Format, $Version, $SignatureID, $MessagingMode, $AsyncConfiguration) {
        return $this->call("MobileCreateSignature", 
                        $v = array("IDCode"=>$IDCode, "SignersCountry"=>$SignersCountry, "PhoneNo"=>$PhoneNo, "Language"=>$Language, "ServiceName"=>$ServiceName, "MessageToDisplay"=>$MessageToDisplay, "Role"=>$Role, "City"=>$City, "StateOrProvince"=>$StateOrProvince, "PostalCode"=>$PostalCode, "CountryName"=>$CountryName, "SigningProfile"=>$SigningProfile, "DataFiles"=>$DataFiles, "Format"=>$Format, "Version"=>$Version, "SignatureID"=>$SignatureID, "MessagingMode"=>$MessagingMode, "AsyncConfiguration"=>$AsyncConfiguration), 
                        array('namespace'=>'http://www.sk.ee/DigiDocService/DigiDocService_2_3.wsdl',
                            'soapaction'=>'',
                            'style'=>'rpc',
                            'use'=>'encoded' ));
    }
    function &GetMobileCreateSignatureStatus($Sesscode, $WaitSignature) {
        return $this->call("GetMobileCreateSignatureStatus", 
                        $v = array("Sesscode"=>$Sesscode, "WaitSignature"=>$WaitSignature), 
                        array('namespace'=>'http://www.sk.ee/DigiDocService/DigiDocService_2_3.wsdl',
                            'soapaction'=>'',
                            'style'=>'rpc',
                            'use'=>'encoded' ));
    }
    function &GetMobileCertificate($IDCode, $Country, $PhoneNo, $ReturnCertData) {
        return $this->call("GetMobileCertificate", 
                        $v = array("IDCode"=>$IDCode, "Country"=>$Country, "PhoneNo"=>$PhoneNo, "ReturnCertData"=>$ReturnCertData), 
                        array('namespace'=>'http://www.sk.ee/DigiDocService/DigiDocService_2_3.wsdl',
                            'soapaction'=>'',
                            'style'=>'rpc',
                            'use'=>'encoded' ));
    }
    function &GetStatistics() {
        return $this->call("GetStatistics", 
                        $v = null, 
                        array('namespace'=>'http://www.sk.ee/DigiDocService/DigiDocService_2_3.wsdl',
                            'soapaction'=>'',
                            'style'=>'rpc',
                            'use'=>'encoded' ));
    }
}

?>